/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1.inverse;

import propagation.order1.inverse.GICAdvanced;
import search.Solver;
import variables.Variable;

public class GIC2
extends GICAdvanced {
    protected int timestamp;
    protected int[][] stamps;

    public GIC2(Solver solver) {
        super(solver);
        this.stamps = Variable.litterals(solver.pb.variables).intArray();
    }

    protected void handleSolution(Variable x, int a, int[] solution) {
        for (int k = this.cursor - 1; k >= 0; --k) {
            int id = this.supVariableNums[k];
            if (this.stamps[id][solution[id]] == this.timestamp) continue;
            this.stamps[id][solution[id]] = this.timestamp;
            int n = id;
            this.nValuesToBeSupported[n] = this.nValuesToBeSupported[n] - 1;
        }
    }

    @Override
    protected void handleNewSolution(Variable x, int a) {
        this.handleSolution(x, a, this.solver.solManager.lastSolution);
    }

    @Override
    protected void intializationAdvanced() {
        ++this.timestamp;
        this.nSupVariables = 0;
        for (Variable x : this.solver.futVars) {
            if (x.dom.size() <= 1) continue;
            this.nValuesToBeSupported[x.num] = x.dom.size();
            this.supVariableNums[this.nSupVariables++] = x.num;
        }
    }

    @Override
    protected boolean isInverseAdvanced(Variable x, int a) {
        return this.stamps[x.num][a] == this.timestamp || this.isInverse(x, a);
    }
}

