/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1;

import constraints.Constraint;
import constraints.CtrHard;
import interfaces.ObserverConstruction;
import java.util.ArrayList;
import java.util.List;
import propagation.order1.AC;
import search.backtrack.DecisionRecorder;
import search.backtrack.SolverBacktrack;
import utility.Kit;
import variables.Variable;
import variables.domains.Domain;

public abstract class FailedValueBasedConsistency
implements ObserverConstruction {
    protected AC arcConsistency;
    public int nInferredBacktracks;
    public int nInferredRemovals;

    public FailedValueBasedConsistency(AC arcConsistency) {
        this.arcConsistency = arcConsistency;
        arcConsistency.solver.rs.observersConstruction.add(this);
    }

    public abstract boolean enforce();

    public static class ArcFailedValueConsistency
    extends FailedValueBasedConsistency {
        private Variable[][][] conflictsVariable;
        private int[][][] conflictsIndex;
        private Variable[][][][] residuesVariable;
        private int[][][][] residuesIndex;
        private CtrHard[][] binaryConstraints;
        private List<Variable>[][] conflictsVariableList;
        private List<Integer>[][] conflictsIndexList;
        private int[] tuple = new int[2];

        private void updateConflictsList(CtrHard c) {
            assert (c.scp.length == 2);
            Variable x = c.scp[0];
            Variable y = c.scp[1];
            int[] tuple = c.tupleManager.localTuple;
            int a = x.dom.first();
            while (a != -1) {
                tuple[0] = a;
                int b = y.dom.first();
                while (b != -1) {
                    tuple[1] = b;
                    if (!c.checkIndexes(tuple)) {
                        this.conflictsVariableList[x.num][a].add(y);
                        this.conflictsIndexList[x.num][a].add(b);
                        this.conflictsVariableList[y.num][b].add(x);
                        this.conflictsIndexList[y.num][b].add(a);
                    }
                    b = y.dom.next(b);
                }
                a = x.dom.next(a);
            }
        }

        @Override
        public void onConstructionSolverFinished() {
            int a;
            Kit.control(this.arcConsistency.solver.pb.stuff.minCtrArity() == 2 && this.arcConsistency.solver.pb.stuff.maxCtrArity() == 2);
            Variable[] variables = this.arcConsistency.solver.pb.variables;
            Constraint[] constraints = this.arcConsistency.solver.pb.constraints;
            this.conflictsVariableList = new List[variables.length][];
            this.conflictsIndexList = new List[variables.length][];
            for (int i = 0; i < variables.length; ++i) {
                Domain dom = variables[i].dom;
                this.conflictsVariableList[i] = new List[dom.initSize()];
                this.conflictsIndexList[i] = new List[dom.initSize()];
                a = dom.first();
                while (a != -1) {
                    this.conflictsVariableList[i][a] = new ArrayList<Variable>();
                    this.conflictsIndexList[i][a] = new ArrayList<Integer>();
                    a = dom.next(a);
                }
            }
            for (Constraint ctr : constraints) {
                this.updateConflictsList((CtrHard)ctr);
            }
            this.conflictsVariable = new Variable[variables.length][][];
            this.conflictsIndex = new int[variables.length][][];
            this.residuesVariable = new Variable[variables.length][][][];
            this.residuesIndex = new int[variables.length][][][];
            for (int i = 0; i < variables.length; ++i) {
                Domain dom = variables[i].dom;
                this.conflictsVariable[i] = new Variable[dom.initSize()][];
                this.conflictsIndex[i] = new int[dom.initSize()][];
                a = dom.first();
                while (a != -1) {
                    this.conflictsVariable[i][a] = this.conflictsVariableList[i][a].toArray(new Variable[0]);
                    List<Integer> list = this.conflictsIndexList[i][a];
                    this.conflictsIndex[i][a] = Kit.intArray(list);
                    a = dom.next(a);
                }
                this.residuesVariable[i] = new Variable[dom.initSize()][variables.length][];
                this.residuesIndex[i] = new int[dom.initSize()][variables.length][];
                for (int j = 0; j < this.residuesVariable[i].length; ++j) {
                    for (int k = 0; k < this.residuesVariable[i][j].length; ++k) {
                        this.residuesVariable[i][j][k] = new Variable[variables[k].dom.initSize()];
                        this.residuesIndex[i][j][k] = new int[variables[k].dom.initSize()];
                    }
                }
            }
            this.binaryConstraints = new CtrHard[variables.length][variables.length];
            for (Constraint c : constraints) {
                Variable x = c.scp[0];
                Variable y = c.scp[1];
                this.binaryConstraints[x.num][y.num] = (CtrHard)c;
                this.binaryConstraints[y.num][x.num] = (CtrHard)c;
            }
        }

        public ArcFailedValueConsistency(AC arcConsistency) {
            super(arcConsistency);
        }

        @Override
        public boolean enforce() {
            DecisionRecorder dr = ((SolverBacktrack)this.arcConsistency.solver).dr;
            for (int i = dr.decisions.limit; i >= 0; --i) {
                int d = dr.decisions.dense[i];
                if (d > 0 || dr.isFailedAssignment(i)) continue;
                Variable varPivot = dr.varIn(d);
                int idxPivot = dr.idxIn(d);
                Variable[] convar = this.conflictsVariable[varPivot.num][idxPivot];
                int[] conind = this.conflictsIndex[varPivot.num][idxPivot];
                Variable[][] resvar = this.residuesVariable[varPivot.num][idxPivot];
                int[][] resind = this.residuesIndex[varPivot.num][idxPivot];
                Variable x = this.arcConsistency.solver.futVars.first();
                while (x != null) {
                    Variable[] resvar2 = resvar[x.num];
                    int[] resind2 = resind[x.num];
                    Domain domx = x.dom;
                    int sizeBefore = domx.size();
                    int a = domx.first();
                    while (a != -1) {
                        if (resvar2[a] == null || !resvar2[a].dom.isPresent(resind2[a])) {
                            boolean found = false;
                            for (int j = 0; !found && j < convar.length; ++j) {
                                if (!convar[j].dom.isPresent(conind[j])) continue;
                                CtrHard binaryConstraint = this.binaryConstraints[convar[j].num][x.num];
                                if (binaryConstraint == null) {
                                    resvar2[a] = convar[j];
                                    resind2[a] = conind[j];
                                    found = true;
                                    continue;
                                }
                                if (binaryConstraint.scp[0] == x) {
                                    this.tuple[0] = a;
                                    this.tuple[1] = conind[j];
                                } else {
                                    this.tuple[0] = conind[j];
                                    this.tuple[1] = a;
                                }
                                if (!binaryConstraint.checkIndexes(this.tuple)) continue;
                                resvar2[a] = convar[j];
                                resind2[a] = conind[j];
                                found = true;
                            }
                            if (!found) {
                                domx.removeElementary(a);
                            }
                        }
                        a = domx.next(a);
                    }
                    if (sizeBefore != domx.size()) {
                        this.nInferredRemovals += sizeBefore - domx.size();
                        if (domx.size() == 0) {
                            return false;
                        }
                        this.arcConsistency.queue.add(x);
                    }
                    x = this.arcConsistency.solver.futVars.next(x);
                }
            }
            return this.arcConsistency.propagate();
        }
    }

    public static class PartialArcFailedValueConsistency
    extends FailedValueBasedConsistency {
        private static final int CONFLICT_SEEKING_LIMIT = 1000;

        @Override
        public void onConstructionSolverFinished() {
        }

        public PartialArcFailedValueConsistency(AC arcConsistency) {
            super(arcConsistency);
        }

        private Constraint seekUniqueConflictingConstraintFor(Variable x, int a) {
            Constraint ctr = null;
            for (Constraint c : x.ctrs) {
                int p = c.positionOf(x);
                if (Variable.nValidTuplesBoundedAtMaxValueFor(c.scp, p) > 1000L) {
                    return Constraint.TAG;
                }
                if (!((CtrHard)c).seekFirstConflictWith(p, a)) continue;
                if (ctr == null && c.scp.length == 2 && c.scp[p == 1 ? 0 : 1].dom.size() > 1) {
                    ctr = c;
                    continue;
                }
                return Constraint.TAG;
            }
            return ctr;
        }

        @Override
        public boolean enforce() {
            assert (this.arcConsistency.queue.size() == 0);
            DecisionRecorder dr = ((SolverBacktrack)this.arcConsistency.solver).dr;
            for (int i = dr.decisions.limit; i >= 0; ++i) {
                int a;
                int d = dr.decisions.dense[i];
                if (d > 0 || dr.isFailedAssignment(i)) continue;
                Variable x = dr.varIn(d);
                Constraint c = this.seekUniqueConflictingConstraintFor(x, a = dr.idxIn(d));
                if (c == null) {
                    ++this.nInferredBacktracks;
                    return false;
                }
                if (c == Constraint.TAG) continue;
                assert (c.scp.length == 2);
                int p = c.positionOf(x);
                int q = p == 0 ? 1 : 0;
                Variable y = c.scp[q];
                Domain domy = y.dom;
                int sizeBefore = domy.size();
                int b = domy.first();
                while (b != -1) {
                    if (((CtrHard)c).seekFirstSupportWith(p, a, q, b)) {
                        y.dom.removeElementary(b);
                    }
                    b = domy.next(b);
                }
                int nRemovals = sizeBefore - domy.size();
                if (nRemovals <= 0) continue;
                this.nInferredRemovals += nRemovals;
                if (domy.size() == 0) {
                    return false;
                }
                if (this.arcConsistency.runAfterRefutation(y)) continue;
                return false;
            }
            return true;
        }
    }

    public static class FailedValueConsistency
    extends FailedValueBasedConsistency {
        private static final int CONFLICT_SEEKING_LIMIT = 1000;
        private Constraint[][] residues;

        @Override
        public void onConstructionSolverFinished() {
            Variable[] variables = this.arcConsistency.solver.pb.variables;
            this.residues = new Constraint[variables.length][];
            for (int i = 0; i < this.residues.length; ++i) {
                this.residues[i] = new Constraint[variables[i].dom.initSize()];
                for (int j = 0; j < this.residues[i].length; ++j) {
                    this.residues[i][j] = variables[i].ctrs[0];
                }
            }
        }

        public FailedValueConsistency(AC arcConsistency) {
            super(arcConsistency);
        }

        private Constraint seekConflictingConstraintFor(Variable x, int a) {
            Constraint residue = this.residues[x.num][a];
            int p = residue.positionOf(x);
            if (Variable.nValidTuplesBoundedAtMaxValueFor(residue.scp, p) > 1000L || ((CtrHard)residue).seekFirstConflictWith(p, a)) {
                return residue;
            }
            for (Constraint c : x.ctrs) {
                if (c == residue || Variable.nValidTuplesBoundedAtMaxValueFor(c.scp, p = c.positionOf(x)) <= 1000L && !((CtrHard)c).seekFirstConflictWith(p, a)) continue;
                return c;
            }
            return null;
        }

        @Override
        public boolean enforce() {
            DecisionRecorder dr = ((SolverBacktrack)this.arcConsistency.solver).dr;
            for (int i = dr.decisions.limit; i >= 0; --i) {
                int a;
                int d = dr.decisions.dense[i];
                if (d > 0 || dr.isFailedAssignment(i)) continue;
                Variable x = dr.varIn(d);
                Constraint c = this.seekConflictingConstraintFor(x, a = dr.idxIn(d));
                if (c == null) {
                    ++this.nInferredBacktracks;
                    return false;
                }
                this.residues[x.num][a] = c;
            }
            return true;
        }
    }
}

