/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1;

import constraints.Constraint;
import java.util.stream.Stream;
import propagation.order1.FailedValueBasedConsistency;
import propagation.order1.PropagationForward;
import propagation.order1.isomorphism.PropagationIsomorphism;
import search.Solver;
import variables.Variable;

public class AC
extends PropagationForward {
    public final boolean guaranteed;
    public int nPreproRemovals;
    public final FailedValueBasedConsistency fvbc;

    public AC(Solver solver) {
        super(solver);
        this.guaranteed = Constraint.isGuaranteedGACOn(solver.pb.constraints);
        String s = this.cp().propagating.classForFailedValues;
        this.fvbc = s == null || s.length() == 0 ? null : (s.equals("FailedValueConsistency") ? new FailedValueBasedConsistency.FailedValueConsistency(this) : (s.equals("PartialArcFailedValueConsistency") ? new FailedValueBasedConsistency.PartialArcFailedValueConsistency(this) : (s.equals("ArcFailedValueConsistency") ? new FailedValueBasedConsistency.ArcFailedValueConsistency(this) : null)));
    }

    public final boolean enforceArcConsistency() {
        int nBefore = this.pb().nValuesRemoved;
        this.queue.fill();
        boolean consistent = this.propagate();
        this.nPreproRemovals = this.pb().nValuesRemoved - nBefore;
        if (!consistent) {
            return false;
        }
        assert (this.controlArcConsistency());
        return true;
    }

    @Override
    public boolean runInitially() {
        return this.enforceArcConsistency();
    }

    public final boolean enforceArcConsistencyAfterAssignment(Variable x) {
        assert (x.isAssigned() && (this.queue.size() == 0 || this instanceof PropagationIsomorphism)) : this.queue.size() + " " + x.isAssigned();
        if (this.getClass() != AC.class || x.dom.isModifiedAtCurrentDepth() || !this.guaranteed || !this.hasSolverPropagatedAfterLastButOneDecision()) {
            this.queue.add(x);
            if (!this.propagate()) {
                return false;
            }
        }
        assert (this.controlArcConsistency());
        return this.fvbc != null ? this.fvbc.enforce() : true;
    }

    @Override
    public boolean runAfterAssignment(Variable x) {
        return this.enforceArcConsistencyAfterAssignment(x);
    }

    public boolean enforceArcConsistencyAfterRefutation(Variable x) {
        if (!super.runAfterRefutation(x)) {
            return false;
        }
        assert (this.controlArcConsistency());
        return true;
    }

    @Override
    public boolean runAfterRefutation(Variable x) {
        return this.enforceArcConsistencyAfterRefutation(x);
    }

    public boolean controlArcConsistency() {
        return !this.guaranteed || Stream.of(this.solver.pb.constraints).allMatch(c -> c.controlArcConsistency());
    }
}

