/*
 * Decompiled with CFR 0.152.
 */
package propagation;

import heuristics.revisions.HeuristicRevisions;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import learning.LearnerNogoods;
import learning.LearnerStatesDominance;
import propagation.order1.PropagationForward;
import utility.Reflector;
import utility.sets.SetSparse;
import variables.Variable;
import variables.domains.Domain;

public final class PropagationQueue
extends SetSparse {
    public final PropagationForward propagation;
    private final HeuristicRevisions heuristic;
    private final Variable[] variables;
    public int nPicks;
    private LearnerNogoods learnerNogood;
    private LearnerStatesDominance stateDominanceManager;
    private int[] absentValuesSentinel;
    private long[] sentinelLevel;

    public PropagationQueue(PropagationForward propagation) {
        super(propagation.pb().variables.length);
        this.propagation = propagation;
        String className = propagation.pb().stuff.maxDomSize() <= 4 ? HeuristicRevisions.HeuristicRevisionsDirect.First.class.getSimpleName() : propagation.cp().revh.classForRevHeuristic;
        Set<Class<?>> classes = propagation.solver.rs.handlerClasses.map.get(HeuristicRevisions.class);
        this.heuristic = (HeuristicRevisions)Reflector.buildObject2(className, classes, this, propagation.cp().revh.anti);
        this.variables = propagation.pb().variables;
    }

    public Variable var(int i) {
        assert (0 <= i && i <= this.limit);
        return this.variables[this.dense[i]];
    }

    public void add(Variable x) {
        x.timestamp = this.propagation.incrementTime();
        this.add(x.num);
        assert (!x.isAssigned() || x == this.propagation.solver.futVars.lastPast()) : "variable " + x;
    }

    @Override
    public PropagationQueue fill() {
        for (Variable x : this.variables) {
            this.add(x);
        }
        return this;
    }

    public Variable pickAndDelete(int i) {
        ++this.nPicks;
        int num = this.dense[i];
        this.remove(num);
        return this.variables[num];
    }

    public Variable pickAndDelete() {
        return this.pickAndDelete(this.heuristic.bestPosition());
    }

    public boolean isNogoodConsistent(Variable x) {
        if (this.learnerNogood != null && x.dom.size() == 1 && !this.learnerNogood.checkWatchesOf(x, x.dom.first(), false)) {
            return false;
        }
        if (this.sentinelLevel != null) {
            if (this.sentinelLevel[x.num] != this.propagation.solver.stats.numberSafe()) {
                this.absentValuesSentinel[x.num] = -1;
            }
            int depth = this.propagation.solver.depth();
            Domain dom = x.dom;
            int last = dom.lastRemoved();
            int a = dom.lastRemoved();
            while (a != this.absentValuesSentinel[x.num] && dom.isRemovedAtLevel(a, depth)) {
                if (!this.stateDominanceManager.checkWatchesOf(x.num, a)) {
                    return false;
                }
                a = dom.prevRemoved(a);
            }
            this.sentinelLevel[x.num] = this.propagation.solver.stats.numberSafe();
            this.absentValuesSentinel[x.num] = last;
        }
        return true;
    }

    public void incrementTimestampsOfEnqueuedVariables() {
        for (int i = this.limit; i >= 0; --i) {
            this.variables[this.dense[i]].timestamp = this.propagation.incrementTime();
        }
    }

    @Override
    public String toString() {
        return "There are " + this.size() + " elements : " + IntStream.range(0, this.size()).mapToObj(i -> this.var(i) + " ").collect(Collectors.joining());
    }

    public void setLearnerNogood(LearnerNogoods nogoodManager) {
        this.learnerNogood = nogoodManager;
    }

    public void setStateDominanceManager(LearnerStatesDominance stateDominanceManager) {
        this.stateDominanceManager = stateDominanceManager;
        this.absentValuesSentinel = new int[this.propagation.solver.pb.variables.length];
        this.sentinelLevel = new long[this.absentValuesSentinel.length];
    }
}

