/*
 * Decompiled with CFR 0.152.
 */
package propagation;

import constraints.Constraint;
import constraints.CtrHard;
import dashboard.ControlPanel;
import interfaces.ObserverPropagation;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import problem.Problem;
import propagation.PropagationQueue;
import propagation.order1.PropagationForward;
import search.Solver;
import utility.Kit;
import utility.sets.SetSparse;
import variables.Variable;

public abstract class Propagation {
    public final Solver solver;
    public final PropagationQueue queue;
    public final SetSparseMap[] auxiliaryQueues;
    public long time;
    public Constraint currFilteringCtr;
    public Variable lastWipeoutVar;
    public long nSingletonTests;
    public long nEffectiveSingletonTests;
    public boolean performingProperSearch;
    public final CtrHard[] hards;

    public final void reset() {
        this.queue.clear();
        for (SetSparseMap auxiliaryQueue : this.auxiliaryQueues) {
            auxiliaryQueue.clear();
        }
    }

    public final long incrementTime() {
        return ++this.time;
    }

    public ControlPanel cp() {
        return this.solver.rs.cp;
    }

    public Problem pb() {
        return this.solver.rs.problem;
    }

    public Propagation(Solver solver) {
        this.solver = solver;
        this.queue = this instanceof PropagationForward ? new PropagationQueue((PropagationForward)this) : null;
        int nAuxQueues = this.cp().propagating.useAuxiliaryQueues ? 2 : 0;
        this.auxiliaryQueues = this instanceof PropagationForward ? SetSparseMap.buildArray(nAuxQueues, solver.pb.constraints.length) : null;
        this.hards = (CtrHard[])Stream.of(solver.pb.constraints).filter(c -> c instanceof CtrHard).map(c -> (CtrHard)c).toArray(CtrHard[]::new);
    }

    protected final boolean pickAndFilter() {
        Variable x = this.queue.pickAndDelete();
        if (!this.queue.isNogoodConsistent(x)) {
            return false;
        }
        for (Constraint c : x.ctrs) {
            if (c.ignored) continue;
            if (c.filteringComplexity == 0) {
                this.currFilteringCtr = c;
                boolean consistent = c.filterFrom(x);
                this.currFilteringCtr = null;
                if (consistent) continue;
                return false;
            }
            if (c.timestamp > x.timestamp) continue;
            this.auxiliaryQueues[c.filteringComplexity - 1].add(c.num, x.num);
        }
        return true;
    }

    public boolean propagate() {
        while (true) {
            if (this.queue.size() != 0) {
                if (this.pickAndFilter()) continue;
                return false;
            }
            for (SetSparseMap auxiliaryQueue : this.auxiliaryQueues) {
                while (!auxiliaryQueue.isEmpty()) {
                    int cnum = auxiliaryQueue.shift();
                    int xnum = auxiliaryQueue.values[cnum];
                    Constraint c = this.solver.pb.constraints[cnum];
                    Variable x = this.solver.pb.variables[xnum];
                    c.timestamp = x.timestamp;
                    if (c.ignored) continue;
                    this.currFilteringCtr = c;
                    boolean consistent = c.filterFrom(x);
                    this.currFilteringCtr = null;
                    if (consistent) continue;
                    return false;
                }
            }
            if (this.queue.size() == 0) break;
        }
        return true;
    }

    public abstract boolean runInitially();

    public abstract boolean runAfterAssignment(Variable var1);

    public abstract boolean runAfterRefutation(Variable var1);

    public final boolean handleReduction(Variable x, int newDomSize) {
        if (newDomSize == 0) {
            this.lastWipeoutVar = x;
            for (ObserverPropagation obs : this.solver.observersPropagation) {
                obs.whenWipeout(this.currFilteringCtr, x);
            }
            return false;
        }
        this.queue.add(x);
        return true;
    }

    public final boolean handleReduction(Variable x) {
        return this.handleReduction(x, x.dom.size());
    }

    public final boolean handleReductionSafely(Variable x) {
        assert (x.dom.size() > 0);
        this.queue.add(x);
        return true;
    }

    public static class SetSparseMap
    extends SetSparse {
        public final int[] values;

        public static SetSparseMap[] buildArray(int length, int capacity) {
            return (SetSparseMap[])IntStream.range(0, length).mapToObj(i -> new SetSparseMap(capacity)).toArray(SetSparseMap[]::new);
        }

        public SetSparseMap(int capacity, boolean initiallyFull) {
            super(capacity, initiallyFull);
            this.values = Kit.range(capacity);
        }

        public SetSparseMap(int capacity) {
            this(capacity, false);
        }

        public int valueForPosition(int i) {
            return this.values[this.dense[i]];
        }

        @Override
        public final boolean add(int e) {
            throw new RuntimeException("Must not be called without a second argument");
        }

        public boolean add(int e, int value) {
            boolean b = super.add(e);
            this.values[e] = value;
            return b;
        }
    }
}

