/*
 * Decompiled with CFR 0.152.
 */
package problems.xcsp3;

import constraints.hard.global.BinPackingSimple;
import constraints.hard.primitive.CtrFalse;
import constraints.hard.primitive.CtrPrimitiveBinary;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Condition;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.domains.Domains;
import org.xcsp.common.predicates.MatcherInterface;
import org.xcsp.common.predicates.XNode;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.common.structures.AbstractTuple;
import org.xcsp.common.structures.Automaton;
import org.xcsp.common.structures.Transition;
import org.xcsp.modeler.entities.CtrEntities;
import org.xcsp.modeler.entities.ModelingEntity;
import org.xcsp.parser.XParser;
import org.xcsp.parser.callbacks.XCallbacks;
import org.xcsp.parser.callbacks.XCallbacks2;
import org.xcsp.parser.entries.ParsingEntry;
import org.xcsp.parser.entries.XConstraints;
import org.xcsp.parser.entries.XObjectives;
import org.xcsp.parser.entries.XVariables;
import problem.Problem;
import problems.ProblemFile;
import utility.Kit;
import utility.exceptions.UnreachableCodeException;
import variables.Variable;
import variables.VariableInteger;
import variables.VariableSymbolic;

public class XCSP3
extends ProblemFile
implements XCallbacks2 {
    private XCallbacks.Implem implem = new XCallbacks.Implem(this);
    private Map<XVariables.XVar, Variable> mapVar = new LinkedHashMap<XVariables.XVar, Variable>();
    private int nPrimitiveCalls = 0;

    @Override
    public XCallbacks.Implem implem() {
        return this.implem;
    }

    @Override
    protected String[] defineSuffixFilters() {
        return (String[])Stream.of(".xml", ".bz2", ".lzma").toArray(String[]::new);
    }

    @Override
    public void model() {
        try {
            if (this.imp().rs.cp.export) {
                this.implem.rawParameters();
            }
            Kit.log.info("Discarded classes " + this.imp().rs.cp.settingXml.discardedClasses);
            if (this.imp().rs.cp.verbose > 1) {
                XParser.VERBOSE = true;
            }
            if (this.imp().rs.cp.settingXml.discardedClasses.indexOf(44) < 0) {
                this.loadInstance(this.currFileName(), this.imp().rs.cp.settingXml.discardedClasses);
            } else {
                this.loadInstance(this.currFileName(), this.imp().rs.cp.settingXml.discardedClasses.split(","));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Problem when parsing the instance. Fix the problem.");
            System.exit(1);
        }
    }

    @Override
    public Problem imp() {
        return (Problem)api2imp.get(this);
    }

    @Override
    public void beginInstance(Types.TypeFramework type) {
        if (type == Types.TypeFramework.COP) {
            this.imp().rs.cp.framework = Types.TypeFramework.COP;
            this.imp().rs.cp.setingGeneral.nSearchedSolutions = Long.MAX_VALUE;
            this.imp().framework = Types.TypeFramework.COP;
        }
    }

    private void copyBasicAttributes(ModelingEntity entity, ParsingEntry entry) {
        if (entry.id != null) {
            entity.id(entry.id);
        }
        if (entry.note != null) {
            entity.note(entry.note);
        }
        if (entry.classes != null) {
            entity.tag(entry.classes);
        }
    }

    private VariableInteger trVar(IVar x) {
        return (VariableInteger)this.mapVar.get(x);
    }

    private VariableInteger trVar(XVariables.XVarInteger x) {
        return (VariableInteger)this.mapVar.get(x);
    }

    private VariableSymbolic trVar(XVariables.XVarSymbolic x) {
        return (VariableSymbolic)this.mapVar.get(x);
    }

    private Condition trVar(Condition condition) {
        if (condition instanceof Condition.ConditionVar) {
            return new Condition.ConditionVar(((Condition.ConditionVar)condition).operator, this.trVar(((Condition.ConditionVar)condition).x));
        }
        return condition;
    }

    private XNode<IVar> trVar(XNode<IVar> tree) {
        return tree.replaceLeafValues(v -> v instanceof XVariables.XVarInteger ? this.trVar((XVariables.XVarInteger)v) : v);
    }

    private XNode<IVar>[] trVar(XNode<IVar>[] trees) {
        return (XNode[])Stream.of(trees).map(t -> t.replaceLeafValues(v -> v instanceof XVariables.XVarInteger ? this.trVar((XVariables.XVarInteger)v) : v)).toArray(XNode[]::new);
    }

    private VariableInteger[] trVars(XVariables.XVarInteger[] t) {
        return (VariableInteger[])Arrays.stream(t).map(v -> this.mapVar.get(v)).toArray(VariableInteger[]::new);
    }

    private VariableInteger[][] trVars2D(XVariables.XVarInteger[][] m) {
        return (VariableInteger[][])Arrays.stream(m).map(t -> this.trVars((XVariables.XVarInteger[])t)).toArray(x$0 -> new VariableInteger[x$0][]);
    }

    private VariableSymbolic[] trVars(XVariables.XVarSymbolic[] t) {
        return (VariableSymbolic[])Arrays.stream(t).map(v -> this.mapVar.get(v)).toArray(VariableSymbolic[]::new);
    }

    @Override
    public void loadVar(XVariables.XVar v) {
        this.implem().manageIdFor(v);
        if (v.degree > 0) {
            if (v.dom instanceof Domains.Dom) {
                this.mapVar.put(v, (VariableInteger)this.var(v.id, (Domains.Dom)v.dom, v.note, v.classes));
            } else if (v.dom instanceof Domains.DomSymbolic) {
                this.mapVar.put(v, (VariableSymbolic)this.var(v.id, (Domains.DomSymbolic)v.dom, v.note, v.classes));
            } else {
                this.unimplementedCase(v);
            }
        }
    }

    private void completeMapVar(XVariables.XArray va, Object a, int ... indexes) {
        if (a != null) {
            if (a.getClass().isArray()) {
                IntStream.range(0, Array.getLength(a)).forEach(i -> this.completeMapVar(va, Array.get(a, i), this.vals(indexes, i)));
            } else {
                this.mapVar.put(va.varAt(indexes), (Variable)a);
            }
        }
    }

    @Override
    public void loadArray(XVariables.XArray va) {
        this.implem().manageIdFor(va);
        IVar[] a = null;
        int[] sz = va.size;
        if (va.getType() == Types.TypeVar.integer) {
            if (sz.length == 1) {
                a = this.array(va.id, this.size(sz[0]), (int i) -> va.domAt(i), va.note, va.classes);
            } else if (sz.length == 2) {
                a = this.array(va.id, this.size(sz[0], sz[1]), (int i, int j) -> va.domAt(i, j), va.note, va.classes);
            } else if (sz.length == 3) {
                a = this.array(va.id, this.size(sz[0], sz[1], sz[2]), (int i, int j, int k) -> va.domAt(i, j, k), va.note, va.classes);
            } else if (sz.length == 4) {
                a = this.array(va.id, this.size(sz[0], sz[1], sz[2], sz[3]), (int i, int j, int k, int l) -> va.domAt(i, j, k, l), va.note, va.classes);
            } else if (sz.length == 5) {
                a = this.array(va.id, this.size(sz[0], sz[1], sz[2], sz[3], sz[4]), (int i, int j, int k, int l, int m) -> va.domAt(i, j, k, l, m), va.note, va.classes);
            } else {
                this.unimplementedCase(va);
            }
        } else if (va.getType() == Types.TypeVar.symbolic) {
            if (sz.length == 1) {
                a = this.arraySymbolic(va.id, this.size(sz[0]), (int i) -> va.varAt(i) != null && va.varAt((int[])new int[]{i}).degree > 0 ? (Domains.DomSymbolic)va.varAt((int[])new int[]{i}).dom : null, va.note, va.classes);
            } else {
                this.unimplementedCase(va);
            }
        } else {
            this.unimplementedCase(va);
        }
        this.completeMapVar(va, a, new int[0]);
    }

    @Override
    public void buildVarInteger(XVariables.XVarInteger x, int minValue, int maxValue) {
        throw new UnreachableCodeException();
    }

    @Override
    public void buildVarInteger(XVariables.XVarInteger x, int[] values) {
        throw new UnreachableCodeException();
    }

    @Override
    public void buildVarSymbolic(XVariables.XVarSymbolic x, String[] values) {
        throw new UnreachableCodeException();
    }

    @Override
    public void loadBlock(XConstraints.XBlock block) {
        CtrEntities.CtrArray entity = this.block(() -> this.loadConstraints(block.subentries));
        this.copyBasicAttributes(entity, block);
    }

    @Override
    public void loadGroup(XConstraints.XGroup group) {
        CtrEntities.CtrArray entity = this.imp().manageLoop(() -> {
            if (group.template instanceof XConstraints.XCtr) {
                this.loadCtrs((XConstraints.XCtr)group.template, group.argss, group);
            } else if (group.template instanceof XConstraints.XLogic && ((XConstraints.XLogic)group.template).getType() == Types.TypeCtr.not) {
                XConstraints.CEntryReifiable child = ((XConstraints.XLogic)group.template).components[0];
                if (child instanceof XConstraints.XCtr && ((XConstraints.XCtr)child).type == Types.TypeCtr.allEqual) {
                    Stream.of(group.argss).forEach(o -> this.notAllEqual(this.trVars((XVariables.XVarInteger[])o)));
                } else {
                    this.unimplementedCase(group);
                }
            } else {
                this.unimplementedCase(group);
            }
        });
        if (entity != null) {
            this.copyBasicAttributes(entity, group);
        }
    }

    @Override
    public void loadSlide(XConstraints.XSlide s) {
        CtrEntities.CtrArray entity = this.imp().manageLoop(() -> XCallbacks2.super.loadSlide(s));
        this.copyBasicAttributes(entity, s);
    }

    @Override
    public void beginLogic(XConstraints.XLogic l) {
        System.out.println("Begin : " + l);
    }

    @Override
    public void endLogic(XConstraints.XLogic l) {
        System.out.println("End : " + l);
    }

    @Override
    public void loadCtr(XConstraints.XCtr c) {
        if (this.imp().stuff.mustDiscard(c.vars())) {
            return;
        }
        if (this.imp().rs.cp.settingCtrs.ignoredCtrType == c.type) {
            ++this.imp().stuff.nDiscardedCtrs;
            return;
        }
        if (this.imp().rs.cp.settingCtrs.ignoreCtrArity == c.vars().length) {
            ++this.imp().stuff.nDiscardedCtrs;
            return;
        }
        int sizeBefore = this.imp().ctrEntities.allEntities.size();
        XCallbacks2.super.loadCtr(c);
        if (sizeBefore == this.imp().ctrEntities.allEntities.size()) {
            return;
        }
        CtrEntities.CtrEntity entity = this.imp().ctrEntities.allEntities.get(this.imp().ctrEntities.allEntities.size() - 1);
        this.copyBasicAttributes(entity, c);
    }

    @Override
    public void buildCtrFalse(String id, XVariables.XVar[] list) {
        if (this.imp().framework != Types.TypeFramework.MAXCSP) {
            throw new RuntimeException("Constraint with only conflicts");
        }
        this.imp().addCtr(new CtrFalse(this.imp(), this.trVars((XVariables.XVarInteger[])Stream.of(list).map(x -> (XVariables.XVarInteger)x).toArray(XVariables.XVarInteger[]::new))), new Types.TypeClass[0]);
    }

    private void displayPrimitives(String s) {
        if (this.imp().rs.cp.settingXml.displayPrimitives) {
            System.out.println((this.nPrimitiveCalls++ == 0 ? "\n" : "") + "Primitive in class XCSP3 : " + s);
        }
    }

    @Override
    public CtrEntities.CtrEntity intension(XNodeParent<IVar> tree) {
        XNodeParent validTree = (XNodeParent)tree.replaceLeafValues(v -> v instanceof XVariables.XVarInteger ? this.trVar((XVariables.XVarInteger)v) : (v instanceof XVariables.XVarSymbolic ? this.trVar((XVariables.XVarSymbolic)v) : v));
        return this.imp().intension(validTree);
    }

    @Override
    public void buildCtrIntension(String id, XVariables.XVarInteger[] scope, XNodeParent<XVariables.XVarInteger> tree) {
        Utilities.control(tree.exactlyVars(scope), "Pb with scope");
        this.intension(tree);
    }

    @Override
    public void buildCtrPrimitive(String id, XVariables.XVarInteger x, Types.TypeConditionOperatorRel op, int k) {
        this.displayPrimitives(x + " " + (Object)((Object)op) + " " + k);
        this.imp().intension((XNodeParent)XNodeParent.build(op.toExpr(), this.trVar(x), k));
    }

    @Override
    public void buildCtrPrimitive(String id, XVariables.XVarInteger x, Types.TypeConditionOperatorSet op, int[] t) {
        this.displayPrimitives(x + " " + (Object)((Object)op) + " " + Kit.join((Object)t, new String[0]));
        this.intension(op == IN ? this.in(this.trVar(x), this.set(t)) : this.notin(this.trVar(x), this.set(t)));
    }

    @Override
    public void buildCtrPrimitive(String id, XVariables.XVarInteger x, Types.TypeConditionOperatorSet op, int min, int max) {
        this.displayPrimitives(x + " " + (Object)((Object)op) + " " + min + ".." + max);
        this.intension(op == IN ? this.and(this.ge(this.trVar(x), min), this.le(this.trVar(x), max)) : this.or(this.lt(this.trVar(x), min), this.gt(this.trVar(x), max)));
    }

    @Override
    public void buildCtrPrimitive(String id, XVariables.XVarInteger x, Types.TypeArithmeticOperator aop, int k1, Types.TypeConditionOperatorRel op, int k2) {
        this.displayPrimitives("(" + x + " " + (Object)((Object)aop) + " " + k1 + ") " + (Object)((Object)op) + " " + k2 + " (reposted)");
        this.repost(id);
    }

    @Override
    public void buildCtrPrimitive(String id, XVariables.XVarInteger x, Types.TypeUnaryArithmeticOperator aop, XVariables.XVarInteger y) {
        this.displayPrimitives(x + " " + (Object)((Object)aop) + " " + y);
        this.repost(id);
    }

    @Override
    public void buildCtrPrimitive(String id, XVariables.XVarInteger x, Types.TypeArithmeticOperator aop, XVariables.XVarInteger y, Types.TypeConditionOperatorRel op, int k) {
        this.displayPrimitives("(" + x + " " + (Object)((Object)aop) + " " + y + ") " + (Object)((Object)op) + " " + k);
        if (aop == Types.TypeArithmeticOperator.SUB) {
            CtrPrimitiveBinary.CtrPrimitiveBinaryAdd.buildFrom(this.imp(), this.trVar(x), -k, op, this.trVar(y));
        } else if (aop == Types.TypeArithmeticOperator.DIST) {
            CtrPrimitiveBinary.CtrPrimitiveBinaryDist.buildFrom(this.imp(), this.trVar(x), this.trVar(y), op, k);
        } else {
            this.repost(id);
        }
    }

    @Override
    public void buildCtrPrimitive(String id, XVariables.XVarInteger x, Types.TypeArithmeticOperator aop, int k, Types.TypeConditionOperatorRel op, XVariables.XVarInteger y) {
        this.displayPrimitives("(" + x + " " + (Object)((Object)aop) + " " + k + ") " + (Object)((Object)op) + " " + y);
        if (op == Types.TypeConditionOperatorRel.EQ && (aop == Types.TypeArithmeticOperator.ADD || aop == Types.TypeArithmeticOperator.SUB)) {
            k = aop == Types.TypeArithmeticOperator.SUB ? -k : k;
            this.imp().addCtr(new CtrPrimitiveBinary.CtrPrimitiveBinaryAdd.EQ(this.imp(), (Variable)this.trVar(x), k, this.trVar(y)), new Types.TypeClass[0]);
        } else {
            this.repost(id);
        }
    }

    @Override
    public void buildCtrPrimitive(String id, XVariables.XVarInteger x, Types.TypeArithmeticOperator aop, XVariables.XVarInteger y, Types.TypeConditionOperatorRel op, XVariables.XVarInteger z) {
        this.displayPrimitives("(" + x + " " + (Object)((Object)aop) + " " + y + ") " + (Object)((Object)op) + " " + z);
        this.repost(id);
    }

    @Override
    public void buildCtrLogic(String id, Types.TypeLogicalOperator lop, XVariables.XVarInteger[] vars) {
        assert (Stream.of(vars).allMatch(x -> x.isZeroOne()));
        this.displayPrimitives((Object)((Object)lop) + " " + Kit.join((Object)vars, new String[0]));
        this.repost(id);
    }

    @Override
    public void buildCtrLogic(String id, XVariables.XVarInteger x, Types.TypeEqNeOperator op, Types.TypeLogicalOperator lop, XVariables.XVarInteger[] vars) {
        assert (Stream.of(vars).allMatch(y -> y.isZeroOne()));
        this.displayPrimitives(x + " " + (Object)((Object)op) + " " + (Object)((Object)lop) + " " + Kit.join((Object)vars, new String[0]));
        this.repost(id);
    }

    @Override
    public void buildCtrExtension(String id, XVariables.XVarInteger x, int[] values, boolean positive, Set<Types.TypeFlag> flags) {
        Kit.control(!flags.contains((Object)Types.TypeFlag.STARRED_TUPLES));
        if (flags.contains((Object)Types.TypeFlag.UNCLEAN_TUPLES)) {
            values = Variable.filterValues(this.trVar(x), values, false);
        }
        this.extension((IVar.Var)this.trVar(x), values, (Boolean)positive);
    }

    @Override
    public void buildCtrExtension(String id, XVariables.XVarInteger[] list, int[][] tuples, boolean positive, Set<Types.TypeFlag> flags) {
        if (flags.contains((Object)Types.TypeFlag.UNCLEAN_TUPLES)) {
            tuples = Variable.filterTuples(this.trVars(list), tuples, false);
        }
        this.imp().extension(this.trVars(list), tuples, positive, flags.contains((Object)Types.TypeFlag.STARRED_TUPLES));
    }

    @Override
    public void buildCtrExtension(String id, XVariables.XVarInteger[] list, AbstractTuple[] tuples, boolean positive, Set<Types.TypeFlag> flags) {
        this.imp().extension((IVar.Var[])this.trVars(list), tuples, positive);
    }

    @Override
    public void buildCtrRegular(String id, XVariables.XVarInteger[] list, Object[][] transitions, String startState, String[] finalStates) {
        this.imp().regular(this.trVars(list), new Automaton(startState, (Transition[])Stream.of(transitions).map(t -> new Transition((String)t[0], t[1], (String)t[2])).toArray(Transition[]::new), finalStates));
    }

    @Override
    public void buildCtrMDD(String id, XVariables.XVarInteger[] list, Object[][] transitions) {
        this.mdd((IVar.Var[])this.trVars(list), (Transition[])Stream.of(transitions).map(t -> new Transition((String)t[0], t[1], (String)t[2])).toArray(Transition[]::new));
    }

    @Override
    public void buildCtrAllDifferent(String id, XVariables.XVarInteger[] list) {
        this.allDifferent((IVar.Var[])this.trVars(list));
    }

    @Override
    public void buildCtrAllDifferentExcept(String id, XVariables.XVarInteger[] list, int[] except) {
        this.trVars(list);
        this.allDifferent((IVar.Var[])this.trVars(list), this.exceptValues(except));
    }

    @Override
    public void buildCtrAllDifferentList(String id, XVariables.XVarInteger[][] lists) {
        this.allDifferentList(this.trVars2D(lists));
    }

    @Override
    public void buildCtrAllDifferentMatrix(String id, XVariables.XVarInteger[][] matrix) {
        this.allDifferentMatrix(this.trVars2D(matrix));
    }

    @Override
    public void buildCtrAllDifferent(String id, XNode<XVariables.XVarInteger>[] trees) {
        this.allDifferent(this.trVar(trees));
    }

    @Override
    public void buildCtrAllEqual(String id, XVariables.XVarInteger[] list) {
        this.allEqual(this.trVars(list));
    }

    @Override
    public void buildCtrOrdered(String id, XVariables.XVarInteger[] list, Types.TypeOperatorRel operator) {
        this.ordered(this.trVars(list), operator);
    }

    @Override
    public void buildCtrOrdered(String id, XVariables.XVarInteger[] list, int[] lengths, Types.TypeOperatorRel operator) {
        this.ordered((IVar.Var[])this.trVars(list), lengths, operator);
    }

    @Override
    public void buildCtrOrdered(String id, XVariables.XVarInteger[] list, XVariables.XVarInteger[] lengths, Types.TypeOperatorRel operator) {
        this.ordered((IVar.Var[])this.trVars(list), this.trVars(lengths), operator);
    }

    @Override
    public void buildCtrLex(String id, XVariables.XVarInteger[][] lists, Types.TypeOperatorRel operator) {
        this.lex(this.trVars2D(lists), operator);
    }

    @Override
    public void buildCtrLexMatrix(String id, XVariables.XVarInteger[][] matrix, Types.TypeOperatorRel operator) {
        this.lexMatrix(this.trVars2D(matrix), operator);
    }

    @Override
    public void buildCtrSum(String id, XVariables.XVarInteger[] list, Condition condition) {
        this.sum(this.trVars(list), this.trVar(condition));
    }

    @Override
    public void buildCtrSum(String id, XVariables.XVarInteger[] list, int[] coeffs, Condition condition) {
        assert (coeffs != null);
        this.sum((IVar.Var[])this.trVars(list), coeffs, this.trVar(condition));
    }

    @Override
    public void buildCtrSum(String id, XVariables.XVarInteger[] list, XVariables.XVarInteger[] coeffs, Condition condition) {
        this.sum((IVar.Var[])this.trVars(list), this.trVars(coeffs), this.trVar(condition));
    }

    @Override
    public void buildCtrSum(String id, XNode<XVariables.XVarInteger>[] trees, Condition condition) {
        this.sum(this.trVar(trees), this.trVar(condition));
    }

    @Override
    public void buildCtrSum(String id, XNode<XVariables.XVarInteger>[] trees, int[] coeffs, Condition condition) {
        assert (coeffs != null);
        this.sum(this.trVar(trees), coeffs, this.trVar(condition));
    }

    @Override
    public void buildCtrSum(String id, XNode<XVariables.XVarInteger>[] trees, XVariables.XVarInteger[] coeffs, Condition condition) {
        this.unimplementedCase(id, Utilities.join(trees), Utilities.join(coeffs), condition);
    }

    @Override
    public void buildCtrCount(String id, XVariables.XVarInteger[] list, int[] values, Condition condition) {
        if (condition instanceof Condition.ConditionVar) {
            this.count((IVar.Var[])this.trVars(list), values, this.trVar(condition));
        } else if (condition instanceof Condition.ConditionVal) {
            this.count((IVar.Var[])this.trVars(list), values, ((Condition.ConditionRel)condition).operator, Utilities.safeInt(((Condition.ConditionVal)condition).k));
        } else {
            this.unimplementedCase(id, Utilities.join(list), Utilities.join(values), condition);
        }
    }

    @Override
    public void buildCtrCount(String id, XVariables.XVarInteger[] list, XVariables.XVarInteger[] values, Condition condition) {
        this.unimplementedCase(id, Utilities.join(list), Utilities.join(values), condition);
    }

    @Override
    public void buildCtrAtLeast(String id, XVariables.XVarInteger[] list, int value, int k) {
        this.atLeast((IVar.Var[])this.trVars(list), value, k);
    }

    @Override
    public void buildCtrAtMost(String id, XVariables.XVarInteger[] list, int value, int k) {
        this.atMost((IVar.Var[])this.trVars(list), value, k);
    }

    @Override
    public void buildCtrExactly(String id, XVariables.XVarInteger[] list, int value, int k) {
        this.exactly((IVar.Var[])this.trVars(list), value, k);
    }

    @Override
    public void buildCtrExactly(String id, XVariables.XVarInteger[] list, int value, XVariables.XVarInteger k) {
        this.exactly((IVar.Var[])this.trVars(list), value, this.trVar(k));
    }

    @Override
    public void buildCtrAmong(String id, XVariables.XVarInteger[] list, int[] values, int k) {
        this.among((IVar.Var[])this.trVars(list), values, k);
    }

    @Override
    public void buildCtrAmong(String id, XVariables.XVarInteger[] list, int[] values, XVariables.XVarInteger k) {
        this.unimplementedCase(id, Utilities.join(list), Utilities.join(values), k);
    }

    @Override
    public void buildCtrNValues(String id, XVariables.XVarInteger[] list, Condition condition) {
        if (condition instanceof Condition.ConditionVar) {
            this.nValues(this.trVars(list), this.trVar(condition));
        } else if (condition instanceof Condition.ConditionVal) {
            this.nValues((IVar.Var[])this.trVars(list), ((Condition.ConditionRel)condition).operator, Utilities.safeInt(((Condition.ConditionVal)condition).k));
        } else {
            this.unimplementedCase(id, Utilities.join(list), condition);
        }
    }

    @Override
    public void buildCtrNValuesExcept(String id, XVariables.XVarInteger[] list, int[] values, Condition condition) {
        this.unimplementedCase(id, Utilities.join(list), Utilities.join(values), condition);
    }

    @Override
    public void buildCtrNotAllEqual(String id, XVariables.XVarInteger[] list) {
        this.notAllEqual(this.trVars(list));
    }

    @Override
    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, int[] values, XVariables.XVarInteger[] occurs) {
        this.cardinality((IVar.Var[])this.trVars(list), values, closed, this.occurExactly(this.trVars(occurs)));
    }

    @Override
    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, int[] values, int[] occurs) {
        this.cardinality((IVar.Var[])this.trVars(list), values, closed, this.occurExactly(occurs));
    }

    @Override
    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, int[] values, int[] occursMin, int[] occursMax) {
        this.cardinality((IVar.Var[])this.trVars(list), values, closed, this.occurBetween(occursMin, occursMax));
    }

    @Override
    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, XVariables.XVarInteger[] values, XVariables.XVarInteger[] occurs) {
        this.unimplementedCase(id, Utilities.join(list), closed, Utilities.join(values), Utilities.join(occurs));
    }

    @Override
    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, XVariables.XVarInteger[] values, int[] occurs) {
        this.unimplementedCase(id, Utilities.join(list), closed, Utilities.join(values), Utilities.join(occurs));
    }

    @Override
    public void buildCtrCardinality(String id, XVariables.XVarInteger[] list, boolean closed, XVariables.XVarInteger[] values, int[] occursMin, int[] occursMax) {
        this.unimplementedCase(id, Utilities.join(list), closed, Utilities.join(values), Utilities.join(occursMin), Utilities.join(occursMax));
    }

    @Override
    public void buildCtrMaximum(String id, XVariables.XVarInteger[] list, Condition condition) {
        if (condition instanceof Condition.ConditionVar && ((Condition.ConditionVar)condition).operator == EQ) {
            this.maximum((IVar.Var[])this.trVars(list), this.trVar(((Condition.ConditionVar)condition).x));
        } else if (condition instanceof Condition.ConditionVal) {
            this.maximum((IVar.Var[])this.trVars(list), condition);
        } else {
            this.unimplementedCase(id, Utilities.join(list), condition);
        }
    }

    @Override
    public void buildCtrMaximum(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, Condition condition) {
        this.unimplementedCase(new Object[]{id, Utilities.join(list), startIndex, index, rank, condition});
    }

    @Override
    public void buildCtrMaximum(String id, XNode<XVariables.XVarInteger>[] trees, Condition condition) {
        XNode[] validTrees = (XNode[])Stream.of(trees).map(t -> t.replaceLeafValues(v -> v instanceof XVariables.XVarInteger ? this.trVar((XVariables.XVarInteger)v) : v)).toArray(XNode[]::new);
        if (condition instanceof Condition.ConditionVar && ((Condition.ConditionVar)condition).operator == EQ) {
            this.imp().maximum(validTrees, this.trVar(condition));
        } else {
            this.unimplementedCase(id, Utilities.join(trees), condition);
        }
    }

    @Override
    public void buildCtrMinimum(String id, XVariables.XVarInteger[] list, Condition condition) {
        if (condition instanceof Condition.ConditionVar && ((Condition.ConditionVar)condition).operator == EQ) {
            this.minimum((IVar.Var[])this.trVars(list), this.trVar(((Condition.ConditionVar)condition).x));
        } else {
            this.unimplementedCase(id, Utilities.join(list), condition);
        }
    }

    @Override
    public void buildCtrMinimum(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, Condition condition) {
        this.unimplementedCase(new Object[]{id, Utilities.join(list), startIndex, index, rank, condition});
    }

    @Override
    public void buildCtrMinimum(String id, XNode<XVariables.XVarInteger>[] trees, Condition condition) {
        XNode[] validTrees = (XNode[])Stream.of(trees).map(t -> t.replaceLeafValues(v -> v instanceof XVariables.XVarInteger ? this.trVar((XVariables.XVarInteger)v) : v)).toArray(XNode[]::new);
        if (condition instanceof Condition.ConditionVar && ((Condition.ConditionVar)condition).operator == EQ) {
            this.imp().minimum(validTrees, this.trVar(condition));
        } else {
            this.unimplementedCase(id, Utilities.join(trees), condition);
        }
    }

    @Override
    public void buildCtrElement(String id, XVariables.XVarInteger[] list, XVariables.XVarInteger value) {
        this.unimplementedCase(id, Utilities.join(list), value);
    }

    @Override
    public void buildCtrElement(String id, XVariables.XVarInteger[] list, int value) {
        this.unimplementedCase(id, Utilities.join(list), value);
    }

    @Override
    public void buildCtrElement(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, XVariables.XVarInteger value) {
        Kit.control(startIndex == 0 && rank == Types.TypeRank.ANY);
        this.element((IVar.Var[])this.trVars(list), (IVar.Var)this.trVar(index), (IVar.Var)this.trVar(value));
    }

    @Override
    public void buildCtrElement(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, int value) {
        this.control(startIndex == 0 && rank == Types.TypeRank.ANY, new Object[0]);
        this.element((IVar.Var[])this.trVars(list), (IVar.Var)this.trVar(index), value);
    }

    @Override
    public void buildCtrElement(String id, int[] list, int startIndex, XVariables.XVarInteger index, Types.TypeRank rank, XVariables.XVarInteger value) {
        Kit.control(rank == Types.TypeRank.ANY);
        this.element(list, this.startIndex(startIndex), this.index(this.trVar(index), rank), (IVar.Var)this.trVar(value));
    }

    @Override
    public void buildCtrElement(String id, int[][] matrix, int startRowIndex, XVariables.XVarInteger rowIndex, int startColIndex, XVariables.XVarInteger colIndex, XVariables.XVarInteger value) {
        Kit.control(startRowIndex == 0 && startColIndex == 0);
        this.element(matrix, startRowIndex, (IVar.Var)this.trVar(rowIndex), startColIndex, (IVar.Var)this.trVar(colIndex), this.trVar(value));
    }

    @Override
    public void buildCtrElement(String id, XVariables.XVarInteger[][] matrix, int startRowIndex, XVariables.XVarInteger rowIndex, int startColIndex, XVariables.XVarInteger colIndex, int value) {
        Kit.control(startRowIndex == 0 && startColIndex == 0);
        this.element(this.trVars2D(matrix), startRowIndex, (IVar.Var)this.trVar(rowIndex), startColIndex, (IVar.Var)this.trVar(colIndex), value);
    }

    @Override
    public void buildCtrChannel(String id, XVariables.XVarInteger[] list, int startIndex) {
        this.unimplementedCase(id, Utilities.join(list), startIndex);
    }

    @Override
    public void buildCtrChannel(String id, XVariables.XVarInteger[] list1, int startIndex1, XVariables.XVarInteger[] list2, int startIndex2) {
        Kit.control(startIndex1 == 0 && startIndex2 == 0);
        this.channel((IVar.Var[])this.trVars(list1), this.trVars(list2));
    }

    @Override
    public void buildCtrChannel(String id, XVariables.XVarInteger[] list, int startIndex, XVariables.XVarInteger value) {
        Kit.control(startIndex == 0);
        this.channel((IVar.Var[])this.trVars(list), this.trVar(value));
    }

    @Override
    public void buildCtrStretch(String id, XVariables.XVarInteger[] list, int[] values, int[] widthsMin, int[] widthsMax) {
        this.unimplementedCase(id, Utilities.join(list), Utilities.join(values), Utilities.join(widthsMin), Utilities.join(widthsMax));
    }

    @Override
    public void buildCtrStretch(String id, XVariables.XVarInteger[] list, int[] values, int[] widthsMin, int[] widthsMax, int[][] patterns) {
        this.unimplementedCase(id, Utilities.join(list), Utilities.join(values), Utilities.join(widthsMin), Utilities.join(widthsMax), Utilities.join(patterns));
    }

    @Override
    public void buildCtrNoOverlap(String id, XVariables.XVarInteger[] origins, int[] lengths, boolean zeroIgnored) {
        if (!zeroIgnored) {
            this.unimplementedCase(id, Utilities.join(origins), Utilities.join(lengths), zeroIgnored);
        }
        this.noOverlap((IVar.Var[])this.trVars(origins), lengths);
    }

    @Override
    public void buildCtrNoOverlap(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, boolean zeroIgnored) {
        this.unimplementedCase(id, Utilities.join(origins), Utilities.join(lengths), zeroIgnored);
    }

    @Override
    public void buildCtrNoOverlap(String id, XVariables.XVarInteger[][] origins, int[][] lengths, boolean zeroIgnored) {
        if (!zeroIgnored) {
            this.unimplementedCase(id, Utilities.join(origins), Utilities.join(lengths), zeroIgnored);
        }
        this.noOverlap((IVar.Var[][])this.trVars2D(origins), lengths);
    }

    @Override
    public void buildCtrNoOverlap(String id, XVariables.XVarInteger[][] origins, XVariables.XVarInteger[][] lengths, boolean zeroIgnored) {
        if (!zeroIgnored) {
            this.unimplementedCase(id, Utilities.join(origins), Utilities.join(lengths), zeroIgnored);
        }
        this.noOverlap((IVar.Var[][])this.trVars2D(origins), (IVar.Var[][])this.trVars2D(lengths));
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, int[] lengths, int[] heights, Condition condition) {
        if (condition instanceof Condition.ConditionVal && (((Condition.ConditionVal)condition).operator == LT || ((Condition.ConditionVal)condition).operator == LE)) {
            this.cumulative((IVar.Var[])this.trVars(origins), lengths, heights, (long)(Utilities.safeInt(((Condition.ConditionVal)condition).k) - (((Condition.ConditionVal)condition).operator == LT ? 1 : 0)));
        } else {
            this.unimplementedCase(id, Utilities.join(origins), Utilities.join(lengths), Utilities.join(heights), condition);
        }
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, int[] lengths, XVariables.XVarInteger[] heights, Condition condition) {
        this.unimplementedCase(id, Utilities.join(origins), Utilities.join(lengths), Utilities.join(heights), condition);
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, int[] heights, Condition condition) {
        this.unimplementedCase(id, Utilities.join(origins), Utilities.join(lengths), Utilities.join(heights), condition);
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, XVariables.XVarInteger[] heights, Condition condition) {
        this.unimplementedCase(id, Utilities.join(origins), Utilities.join(lengths), Utilities.join(heights), condition);
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, int[] lengths, XVariables.XVarInteger[] ends, int[] heights, Condition condition) {
        this.unimplementedCase(id, Utilities.join(origins), Utilities.join(lengths), Utilities.join(ends), Utilities.join(heights), condition);
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, int[] lengths, XVariables.XVarInteger[] ends, XVariables.XVarInteger[] heights, Condition condition) {
        this.unimplementedCase(id, Utilities.join(origins), Utilities.join(lengths), Utilities.join(ends), Utilities.join(heights), condition);
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, XVariables.XVarInteger[] ends, int[] heights, Condition condition) {
        this.unimplementedCase(id, Utilities.join(origins), Utilities.join(lengths), Utilities.join(ends), Utilities.join(heights), condition);
    }

    @Override
    public void buildCtrCumulative(String id, XVariables.XVarInteger[] origins, XVariables.XVarInteger[] lengths, XVariables.XVarInteger[] ends, XVariables.XVarInteger[] heights, Condition condition) {
        this.unimplementedCase(id, Utilities.join(origins), Utilities.join(lengths), Utilities.join(ends), Utilities.join(heights), condition);
    }

    @Override
    public void buildCtrInstantiation(String id, XVariables.XVarInteger[] list, int[] values) {
        this.instantiation((IVar.Var[])this.trVars(list), values);
    }

    @Override
    public void buildCtrClause(String id, XVariables.XVarInteger[] pos, XVariables.XVarInteger[] neg) {
        this.clause((IVar.Var[])this.trVars(pos), this.trVars(neg));
    }

    @Override
    public void buildCtrCircuit(String id, XVariables.XVarInteger[] list, int startIndex) {
        Kit.control(startIndex == 0);
        this.circuit(this.trVars(list));
    }

    @Override
    public void buildBinPacking(String id, XVariables.XVarInteger[] list, int[] sizes, Condition condition) {
        if (condition instanceof Condition.ConditionVal && (((Condition.ConditionVal)condition).operator == LT || ((Condition.ConditionVal)condition).operator == LE)) {
            this.imp().addCtr(new BinPackingSimple(this.imp(), this.trVars(list), sizes, Utilities.safeInt(((Condition.ConditionVal)condition).k) - (((Condition.ConditionVal)condition).operator == LT ? 1 : 0)), new Types.TypeClass[0]);
        } else {
            this.unimplementedCase(id, Utilities.join(list), Utilities.join(sizes), condition);
        }
    }

    @Override
    public void loadObj(XObjectives.XObj o) {
        if (this.imp().stuff.mustDiscard(o.vars())) {
            return;
        }
        XCallbacks2.super.loadObj(o);
        CtrEntities.CtrEntity entity = this.imp().ctrEntities.allEntities.get(this.imp().ctrEntities.allEntities.size() - 1);
        this.copyBasicAttributes(entity, o);
    }

    @Override
    public void buildObjToMinimize(String id, XVariables.XVarInteger x) {
        this.imp().minimize(this.trVar(x));
    }

    @Override
    public void buildObjToMaximize(String id, XVariables.XVarInteger x) {
        this.imp().maximize(this.trVar(x));
    }

    private List<VarVal> isSum(XNodeParent<XVariables.XVarInteger> tree) {
        ArrayList<VarVal> list = new ArrayList<VarVal>();
        if (tree.type == Types.TypeExpr.ADD) {
            for (XNode son : tree.sons) {
                if (son.type == Types.TypeExpr.VAR) {
                    list.add(new VarVal(this.trVar((XVariables.XVarInteger)son.var(0)), 1));
                    continue;
                }
                if (MatcherInterface.x_mul_k.matches(son) || MatcherInterface.k_mul_x.matches(son)) {
                    list.add(new VarVal(this.trVar((XVariables.XVarInteger)son.var(0)), son.val(0)));
                    continue;
                }
                list.clear();
                break;
            }
        }
        return list;
    }

    @Override
    public void buildObjToMinimize(String id, XNodeParent<XVariables.XVarInteger> tree) {
        List<VarVal> list = this.isSum(tree);
        if (list.size() > 0) {
            this.imp().minimize(SUM, (IVar[])list.stream().map(vv -> vv.x).toArray(VariableInteger[]::new), list.stream().mapToInt(vv -> vv.a).toArray());
        } else {
            this.imp().minimize(this.trVar(tree));
        }
    }

    @Override
    public void buildObjToMaximize(String id, XNodeParent<XVariables.XVarInteger> tree) {
        List<VarVal> list = this.isSum(tree);
        if (list.size() > 0) {
            this.imp().maximize(SUM, (IVar[])list.stream().map(vv -> vv.x).toArray(VariableInteger[]::new), list.stream().mapToInt(vv -> vv.a).toArray());
        } else {
            this.imp().maximize(this.trVar(tree));
        }
    }

    @Override
    public void buildObjToMinimize(String id, Types.TypeObjective type, XVariables.XVarInteger[] list) {
        this.imp().minimize(type, this.trVars(list));
    }

    @Override
    public void buildObjToMaximize(String id, Types.TypeObjective type, XVariables.XVarInteger[] list) {
        this.imp().maximize(type, this.trVars(list));
    }

    @Override
    public void buildObjToMinimize(String id, Types.TypeObjective type, XVariables.XVarInteger[] list, int[] coeffs) {
        this.imp().minimize(type, this.trVars(list), coeffs);
    }

    @Override
    public void buildObjToMaximize(String id, Types.TypeObjective type, XVariables.XVarInteger[] list, int[] coeffs) {
        this.imp().maximize(type, this.trVars(list), coeffs);
    }

    @Override
    public void buildObjToMinimize(String id, Types.TypeObjective type, XNode<XVariables.XVarInteger>[] trees) {
        this.imp().minimize(type, this.trVar(trees));
    }

    @Override
    public void buildObjToMaximize(String id, Types.TypeObjective type, XNode<XVariables.XVarInteger>[] trees) {
        this.imp().maximize(type, this.trVar(trees));
    }

    @Override
    public void buildObjToMinimize(String id, Types.TypeObjective type, XNode<XVariables.XVarInteger>[] trees, int[] coeffs) {
        this.imp().minimize(type, this.trVar(trees), coeffs);
    }

    @Override
    public void buildObjToMaximize(String id, Types.TypeObjective type, XNode<XVariables.XVarInteger>[] trees, int[] coeffs) {
        this.imp().maximize(type, this.trVar(trees), coeffs);
    }

    @Override
    public void buildCtrIntension(String id, XVariables.XVarSymbolic[] scope, XNodeParent<XVariables.XVarSymbolic> tree) {
        Utilities.control(tree.exactlyVars(scope), "Pb with scope");
        this.intension(tree);
    }

    @Override
    public void buildCtrExtension(String id, XVariables.XVarSymbolic x, String[] values, boolean positive, Set<Types.TypeFlag> flags) {
        Kit.control(!flags.contains((Object)Types.TypeFlag.STARRED_TUPLES), () -> "Forbidden for unary constraints");
        values = flags.contains((Object)Types.TypeFlag.UNCLEAN_TUPLES) ? Variable.filterValues(this.trVar(x), values) : values;
        this.extension((IVar.VarSymbolic)this.trVar(x), values, (Boolean)positive);
    }

    @Override
    public void buildCtrExtension(String id, XVariables.XVarSymbolic[] list, String[][] tuples, boolean positive, Set<Types.TypeFlag> flags) {
        tuples = flags.contains((Object)Types.TypeFlag.UNCLEAN_TUPLES) ? Variable.filterTuples(this.trVars(list), tuples) : tuples;
        this.imp().extension(this.trVars(list), tuples, positive, flags.contains((Object)Types.TypeFlag.STARRED_TUPLES));
    }

    @Override
    public void buildCtrAllDifferent(String id, XVariables.XVarSymbolic[] list) {
        this.allDifferent(this.trVars(list));
    }

    @Override
    public void buildAnnotationDecision(XVariables.XVarInteger[] list) {
        this.decisionVariables(this.trVars(list));
    }

    static class VarVal {
        Variable x;
        int a;

        VarVal(Variable x, int a) {
            this.x = x;
            this.a = a;
        }
    }
}

