/*
 * Decompiled with CFR 0.152.
 */
package problems.todo;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.stream.IntStream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.modeler.api.ProblemAPI;
import org.xcsp.modeler.entities.CtrEntities;
import utility.Kit;
import variables.VariableInteger;

public class FappCSP
implements ProblemAPI {
    String fileName = this.imp().askString("instanceFileName");
    int relaxationLevel = this.imp().askInt("Relaxation level (from 0 to 10) : ", this.range(11));
    boolean zeroMode;
    Map<Integer, int[]> dataDoms;
    int[][] dataVars;
    int[][] ctrsCI;
    int[][] ctrsCE;
    int[][] ctrsCD;
    boolean standAlone = false;

    Map<Integer, int[]> loadDomains(Scanner scanner) {
        HashMap<Integer, ArrayList<Integer>> map = new HashMap<Integer, ArrayList<Integer>>();
        while (scanner.hasNext("DM")) {
            scanner.next();
            int id = scanner.nextInt();
            int value = scanner.nextInt();
            ArrayList<Integer> list = (ArrayList<Integer>)map.get(id);
            if (list == null) {
                list = new ArrayList<Integer>();
                map.put(id, list);
            }
            list.add(value);
        }
        HashMap<Integer, int[]> domains = new HashMap<Integer, int[]>();
        for (Map.Entry e : map.entrySet()) {
            domains.put((Integer)e.getKey(), Kit.sort(Kit.intArray((Collection)e.getValue())));
        }
        return domains;
    }

    int[][] loadVariables(Scanner scanner) {
        ArrayList<int[]> list = new ArrayList<int[]>();
        while (scanner.hasNext("TR")) {
            scanner.next();
            int id = scanner.nextInt();
            int domainId = scanner.nextInt();
            int polarisation = scanner.nextInt();
            if (list.size() == 0) {
                Kit.control(id == 0 || id == 1);
                this.zeroMode = id == 0;
            } else {
                Kit.control(id == list.size() + (!this.zeroMode ? 1 : 0));
            }
            list.add(new int[]{id, domainId, polarisation});
        }
        return Kit.intArray2D(list);
    }

    void loadConstraints(Scanner scanner) {
        ArrayList<int[]> listCI = new ArrayList<int[]>();
        ArrayList<int[]> listCE = new ArrayList<int[]>();
        ArrayList<int[]> listCD = new ArrayList<int[]>();
        while (scanner.hasNext()) {
            String s = scanner.next();
            if (s.equals("CI")) {
                listCI.add(new int[]{scanner.nextInt(), scanner.nextInt(), scanner.next().equals("F") ? 1 : 0, scanner.next().equals("E") ? 1 : 0, scanner.nextInt()});
                continue;
            }
            if (s.equals("CE")) {
                listCE.add(IntStream.range(0, 13).map(i -> scanner.nextInt()).toArray());
                continue;
            }
            listCD.add(IntStream.range(0, 13).map(i -> scanner.nextInt()).toArray());
        }
        this.ctrsCI = Kit.intArray2D(listCI);
        this.ctrsCE = Kit.intArray2D(listCE);
        this.ctrsCD = Kit.intArray2D(listCD);
    }

    void data() {
        try (Scanner scanner = new Scanner(new File(this.fileName));){
            this.dataDoms = this.loadDomains(scanner);
            this.dataVars = this.loadVariables(scanner);
            this.loadConstraints(scanner);
        }
        catch (IOException e) {
            Kit.exit("Erreur ouverture fichier " + this.fileName, e);
        }
    }

    int[] buildDomain(int[] frequencies, int polarisation) {
        int[] domain = new int[(polarisation == 0 ? 2 : 1) * frequencies.length];
        if (polarisation < 1) {
            for (int i = 0; i < frequencies.length; ++i) {
                domain[i] = -frequencies[i];
            }
        }
        if (polarisation > -1) {
            int gap = polarisation == 0 ? frequencies.length : 0;
            for (int i = 0; i < frequencies.length; ++i) {
                domain[i + gap] = frequencies[i];
            }
        }
        return domain;
    }

    private CtrEntities.CtrEntity buildImperativeCtr(IVar.Var[] m, int[] t) {
        XNodeParent<IVar> predicate;
        IVar.Var x = m[t[0] + (!this.zeroMode ? -1 : 0)];
        IVar.Var y = m[t[1] + (!this.zeroMode ? -1 : 0)];
        boolean frequencyType = t[2] == 1;
        boolean equalityType = t[3] == 1;
        int gap = t[4];
        if (frequencyType && equalityType && gap == 0) {
            predicate = this.eq(this.abs(x), this.abs(y));
        } else if (frequencyType && !equalityType && gap == 0) {
            predicate = this.ne(this.abs(x), this.abs(y));
        } else if (frequencyType && equalityType && gap != 0) {
            predicate = this.eq(this.dist(this.abs(x), this.abs(y)), gap);
        } else if (frequencyType && !equalityType && gap != 0) {
            predicate = this.ne(this.dist(this.abs(x), this.abs(y)), gap);
        } else if (!frequencyType && equalityType && gap == 0) {
            predicate = this.ge(this.mul(x, y), 0);
        } else if (!frequencyType && !equalityType && gap == 0) {
            predicate = this.le(this.mul(x, y), 0);
        } else {
            throw new IllegalArgumentException();
        }
        return this.intension(predicate);
    }

    private CtrEntities.CtrEntity buildRadioCompatibilityCtrWithPolarization(IVar.Var[] m, int[] t, int relaxationLevel, boolean equalPolarization) {
        IVar.Var x = m[t[0] + (!this.zeroMode ? -1 : 0)];
        IVar.Var y = m[t[1] + (!this.zeroMode ? -1 : 0)];
        int gap = t[2 + relaxationLevel];
        XNodeParent<IVar> predicate = equalPolarization ? this.or(this.lt(this.mul(x, y), "0"), this.ge(this.abs(this.sub(x, y)), gap)) : this.or(this.gt(this.mul(x, y), "0"), this.ge(this.abs(this.sub(this.abs(x), this.abs(y))), gap));
        return this.intension(predicate);
    }

    @Override
    public void model() {
        IVar.Var[] m = this.standAlone ? (IVar.Var[])IntStream.range(0, this.dataVars.length).mapToObj(i -> this.var("x" + i, this.dom(this.buildDomain(this.dataDoms.get(this.dataVars[i][1]), this.dataVars[i][2])), new Types.TypeClass[0])).toArray(VariableInteger[]::new) : this.array("x", this.size(this.dataVars.length), (int i) -> this.dom(this.buildDomain(this.dataDoms.get(this.dataVars[i][1]), this.dataVars[i][2])), new Types.TypeClass[0]);
        this.forall(this.range(this.ctrsCI.length), (int i) -> this.buildImperativeCtr(m, this.ctrsCI[i]));
        this.forall(this.range(this.ctrsCE.length), (int i) -> this.buildRadioCompatibilityCtrWithPolarization(m, this.ctrsCE[i], this.relaxationLevel, true));
        this.forall(this.range(this.ctrsCD.length), (int i) -> this.buildRadioCompatibilityCtrWithPolarization(m, this.ctrsCD[i], this.relaxationLevel, false));
    }
}

