/*
 * Decompiled with CFR 0.152.
 */
package problems.todo;

import java.util.Arrays;
import java.util.stream.IntStream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.enumerations.EnumerationOfPermutations;
import org.xcsp.common.structures.Table;
import org.xcsp.modeler.api.ProblemAPI;
import org.xcsp.modeler.implementation.NotData;

public class BlockParty
implements ProblemAPI {
    int[][] data;
    @NotData
    int[][] pp = new int[][]{{21, 12, 7}, {23, 17, 11}, {24, 4, 18}, {22, 8, 3}, {1, 6, 16}, {2, 14, 20}, {4, 18, 24}, {3, 22, 8}, {7, 21, 12}, {5, 10, 15}, {6, 16, 1}, {8, 3, 22}, {16, 1, 6}, {15, 5, 10}, {13, 9, 19}, {14, 20, 2}, {18, 24, 4}, {20, 2, 14}, {19, 13, 9}, {17, 11, 23}, {12, 7, 21}, {11, 23, 17}, {9, 19, 13}, {10, 15, 5}};
    @NotData
    int[][] faces = new int[][]{{0, 1, 2, 3}, {4, 5, 6, 7}, {8, 10, 12, 14}, {9, 11, 13, 15}, {16, 17, 20, 21}, {18, 19, 22, 23}};

    private Table partyTable() {
        int[][] diffEqual = this.table().add(0, 0, 0, 0).add(1, 1, 1, 1).add(2, 2, 2, 2).add(3, 3, 3, 3).add(this.allPermutations(4)).toArray();
        Table table = this.table();
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < 64; ++j) {
                for (int k = 0; k < 64; ++k) {
                    for (int l = 0; l < 64; ++l) {
                        int[] shape = IntStream.of(i, j, k, l).map(v -> v % 4).toArray();
                        if (Arrays.binarySearch(diffEqual, shape, Utilities.lexComparatorInt) < 0) continue;
                        int[] color = IntStream.of(i, j, k, l).map(v -> v % 16 / 4).toArray();
                        if (Arrays.binarySearch(diffEqual, color, Utilities.lexComparatorInt) < 0) continue;
                        int[] fill = IntStream.of(i, j, k, l).map(v -> v / 16).toArray();
                        if (Arrays.binarySearch(diffEqual, fill, Utilities.lexComparatorInt) < 0) continue;
                        table.add(i, j, k, l);
                    }
                }
            }
        }
        return table;
    }

    @Override
    public void model() {
        boolean ud = false;
        int lr = 8;
        int fb = 16;
        int nCubes = 8;
        int nPos = 24;
        int nSymbols = 64;
        IVar.Var[] cube_at = this.array("c", this.size(nCubes), this.dom(this.range(nCubes)), new Types.TypeClass[0]);
        IVar.Var[] symbol_at = this.array("s", this.size(nPos), this.dom(this.range(nSymbols)), new Types.TypeClass[0]);
        this.allDifferent(cube_at).note("each cube is put at a different place");
        Table table = this.partyTable();
        System.out.println("Size= " + table.size() + " => " + table);
        this.forall(this.range(6), (int i) -> this.extension(this.select(symbol_at, this.faces[i]), table));
        this.block(() -> {
            this.equal(cube_at[0], 0);
            this.lessThan(cube_at[1], cube_at[2]);
            this.lessThan(cube_at[1], cube_at[4]);
        }).tag(SYMMETRY_BREAKING);
        int[][] m = new EnumerationOfPermutations(4).toArray();
    }
}

