/*
 * Decompiled with CFR 0.152.
 */
package problems.rand;

import constraints.Constraint;
import constraints.hard.CtrExtension;
import java.text.DecimalFormat;
import java.util.Random;
import java.util.stream.IntStream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.modeler.api.ProblemAPI;
import org.xcsp.modeler.implementation.NotData;
import problem.Problem;
import tools.random.RandomGeneration;
import utility.Kit;
import variables.Variable;

public final class ExplicitRandomQuestion
implements ProblemAPI {
    int n;
    int d;
    int e;
    int r;
    int mode;
    double tightness;
    int seed;
    RandomGeneration.RandomGenerationProp.TypeList macroType;
    RandomGeneration.RandomGenerationProp.TypeList microType;
    boolean repetition;
    boolean sat;
    boolean sameRels;
    int nKernels;
    int nK;
    int dK;
    int eK;
    int rK;
    int modeK;
    double tightnessK;
    RandomGeneration.RandomGenerationProp.TypeList macroTypeK;
    RandomGeneration.RandomGenerationProp.TypeList microTypeK;
    int nLinks;
    int modeL;
    double tightnessL;
    @NotData
    Random random;
    @NotData
    public int[] forcedSolution;
    @NotData
    boolean positive;
    @NotData
    int[][] tuples;

    public ExplicitRandomQuestion() {
        this.random = new Random(this.seed);
    }

    @Override
    public String name() {
        String s = "rand-" + this.r + "-" + this.n + "-" + this.d + "-" + this.e;
        if (this.mode == 1) {
            s = s + "-t" + new DecimalFormat("000").format(Math.round(this.tightness * 100.0));
            double pd = Math.pow(this.d, this.r);
            s = s + "-" + (this.tightness < 1.0 - this.tightness ? "n" + Math.round(pd * this.tightness) : "p" + Math.round(pd * (1.0 - this.tightness)));
        } else if (this.mode == 2) {
            long t = Math.round(1000.0 * this.tightness);
            s = s + "-" + (t < 100L ? "0" : "") + t;
        } else {
            s = s + "-" + Math.round(this.tightness);
        }
        return s + (this.sat ? "-fcd" : "") + "-" + this.seed;
    }

    void data() {
        String tightnessMessage = "Tightness Mode\n  0 : tightness= nb of no goods \n  1 : tightness = proportion of no goods \n  2 : tightness = probability of no goods (real value between 0 and 1) \n  3 : tightness = probability of no goods (integer value between 1 and 255)\n  4 : tightness= nb of supports \n Your choice: ";
        String graphMessage = "  0 : unstructured \n  1 : connected \n  2 : balanced \nYour choice : ";
        this.n = this.imp().askInt("nb variables");
        this.d = this.imp().askInt("domain size");
        this.e = this.imp().askInt("nb constraints");
        this.r = this.imp().askInt("arity");
        this.mode = this.imp().askInt(tightnessMessage, this.range(5));
        this.tightness = this.imp().askDouble("tightness");
        this.seed = this.imp().askInt("seed");
        this.macroType = RandomGeneration.RandomGenerationProp.TypeList.get(this.imp().askInt("Constraint Graph Type\n" + graphMessage, this.range(3)));
        this.microType = RandomGeneration.RandomGenerationProp.TypeList.get(this.imp().askInt("Incompatibility Graph Type\n" + graphMessage, this.range(3)));
        this.repetition = this.imp().askBoolean("Possibility of generating several constraints with same signature (yes/no) : ");
        this.sat = this.imp().askBoolean("Generation of forced satisfiable instances (yes/no) : ");
        this.sameRels = this.imp().askBoolean("Share relations between constraints (yes/no) : ");
        this.nKernels = this.imp().askInt("nbKernels", k -> k == 0 || !this.sat);
        Kit.control(!this.sat || this.nKernels == 0);
        this.nK = this.nKernels > 0 ? this.imp().askInt("nb variables (for kernels)") : 0;
        this.dK = this.nKernels > 0 ? this.imp().askInt("domain size (for kernels)") : 0;
        this.eK = this.nKernels > 0 ? this.imp().askInt("nb constraints (for kernels)") : 0;
        this.rK = this.nKernels > 0 ? this.imp().askInt("arity (for kernels)") : 0;
        this.modeK = this.nKernels > 0 ? this.imp().askInt("tightness mode (for kernels)") : 0;
        this.tightnessK = this.nKernels > 0 ? this.imp().askDouble("tightness -for kernels)") : 0.0;
        this.macroTypeK = RandomGeneration.RandomGenerationProp.TypeList.get(this.nKernels > 0 ? this.imp().askInt("constraint Graph Type (for kernels)") : 0);
        this.microTypeK = RandomGeneration.RandomGenerationProp.TypeList.get(this.nKernels > 0 ? this.imp().askInt("incompatibility Graph Type (for kernels)") : 0);
        this.nLinks = this.nKernels > 0 ? this.imp().askInt("Nb of links between kernels : ") : 0;
        this.modeL = this.nKernels > 0 && this.nLinks > 0 ? this.imp().askInt("tightness Mode (for links)") : 0;
        this.tightnessL = this.nKernels > 0 && this.nLinks > 0 ? this.imp().askDouble("tightness (for links)") : 0.0;
    }

    private Constraint buildExplicitConstraint(Variable[] scope, int tnessMode, double tightness, long seed, RandomGeneration.RandomGenerationProp.TypeList microType, int[] requiredSupport) {
        int[] nValues = Variable.domSizeArrayOf(scope, true);
        if (tnessMode == 0 || tnessMode == 1) {
            double nConflicts = tnessMode == 0 ? tightness : (double)Variable.nValidTuplesBoundedAtMaxValueFor(scope) * tightness;
            double nSupports = Utilities.nArrangementsFor(nValues).doubleValue() - nConflicts;
            Kit.control(nSupports <= 2.147483647E9 || nConflicts <= 2.147483647E9, () -> "The nb of conflicts/supports is greater than Integer.MAX_VALUE");
            int nTuples = (int)Math.min(nSupports, nConflicts);
            this.positive = (double)nTuples == nSupports;
            this.tuples = new RandomGeneration.RandomGenerationProp(nValues, seed).selectTuples(nTuples, microType, false, true, requiredSupport, this.positive);
        } else if (tnessMode == 2 || tnessMode == 3) {
            tightness = tnessMode == 2 ? tightness : tightness / 256.0;
            double selectionLimit = Math.min(tightness, 1.0 - tightness);
            this.positive = selectionLimit < tightness;
            this.tuples = new RandomGeneration.RandomGenerationProb(nValues, seed).selectTuples(selectionLimit, requiredSupport, this.positive);
        } else {
            assert (tnessMode == 4);
            Kit.control(tightness <= 2.147483647E9, () -> "Pb with tightness ");
            int nbSupports = (int)tightness;
            this.positive = true;
            this.tuples = new RandomGeneration.RandomGenerationProp(nValues, seed).selectTuples(nbSupports, microType, false, true, requiredSupport, this.positive);
        }
        return CtrExtension.build((Problem)this.imp(), scope, this.tuples, this.positive, Problem.UNSTARRED);
    }

    @Override
    public void model() {
        IVar.Var[] x = this.array("x", this.size(this.n), this.dom(this.range(this.d)), "x[i] is the value of the ith variable", new Types.TypeClass[0]);
        IVar.Var[][] k = this.nKernels > 0 ? this.array("k", this.size(this.nKernels, this.nK), this.dom(this.range(this.dK)), new Types.TypeClass[0]) : (IVar.Var[][])null;
        this.forcedSolution = this.sat ? IntStream.range(0, this.n).map(i -> this.random.nextInt(this.d)).toArray() : null;
        int[][] scopesIds = new RandomGeneration.RandomGenerationProp(this.n, this.r, this.seed).selectSets(this.e, this.macroType, this.repetition);
        this.forall(this.range(this.e), (int c) -> {
            int[] tuple;
            IVar.Var[] scope = (IVar.Var[])this.variablesFrom(scopesIds[c], id -> x[id]);
            int[] nArray = tuple = this.sat ? this.valuesFrom(scopesIds[c], (Integer id) -> this.forcedSolution[id]) : null;
            if (!this.sameRels || this.tuples == null) {
                ((Problem)this.imp()).addCtr(this.buildExplicitConstraint((Variable[])scope, this.mode, this.tightness, this.random.nextLong(), this.microType, tuple), new Types.TypeClass[0]);
            } else {
                this.extension(scope, this.tuples, (Boolean)this.positive);
            }
        });
        if (this.nKernels > 0) {
            RandomGeneration.RandomGenerationProp r = new RandomGeneration.RandomGenerationProp(this.nK, this.rK, this.seed);
            for (IVar.Var[] y : k) {
                for (int[] scopeIds : r.selectSets(this.eK, this.macroTypeK, this.repetition)) {
                    IVar.Var[] scope = (IVar.Var[])this.variablesFrom(scopeIds, id -> y[id]);
                    ((Problem)this.imp()).addCtr(this.buildExplicitConstraint((Variable[])scope, this.modeK, this.tightnessK, this.random.nextLong(), this.microTypeK, null), new Types.TypeClass[0]);
                }
            }
            Constraint[] linkConstraints = new Constraint[this.nLinks];
            for (int i2 = 0; i2 < this.nKernels; ++i2) {
                IVar.Var[] y = k[i2];
                for (int j = 0; j < this.nLinks; ++j) {
                    int[] scopeIds = new int[]{this.random.nextInt(this.n), this.random.nextInt(this.nK)};
                    while (!IntStream.range(0, j).noneMatch(m -> Variable.areSimilarArrays((Variable[])this.vars(x[scopeIds[0]], y[scopeIds[1]]), linkConstraints[m].scp))) {
                    }
                    IVar.Var[] scope = (IVar.Var[])this.vars(x[scopeIds[0]], y[scopeIds[1]]);
                    linkConstraints[j] = this.buildExplicitConstraint((Variable[])scope, this.modeL, this.tightnessL, this.random.nextLong(), this.microType, null);
                    ((Problem)this.imp()).addCtr(linkConstraints[j], new Types.TypeClass[0]);
                }
            }
        }
    }
}

