/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import constraints.hard.extension.structures.SmartTuple;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.structures.Table;
import org.xcsp.modeler.api.ProblemAPI;
import problem.Problem;

public class Wwtpp
implements ProblemAPI {
    int nIndustries;
    int nPeriods;
    int plantCapacity;
    int[] tankFlow;
    int[] tankCapacity;
    int[][] sd;
    int[][] spans;

    private Table shortTableFor(int i) {
        Table table = this.table(0, 0x7FFFFFFE);
        int v = this.tankFlow[i];
        while (v <= this.tankCapacity[i]) {
            table.add(this.tankFlow[i], v++);
        }
        for (v = 1; v <= Math.min(this.tankFlow[i], this.tankCapacity[i]); ++v) {
            table.add(v, v);
        }
        return table;
    }

    @Override
    public void model() {
        IVar.Var[][] b = this.array("b", this.size(this.nIndustries, this.nPeriods), (int i, int j) -> j == 0 && this.sd[i][0] == 0 || j == this.nPeriods - 1 ? this.dom(0, new int[0]) : this.dom(this.range(this.tankCapacity[i] + 1)), "b[i][j] is the flow stored in buffer i at the end of period j", new Types.TypeClass[0]);
        IVar.Var[][] d = this.array("d", this.size(this.nIndustries, this.nPeriods), (int i, int j) -> j == 0 ? this.dom(0, new int[0]) : this.dom(this.range(this.tankFlow[i] + 1)), "d[i][j] is the flow discharged from buffer (or industry) i during time period j", new Types.TypeClass[0]);
        IVar.Var[][] c = this.array("c", this.size(this.nIndustries, this.nPeriods), (int i, int j) -> this.sd[i][j] == 0 ? null : this.dom(0, this.sd[i][j]), "c[i][j] is the actual capacity requirement of industry i during time period j", new Types.TypeClass[0]);
        this.forall(this.range(this.nPeriods), (int j) -> this.sum((IVar.Var[])this.vars(this.select(c, (int i, int k) -> k == j && c[i][k] != null), this.columnOf(d, j)), LE, (long)this.plantCapacity)).note("not exceeding the Wastewater Treatment Plant");
        this.forall(this.range(this.nIndustries), (int i) -> {
            if (this.sd[i][0] != 0) {
                this.sum((IVar.Var[])this.vars(b[i][0], c[i][0]), EQ, (long)this.sd[i][0]);
            }
        }).note("managing scheduled discharge flows at period 0");
        this.forall(this.range(this.nIndustries).range(1, this.nPeriods), (int i, int j) -> {
            if (this.sd[i][j] != 0) {
                this.sum((IVar.Var[])this.vars(b[i][j], new IVar.Var[]{b[i][j - 1], d[i][j], c[i][j]}), this.vals(1, -1, 1, 1), EQ, (long)this.sd[i][j]);
            } else {
                this.sum((IVar.Var[])this.vars(b[i][j], new IVar.Var[]{b[i][j - 1], d[i][j]}), this.vals(1, -1, 1), EQ, 0L);
            }
        }).note("managing scheduled discharge flows at all periods except 0");
        this.forall(this.range(this.nIndustries).range(1, this.nPeriods), (int i, int j) -> {
            IVar[] scp = (IVar.Var[])this.vars(d[i][j], b[i][j - 1]);
            if (j == this.nPeriods - 1 || j - 1 == this.nPeriods - 1 || j - 1 == 0 && this.sd[i][0] == 0) {
                this.extension((IVar.Var[])scp, this.table("(0,0)"));
            } else if (this.modelVariant("")) {
                this.extension((IVar.Var[])scp, this.shortTableFor(i).toOrdinaryTableArray(this.tankFlow[i] + 1, this.tankCapacity[i] + 1));
            } else if (this.modelVariant("short")) {
                this.extension((IVar.Var[])scp, this.shortTableFor(i));
            } else if (this.modelVariant("smt")) {
                SmartTuple st1 = new SmartTuple(this.tuple(0, 0x7FFFFFFE));
                SmartTuple st2 = new SmartTuple(this.tuple(this.tankFlow[i], 0x7FFFFFFE), this.ge(b[i][j - 1], this.tankFlow[i]));
                SmartTuple st3 = new SmartTuple(this.eq(d[i][j], b[i][j - 1]));
                ((Problem)this.imp()).smart(scp, st1, st2, st3);
            }
        }).note("ensuring compatibility between stored and discharge flows");
        this.forall(this.range(this.spans.length), (int k) -> {
            int[] span = this.spans[k];
            IVar.Var[] scp = this.select(c[span[0]], span[1], span[2]);
            this.extension(scp, this.table(this.repeat(0, scp.length), this.select(this.sd[span[0]], span[1], span[2])));
        }).note("spanning constraints");
    }
}

