/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;

public class Warehouse
implements ProblemAPI {
    int fixedCost;
    int[] warehouseCapacities;
    int[][] storeSupplyCosts;

    @Override
    public void model() {
        int nWarehouses = this.warehouseCapacities.length;
        int nStores = this.storeSupplyCosts.length;
        IVar.Var[] w = this.array("w", this.size(nStores), this.dom(this.range(nWarehouses)), "w[i] is the warehouse supplying the ith store", new Types.TypeClass[0]);
        IVar.Var[] c = this.array("c", this.size(nStores), (int i) -> this.dom(this.storeSupplyCosts[i]), "c[i] is the cost of supplying the ith store", new Types.TypeClass[0]);
        IVar[] o = this.array("o", this.size(nWarehouses), this.dom(0, 1), "o[j] is 1 if the jth warehouse is open", new Types.TypeClass[0]);
        this.forall(this.range(nWarehouses), (int j) -> this.atMost(w, this.takingValue(j), this.warehouseCapacities[j])).note("capacities of warehouses must not be exceeded");
        this.forall(this.range(nStores), arg_0 -> this.lambda$model$2((IVar.Var[])o, w, arg_0)).note("the warehouse supplier of the ith store must be open");
        this.forall(this.range(nStores), (int i) -> this.element(this.storeSupplyCosts[i], this.at(w[i]), this.takingValue(c[i]))).note("computing the cost of supplying the ith store");
        int[] coeffs = this.vals(this.repeat(1, nStores), this.repeat(this.fixedCost, nWarehouses));
        this.minimize(SUM, this.vars(c, o), this.weightedBy(coeffs)).note("minimizing the overall cost");
    }

    private /* synthetic */ void lambda$model$2(IVar.Var[] o, IVar.Var[] w, int i) {
        this.element(o, this.at(w[i]), this.takingValue(1));
    }
}

