/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import java.util.stream.IntStream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.structures.Automaton;
import org.xcsp.common.structures.Table;
import org.xcsp.modeler.api.ProblemAPI;
import org.xcsp.modeler.implementation.NotData;

public class TravelingTournamentWithPredefinedVenues
implements ProblemAPI {
    int nTeams;
    int[][] predefinedVenues;
    @NotData
    private String t = "(q,0,q01)(q,1,q11)(q01,0,q02)(q01,1,q11)(q11,0,q01)(q11,1,q12)(q02,1,q11)(q12,0,q01)";
    @NotData
    private Automaton aut2 = this.automaton("q", this.t, "q01", "q02", "q11", "q12");
    @NotData
    private Automaton aut3 = this.automaton("q", this.t + "(q02,0,q03)(q12,1,q13)(q03,1,q11)(q13,0,q01)", "q01", "q02", "q03", "q11", "q12", "q13");

    private int circDistance(int i, int j) {
        return Math.min(Math.abs(i - j), this.nTeams - Math.abs(i - j));
    }

    private Table tableFirstOrLastGame(int i) {
        Table table = this.table().add(1, 0x7FFFFFFE, 0);
        return table.add(IntStream.range(0, this.nTeams).filter(j -> j != i).mapToObj(j -> this.tuple(0, j, this.circDistance(i, j))));
    }

    private Table tableForInternalGame(int i) {
        Table table = this.table().add(1, 1, 0x7FFFFFFE, 0x7FFFFFFE, 0);
        table.add(IntStream.range(0, this.nTeams).filter(j -> j != i).mapToObj(j -> this.tuple(0, 1, j, 0x7FFFFFFE, this.circDistance(j, i))));
        table.add(IntStream.range(0, this.nTeams).filter(j -> j != i).mapToObj(j -> this.tuple(1, 0, 0x7FFFFFFE, j, this.circDistance(i, j))));
        for (int j1 = 0; j1 < this.nTeams; ++j1) {
            for (int j2 = 0; j2 < this.nTeams; ++j2) {
                if (j1 == i || j2 == i || j1 == j2) continue;
                table.add(0, 0, j1, j2, this.circDistance(j1, j2));
            }
        }
        return table;
    }

    @Override
    public void model() {
        Utilities.control(this.nTeams % 2 == 0, "an even number of teams is expected");
        int nRounds = this.nTeams - 1;
        IVar.Var[][] o = this.array("o", this.size(this.nTeams, nRounds), this.dom(this.range(this.nTeams)), "o[i][k] is the opponent (team) of the ith team  at the kth round", new Types.TypeClass[0]);
        IVar.Var[][] h = this.array("h", this.size(this.nTeams, nRounds), this.dom(0, 1), "h[i][k] is 1 iff the ith team plays at home at the kth round", new Types.TypeClass[0]);
        IVar[][] t = this.array("t", this.size(this.nTeams, nRounds + 1), this.dom(this.range(this.nTeams / 2 + 1)), "t[i][k] is the travelled distance by the ith team at the kth round. An additional round is considered for returning at home.", new Types.TypeClass[0]);
        this.forall(this.range(this.nTeams).range(nRounds), (int i, int k) -> this.different(o[i][k], i)).note("a team cannot play against itself");
        this.forall(this.range(this.nTeams).range(nRounds), (int i, int k) -> this.element(this.predefinedVenues[i], o[i][k], h[i][k])).note("ensuring predefined venues");
        this.forall(this.range(this.nTeams).range(nRounds), (int i, int k) -> this.element(this.columnOf(o, k), o[i][k], i)).note("ensuring symmetry of games: if team i plays against j, then team j plays against i");
        this.forall(this.range(this.nTeams), (int i) -> this.allDifferent(o[i])).note("each team plays once against all other teams");
        this.forall(this.range(this.nTeams), (int i) -> this.regular(h[i], this.modelVariant("a2") ? this.aut2 : this.aut3)).note("at most " + (this.modelVariant("a2") ? 2 : 3) + " consecutive games at home, or consecutive games away");
        this.forall(this.range(this.nTeams), arg_0 -> this.lambda$model$11(h, o, (IVar.Var[][])t, arg_0)).note("handling travelling for the first game");
        this.forall(this.range(this.nTeams), arg_0 -> this.lambda$model$12(h, nRounds, o, (IVar.Var[][])t, arg_0)).note("handling travelling for the last game");
        this.forall(this.range(this.nTeams).range(nRounds - 1), (arg_0, arg_1) -> this.lambda$model$13(h, o, (IVar.Var[][])t, arg_0, arg_1)).note("handling travelling for two successive games");
        this.forall(this.range(nRounds), (int k) -> this.allDifferent(this.columnOf(o, k))).tag(REDUNDANT_CONSTRAINTS).note("at each round, opponents are all different");
        this.lessThan(o[0][0], o[0][nRounds - 1]).tag(SYMMETRY_BREAKING);
        this.minimize(SUM, t).note("minimizing summed up travelled distance");
    }

    private /* synthetic */ void lambda$model$13(IVar.Var[][] h, IVar.Var[][] o, IVar.Var[][] t, int i, int k) {
        this.extension((IVar.Var[])this.vars(h[i][k], new IVar.Var[]{h[i][k + 1], o[i][k], o[i][k + 1], t[i][k + 1]}), this.tableForInternalGame(i));
    }

    private /* synthetic */ void lambda$model$12(IVar.Var[][] h, int nRounds, IVar.Var[][] o, IVar.Var[][] t, int i) {
        this.extension((IVar.Var[])this.vars(h[i][nRounds - 1], new IVar.Var[]{o[i][nRounds - 1], t[i][nRounds]}), this.tableFirstOrLastGame(i));
    }

    private /* synthetic */ void lambda$model$11(IVar.Var[][] h, IVar.Var[][] o, IVar.Var[][] t, int i) {
        this.extension((IVar.Var[])this.vars(h[i][0], new IVar.Var[]{o[i][0], t[i][0]}), this.tableFirstOrLastGame(i));
    }
}

