/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.structures.Automaton;
import org.xcsp.common.structures.Table;
import org.xcsp.common.structures.Transitions;
import org.xcsp.modeler.api.ProblemAPI;

public class TravelingTournament
implements ProblemAPI {
    int[][] distances;

    private Table tableEnd(int i) {
        Table table = this.table().add(1, 0x7FFFFFFE, 0);
        return table.addFrom(this.range(this.distances.length), j -> j != i ? this.tuple(0, (int)j, this.distances[i][j]) : null);
    }

    private Table tableOther(int i) {
        int nTeams = this.distances.length;
        Table table = this.table().add(1, 1, 0x7FFFFFFE, 0x7FFFFFFE, 0);
        table.addFrom(this.range(nTeams), j -> j != i ? this.tuple(0, 1, (int)j, 0x7FFFFFFE, this.distances[i][j]) : null);
        table.addFrom(this.range(nTeams), j -> j != i ? this.tuple(1, 0, 0x7FFFFFFE, (int)j, this.distances[i][j]) : null);
        return table.addFrom(this.range(nTeams).range(nTeams), (j1, j2) -> j1 != i && j2 != i && j1 != j2 ? this.tuple(0, 0, (int)j1, (int)j2, this.distances[j1][j2]) : null);
    }

    private Automaton buildAutomaton() {
        Transitions transitions = this.transitions("(q,0,q01)(q,1,q11)(q01,0,q02)(q01,1,q11)(q11,0,q01)(q11,1,q12)(q02,1,q11)(q12,0,q01)");
        if (this.modelVariant("a2")) {
            return this.automaton("q", transitions, this.finalStates("q01", "q02", "q11", "q12"));
        }
        transitions = this.transitions(transitions + "(q02,0,q03)(q12,1,q13)(q03,1,q11)(q13,0,q01)");
        return this.automaton("q", transitions, this.finalStates("q01", "q02", "q03", "q11", "q12", "q13"));
    }

    @Override
    public void model() {
        int nTeams = this.distances.length;
        int nRounds = nTeams * 2 - 2;
        Utilities.control(nTeams % 2 == 0, "An even number of teams is expected");
        IVar.Var[][] o = this.array("o", this.size(nTeams, nRounds), this.dom(this.range(nTeams)), "o[i][k] is the opponent (team) of the ith team  at the kth round", new Types.TypeClass[0]);
        IVar.Var[][] h = this.array("h", this.size(nTeams, nRounds), this.dom(0, 1), "h[i][k] is 1 iff the ith team plays at home at the kth round", new Types.TypeClass[0]);
        IVar.Var[][] a = this.array("a", this.size(nTeams, nRounds), this.dom(0, 1), "a[i][k] is 0 iff the ith team plays away at the kth round", new Types.TypeClass[0]);
        IVar[][] t = this.array("t", this.size(nTeams, nRounds + 1), this.dom(this.distances), "t[i][k] is the travelled distance by the ith team at the kth round. An additional round is considered for returning at home.", new Types.TypeClass[0]);
        this.forall(this.range(nTeams), (int i) -> this.cardinality(o[i], this.range(nTeams).select(j -> j != i), (boolean)CLOSED, this.occursEachExactly(2))).note("each team must play exactly two times against each other team");
        this.forall(this.range(nTeams).range(nRounds), (int i, int k) -> this.element(this.columnOf(o, k), this.at(o[i][k]), this.takingValue(i))).note("ensuring symmetry of games: if team i plays against j at round k, then team j plays against i at round k");
        this.forall(this.range(nTeams).range(nRounds), (int i, int k) -> this.equal(h[i][k], this.not(a[i][k]))).note("playing home at round k iff not playing away at round k");
        this.forall(this.range(nTeams).range(nRounds), (int i, int k) -> this.element(this.columnOf(h, k), this.at(o[i][k]), this.takingValue(a[i][k]))).note("channeling the three arrays");
        this.forall(this.range(nTeams).range(nRounds).range(nRounds), (int i, int k1, int k2) -> {
            if (k1 + 1 < k2) {
                this.implication(this.eq(o[i][k1], o[i][k2]), this.ne(h[i][k1], h[i][k2]));
            }
        }).note("playing against the same team must be done once at home and once away");
        this.forall(this.range(nRounds), (int k) -> this.allDifferent(this.columnOf(o, k))).tag(REDUNDANT_CONSTRAINTS).note("at each round, opponents are all different");
        this.lessThan(o[0][0], o[0][nRounds - 1]).tag(SYMMETRY_BREAKING);
        Automaton automaton = this.buildAutomaton();
        this.forall(this.range(nTeams), (int i) -> this.regular(h[i], automaton)).note("at most " + (this.modelVariant("a2") ? 2 : 3) + " consecutive games at home, or consecutive games away");
        this.forall(this.range(nTeams), arg_0 -> this.lambda$model$12(h, o, (IVar.Var[][])t, arg_0)).note("handling travelling for the first game");
        this.forall(this.range(nTeams), arg_0 -> this.lambda$model$13(h, nRounds, o, (IVar.Var[][])t, arg_0)).note("handling travelling for the last game");
        this.forall(this.range(nTeams).range(nRounds - 1), (arg_0, arg_1) -> this.lambda$model$14(h, o, (IVar.Var[][])t, arg_0, arg_1)).note("handling travelling for two successive games");
        this.minimize(SUM, t).note("minimizing summed up travelled distance");
    }

    private /* synthetic */ void lambda$model$14(IVar.Var[][] h, IVar.Var[][] o, IVar.Var[][] t, int i, int k) {
        this.extension((IVar.Var[])this.vars(h[i][k], new IVar.Var[]{h[i][k + 1], o[i][k], o[i][k + 1], t[i][k + 1]}), this.tableOther(i));
    }

    private /* synthetic */ void lambda$model$13(IVar.Var[][] h, int nRounds, IVar.Var[][] o, IVar.Var[][] t, int i) {
        this.extension((IVar.Var[])this.vars(h[i][nRounds - 1], new IVar.Var[]{o[i][nRounds - 1], t[i][nRounds]}), this.tableEnd(i));
    }

    private /* synthetic */ void lambda$model$12(IVar.Var[][] h, IVar.Var[][] o, IVar.Var[][] t, int i) {
        this.extension((IVar.Var[])this.vars(h[i][0], new IVar.Var[]{o[i][0], t[i][0]}), this.tableEnd(i));
    }
}

