/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;

public class TemplateDesign
implements ProblemAPI {
    int nSlots;
    int[] demands;

    private int lb(int v) {
        return (int)Math.ceil((double)this.demands[v] * 0.95);
    }

    private int ub(int v) {
        return (int)Math.floor((double)this.demands[v] * 1.1);
    }

    @Override
    public void model() {
        int nVariations;
        int maxDemand = this.maxOf(this.demands);
        int nTemplates = nVariations = this.demands.length;
        IVar.Var[][] d = this.array("d", this.size(nTemplates, nVariations), this.dom(this.range(this.nSlots + 1)), "d[i][j] is the number of occurrences of the jth variation on the ith template", new Types.TypeClass[0]);
        IVar.Var[] p = this.array("p", this.size(nTemplates), this.dom(this.range(maxDemand + 1)), "p[i] is the number of printings of the ith template", new Types.TypeClass[0]);
        this.forall(this.range(nTemplates), (int t) -> this.sum(d[t], EQ, (long)this.nSlots)).note("all slots of all templates are used");
        if (this.modelVariant("")) {
            this.forall(this.range(nVariations), (int v) -> this.sum(p, this.weightedBy(this.columnOf(d, v)), IN, this.range(this.lb(v), this.ub(v) + 1))).note("respecting printing bounds for each variation");
        }
        if (this.modelVariant("aux")) {
            IVar.Var[][] pv = this.array("pv", this.size(nTemplates, nVariations), (int t, int v) -> this.dom(this.range(this.ub(v) + 1)), "pv[i][j] is the number of printings of the jth variation by using the ith template", new Types.TypeClass[0]);
            this.forall(this.range(nTemplates).range(nVariations), (int t, int v) -> this.equal(this.mul(p[t], d[t][v]), pv[t][v])).note("linking variables of arrays p and pv");
            this.forall(this.range(nVariations), (int v) -> this.sum(this.columnOf(pv, v), IN, this.range(this.lb(v), this.ub(v) + 1))).note("respecting printing bounds for each variation v");
        }
        this.block(() -> {
            this.forall(this.range(nTemplates), (int t) -> this.equivalence(this.eq(p[t], 0), this.eq(d[t][0], this.nSlots)));
            this.decreasing(p);
        }).tag(SYMMETRY_BREAKING);
        this.minimize(SUM, this.treesFrom(this.range(nTemplates), (Integer i) -> this.gt(p[i], 0))).note("minimizing the number of used templates");
    }
}

