/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.modeler.api.ProblemAPI;

public class SteelMillSlab
implements ProblemAPI {
    int[] slabCapacities;
    Order[] orders;

    private int[][] colorGroups(int[] allColors) {
        return (int[][])IntStream.of(allColors).mapToObj(c -> this.range(this.orders.length).select(i -> this.orders[i].color == c)).toArray(x$0 -> new int[x$0][]);
    }

    @Override
    public void model() {
        this.slabCapacities = this.singleValuesIn(0, this.slabCapacities);
        int maxCapacity = this.slabCapacities[this.slabCapacities.length - 1];
        int[] possibleLosses = this.range(maxCapacity + 1).map(i -> this.minOf(this.select(this.slabCapacities, (int v) -> v >= i)) - i);
        int[] sizes = this.valuesFrom(this.orders, (T o) -> o.size);
        int totalSize = this.sumOf(sizes);
        int[] allColors = this.singleValuesFrom(this.orders, (T order) -> order.color);
        int nOrders = this.orders.length;
        int nSlabs = this.orders.length;
        int nColors = allColors.length;
        IVar.Var[] sb = this.array("sb", this.size(nOrders), this.dom(this.range(nSlabs)), "sb[i] is the slab used to produce the ith order", new Types.TypeClass[0]);
        IVar.Var[] ld = this.array("ld", this.size(nSlabs), this.dom(this.range(maxCapacity + 1)), "ld[j] is the load of the jth slab", new Types.TypeClass[0]);
        IVar[] ls = this.array("ls", this.size(nSlabs), this.dom(possibleLosses), "ls[j] is the loss of the jth slab", new Types.TypeClass[0]);
        if (this.modelVariant("")) {
            this.forall(this.range(nSlabs), (int s) -> this.sum(this.treesFrom(sb, (IVar x) -> this.eq(x, s)), this.weightedBy(sizes), EQ, ld[s])).note("computing (and checking) the load of each slab");
            this.forall(this.range(nSlabs), arg_0 -> this.lambda$model$9(ld, (IVar.Var[])ls, possibleLosses, arg_0)).note("computing the loss of each slab");
            int[][] colorMemberships = this.colorGroups(allColors);
            this.forall(this.range(nSlabs), (int s) -> this.sum(Stream.of(colorMemberships).map(g -> this.or(this.treesFrom((int[])g, (Integer o) -> this.eq(sb[o], s)))), LE, 2L)).note("no more than two colors for each slab");
        }
        if (this.modelVariant("01")) {
            IVar.Var[][] y = this.array("y", this.size(nSlabs, nOrders), this.dom(0, 1), "y[j][i] is 1 iff the jth slab is used to produce the ith order", new Types.TypeClass[0]);
            IVar.Var[][] z = this.array("z", this.size(nSlabs, nColors), this.dom(0, 1), "z[j][c] is 1 iff the jth slab is used to produce an order of color c", new Types.TypeClass[0]);
            this.forall(this.range(nSlabs).range(nOrders), (int s, int o) -> this.equivalence(this.eq(sb[o], s), y[s][o])).note("linking variables sb and y");
            this.forall(this.range(nSlabs).range(nOrders), (int s, int o) -> this.implication(this.eq(sb[o], s), z[s][Utilities.indexOf(this.orders[o].color, allColors)])).note("linking variables sb and z");
            this.forall(this.range(nSlabs), (int s) -> this.sum(y[s], this.weightedBy(sizes), EQ, ld[s])).note("computing (and checking) the load of each slab");
            this.forall(this.range(nSlabs), arg_0 -> this.lambda$model$16(ld, (IVar.Var[])ls, possibleLosses, arg_0)).note("computing the loss of each slab");
            this.forall(this.range(nSlabs), (int s) -> this.sum(z[s], LE, 2L)).note("no more than two colors for each slab");
        }
        this.sum(ld, EQ, (long)totalSize).tag(REDUNDANT_CONSTRAINTS);
        this.block(() -> {
            this.decreasing(ld);
            this.forall(this.range(nOrders).range(nOrders), (int i, int j) -> {
                if (i < j && this.orders[i].size == this.orders[j].size && this.orders[i].color == this.orders[j].color) {
                    this.lessEqual(sb[i], sb[j]);
                }
            });
        }).tag(SYMMETRY_BREAKING);
        this.minimize(SUM, ls).note("minimizing summed up loss");
    }

    private /* synthetic */ void lambda$model$16(IVar.Var[] ld, IVar.Var[] ls, int[] possibleLosses, int s) {
        this.extension((IVar.Var[])this.vars(ld[s], ls[s]), this.indexing(possibleLosses));
    }

    private /* synthetic */ void lambda$model$9(IVar.Var[] ld, IVar.Var[] ls, int[] possibleLosses, int s) {
        this.extension((IVar.Var[])this.vars(ld[s], ls[s]), this.indexing(possibleLosses));
    }

    class Order {
        int size;
        int color;

        Order() {
        }
    }
}

