/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.structures.Automaton;
import org.xcsp.common.structures.Table;
import org.xcsp.common.structures.Transitions;
import org.xcsp.modeler.api.ProblemAPI;

public class SolitaireBattleship
implements ProblemAPI {
    ShipCategory[] fleet;
    int[] rowSums;
    int[] colSums;
    Hint[] hints;

    private Automaton automataForShipsOnLine(boolean hor) {
        int[] pos = Stream.of(this.fleet).mapToInt(s -> s.size).toArray();
        int[] neg = Stream.of(this.fleet).mapToInt(s -> -s.size).toArray();
        int[] t1 = hor ? neg : pos;
        int[] t2 = hor ? pos : neg;
        Transitions transitions = this.transitions().add("q0", 0, "q0").add("q0", t1, "qq").add("qq", 0, "q0");
        for (int i : t2) {
            int absi = Math.abs(i);
            transitions.add("q0", i, "q" + absi + "x" + 1);
            IntStream.range(1, absi).forEach(j -> transitions.add("q" + absi + "x" + j, i, "q" + absi + "x" + (j + 1)));
            transitions.add("q" + absi + "x" + absi, 0, "q0");
        }
        return this.automaton("q0", transitions, "q0");
    }

    @Override
    public void model() {
        int[] sizes = this.valuesFrom(this.fleet, (T ship) -> ship.size);
        int[] occurrences = this.valuesFrom(this.fleet, (T ship) -> ship.size * ship.cnt);
        int[] pos = sizes;
        int[] neg = this.valuesFrom(pos, (Integer v) -> -v.intValue());
        int[] values = this.valuesIn(pos, new Object[]{neg});
        int n = this.colSums.length;
        int nSizes = sizes.length;
        int maxOccurrence = this.maxOf(occurrences);
        IVar.Var[][] s = this.array("s", this.size(n + 2, n + 2), this.dom(0, 1), "s[i][j] is 1 iff the cell at row i and col j is occupied by a ship segment", new Types.TypeClass[0]);
        IVar.Var[][] t = this.array("t", this.size(n + 2, n + 2), this.dom(0, values), "t[i][j] is 0 iff the cell at row i and col j is unoccupied, the type (size) of the ship fragment otherwise, when positive, the ship is put horizontally, when negative, the ship is put vertically", new Types.TypeClass[0]);
        IVar.Var[] cp = this.array("cp", this.size(pos.length), this.dom(this.range(maxOccurrence + 1)), "cp[i] is the number of positive ship segments of type i", new Types.TypeClass[0]);
        IVar.Var[] cn = this.array("cn", this.size(neg.length), (int i) -> neg[i] == -1 ? this.dom(0, new int[0]) : this.dom(this.range(maxOccurrence + 1)), "cn[i] is the number of negative ship segments of type i", new Types.TypeClass[0]);
        this.block(() -> {
            this.sum(s[0], EQ, 0L);
            this.sum(s[n + 1], EQ, 0L);
            this.sum(this.columnOf(s, 0), EQ, 0L);
            this.sum(this.columnOf(s, n + 1), EQ, 0L);
        }).note("no ship on borders");
        this.block(() -> {
            this.forall(this.range(n), (int i) -> this.sum(s[i + 1], EQ, (long)this.rowSums[i]));
            this.forall(this.range(n), (int j) -> this.sum(this.columnOf(s, j + 1), EQ, (long)this.colSums[j]));
        }).note("respecting the specified row and column tallies");
        Table table = this.table().add(0, 0x7FFFFFFE, 0x7FFFFFFE, 0x7FFFFFFE, 0x7FFFFFFE).add(1, 0, 0, 0, 0);
        this.forall(this.rangeClosed(1, n).rangeClosed(1, n), (int i, int j) -> this.extension((IVar.Var[])this.vars(s[i][j], new IVar.Var[]{s[i - 1][j - 1], s[i - 1][j + 1], s[i + 1][j + 1], s[i + 1][j - 1]}), table)).note("being careful about cells on diagonals");
        this.forall(this.range(n + 2).range(n + 2), (int i, int j) -> this.equivalence(this.eq(s[i][j], 1), this.ne(t[i][j], 0))).tag(CHANNELING);
        this.block(() -> {
            IVar.Var[] scp = this.select(t, (int i, int j) -> 1 <= i && i <= n && 1 <= j && j <= n);
            this.cardinality(scp, pos, this.occurExactly(cp));
            this.cardinality(scp, neg, this.occurExactly(cn));
            this.forall(this.range(nSizes), (int i) -> this.equal(this.add(cp[i], cn[i]), occurrences[i]));
        }).note("ensuring the right number of occurrences of ship segments of each type");
        this.block(() -> {
            Automaton ah = this.automataForShipsOnLine(true);
            Automaton av = this.automataForShipsOnLine(false);
            this.forall(this.rangeClosed(1, n), (int i) -> this.regular(t[i], ah));
            this.forall(this.rangeClosed(1, n), (int j) -> this.regular(this.columnOf(t, j), av));
        }).note("ensuring connexity of ship segments");
        if (this.hints != null) {
            this.forall(this.range(this.hints.length), (int h) -> {
                Hint hint = this.hints[h];
                int i = hint.row;
                int j = hint.col;
                char c = hint.type.charAt(0);
                if (c == 'w') {
                    this.equal(s[i][j], 0);
                } else if (c == 'c' || c == 'l' || c == 'r' || c == 't' || c == 'b') {
                    this.equal(s[i][j], 1);
                    this.equal(s[i - 1][j], c == 'b' ? 1 : 0);
                    this.equal(s[i + 1][j], c == 't' ? 1 : 0);
                    this.equal(s[i][j - 1], c == 'r' ? 1 : 0);
                    this.equal(s[i][j + 1], c == 'l' ? 1 : 0);
                } else if (c == 'm') {
                    this.equal(s[i][j], 1);
                    this.intension(this.not(this.in(t[i][j], this.set(-2, -1, 0, 1, 2))));
                    this.extension((IVar.Var[])this.vars(s[i - 1][j], new IVar.Var[]{s[i + 1][j], s[i][j - 1], s[i][j + 1]}), this.table().add(0, 0, 1, 1).add(1, 1, 0, 0));
                }
            }).tag(CLUES);
        }
    }

    class Hint {
        String type;
        int row;
        int col;

        Hint() {
        }
    }

    class ShipCategory {
        int size;
        int cnt;

        ShipCategory() {
        }
    }
}

