/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import java.util.stream.IntStream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;

public class SchedulingOS
implements ProblemAPI {
    int[][] durations;

    @Override
    public void model() {
        int n = this.durations.length;
        int m = this.durations[0].length;
        int sumDurations = this.sumOf(this.valuesFrom((T[])this.durations, (T t) -> this.sumOf((int[])t)));
        int maxTime = sumDurations + 1;
        IVar.Var[][] s = this.array("s", this.size(n, m), this.dom(this.range(maxTime)), "s[i][j] is the start time of the jth operation for the ith job", new Types.TypeClass[0]);
        IVar.Var[][] d = this.array("d", this.size(n, m), (int i, int j) -> this.dom(this.durations[i]), "d[i][j] is the duration of the jth operation of the ith job", new Types.TypeClass[0]);
        IVar.Var[][] mc = this.array("mc", this.size(n, m), this.dom(this.range(m)), "mc[i][j] is the machine used for the jth operation of the ith job", new Types.TypeClass[0]);
        IVar.Var[][] sd = this.array("sd", this.size(n, m), this.dom(this.range(maxTime)), "sd[i][k] is the start (dual) time of the kth machine when used for the ith job", new Types.TypeClass[0]);
        this.forall(this.range(n), (int i) -> this.ordered(s[i], d[i], INCREASING)).note("operations must be ordered on each job");
        this.forall(this.range(n), (int i) -> this.allDifferent(mc[i])).note("each machine must be used for each job");
        this.forall(this.range(n).range(m), (int i, int j) -> this.extension((IVar.Var[])this.vars(mc[i][j], d[i][j]), this.indexing(this.durations[i])));
        this.forall(this.range(n).range(m), (int i, int j) -> this.element(sd[i], mc[i][j], s[i][j])).tag(CHANNELING);
        this.forall(this.range(m), (int j) -> this.noOverlap(this.columnOf(sd, j), this.columnOf(this.durations, j))).note("no overlap on resources");
        this.forall(this.range(n), (int i) -> this.greaterEqual(this.add(s[i][m - 1], d[i][m - 1]), IntStream.of(this.durations[i]).sum())).tag(REDUNDANT_CONSTRAINTS);
        this.minimize(MAXIMUM, this.treesFrom(this.range(n), (Integer i) -> this.add(s[i][m - 1], d[i][m - 1]))).note("minimizing the makespan");
    }
}

