/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;

public class Rcpsp
implements ProblemAPI {
    int horizon;
    int[] resourceCapacities;
    Job[] jobs;

    @Override
    public void model() {
        int nJobs = this.jobs.length;
        IVar.Var[] s = this.array("s", this.size(nJobs), (int i) -> i == 0 ? this.dom(0, new int[0]) : this.dom(this.range(this.horizon)), "s[i] is the starting time of the ith job", new Types.TypeClass[0]);
        this.forall(this.range(nJobs).range(nJobs), (int i, int j) -> {
            if (j < this.jobs[i].successors.length) {
                this.lessEqual(this.add(s[i], this.jobs[i].duration), s[this.jobs[i].successors[j]]);
            }
        }).note("precedence constraints");
        this.forall(this.range(this.resourceCapacities.length), (int j) -> {
            int[] indexes = this.select(this.range(nJobs), (int i) -> this.jobs[i].requiredQuantities[j] > 0);
            IVar.Var[] origins = (IVar.Var[])this.variablesFrom(indexes, index -> s[index]);
            int[] lengths = this.valuesFrom(indexes, (Integer index) -> this.jobs[index.intValue()].duration);
            int[] heights = this.valuesFrom(indexes, (Integer index) -> this.jobs[index.intValue()].requiredQuantities[j]);
            this.cumulative(origins, lengths, heights, (long)this.resourceCapacities[j]);
        }).note("resource constraints");
        this.minimize(s[nJobs - 1]);
    }

    class Job {
        int duration;
        int[] successors;
        int[] requiredQuantities;

        Job() {
        }
    }
}

