/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import java.util.ArrayList;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;
import org.xcsp.modeler.entities.CtrEntities;

public class RadarSurveillance
implements ProblemAPI {
    int mapSize;
    int maxCoverage;
    int[][] radars;
    int[][] insignificantCells;

    private int distance(int iCell, int jCell, int iCurr, int jCurr, Sector sector, int currDistance, int maxDistance) {
        if (currDistance > maxDistance) {
            return -1;
        }
        if (iCell == iCurr && jCell == jCurr) {
            return currDistance;
        }
        int distance = this.distance(iCell, jCell, sector.rowOfNextRightCell(iCurr), sector.colOfNextRightCell(iCurr, jCurr), sector, currDistance + 1, maxDistance);
        if (distance != -1) {
            return distance;
        }
        return this.distance(iCell, jCell, sector.rowOfNextLeftCell(iCurr), sector.colOfNextLeftCell(iCurr, jCurr), sector, currDistance + 1, maxDistance);
    }

    private boolean isInsignificant(int iCell, int jCell) {
        return Stream.of(this.insignificantCells).anyMatch(t -> t[0] == iCell && t[1] == jCell);
    }

    private CtrEntities.CtrEntity dealWithCell(IVar.Var[][] x, int iCell, int jCell, int maximumDistance) {
        ArrayList<IVar.Var> vars = new ArrayList<IVar.Var>();
        ArrayList<Integer> dists = new ArrayList<Integer>();
        for (int i2 = 0; i2 < this.radars.length; ++i2) {
            for (Sector sector : Sector.values()) {
                int distance = this.distance(iCell, jCell, sector.rowOfNextRightCell(this.radars[i2][0]), sector.colOfNextRightCell(this.radars[i2][0], this.radars[i2][1]), sector, 1, maximumDistance);
                if (distance == -1) continue;
                vars.add(x[i2][sector.ordinal()]);
                dists.add(distance);
            }
        }
        if (vars.size() == 0) {
            return null;
        }
        if (vars.size() == 1) {
            return this.isInsignificant(iCell, jCell) ? this.lessThan(vars.get(0), dists.get(0)) : this.greaterThan(vars.get(0), (Integer)dists.get(0) - 1);
        }
        return this.sum(this.treesFrom(IntStream.range(0, vars.size()), (Integer i) -> this.ge(vars.get((int)i), dists.get((int)i))), EQ, this.isInsignificant(iCell, jCell) ? 0L : (long)Math.min(vars.size(), this.maxCoverage));
    }

    @Override
    public void model() {
        int nRadars = this.radars.length;
        int nSectors = Sector.values().length;
        IVar.Var[][] x = this.array("x", this.size(nRadars, nSectors), this.dom(this.range(this.maxCoverage + 1)), "x[i][j] is the power of the ith radar in the jth sector", new Types.TypeClass[0]);
        this.forall(this.range(this.mapSize).range(this.mapSize), (int i, int j) -> this.dealWithCell(x, i, j, this.maxCoverage));
    }

    static enum Sector {
        NEAST,
        EAST,
        SEAST,
        SWEST,
        WEST,
        NWEST;


        int rowOfNextRightCell(int iCell) {
            return iCell + (this == NEAST || this == NWEST ? -1 : (this == EAST || this == WEST ? 0 : 1));
        }

        int rowOfNextLeftCell(int iCell) {
            return iCell + (this == NEAST || this == EAST ? -1 : (this == SEAST || this == NWEST ? 0 : 1));
        }

        int colOfNextRightCell(int iCell, int jCell) {
            boolean oddRow;
            boolean bl = oddRow = iCell % 2 == 1;
            return jCell + (this == EAST ? 1 : (this == WEST ? -1 : (this == NEAST || this == SEAST ? (oddRow ? 0 : 1) : -(oddRow ? 1 : 0))));
        }

        int colOfNextLeftCell(int iCell, int jCell) {
            boolean oddRow;
            boolean bl = oddRow = iCell % 2 == 1;
            return jCell + (this == SEAST ? 1 : (this == NWEST ? -1 : (this == EAST || this == SWEST ? (oddRow ? 0 : 1) : -(oddRow ? 1 : 0))));
        }
    }
}

