/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.structures.Table;
import org.xcsp.modeler.api.ProblemAPI;

public class Rack2
implements ProblemAPI {
    int nRacks;
    RackModel[] rackModels;
    CardType[] cardTypes;

    @Override
    public void model() {
        this.rackModels = this.addObject(this.rackModels, new RackModel(), 0);
        int nModels = this.rackModels.length;
        int nTypes = this.cardTypes.length;
        int[] powers = this.valuesFrom(this.rackModels, (T rackModel) -> rackModel.power);
        int[] sizes = this.valuesFrom(this.rackModels, (T rackModel) -> rackModel.nConnectors);
        int[] costs = this.valuesFrom(this.rackModels, (T rackModel) -> rackModel.price);
        int[] cardPowers = this.valuesFrom(this.cardTypes, (T cardType) -> cardType.power);
        int maxCapacity = this.maxOf(sizes);
        Table table = this.table().addFrom(this.range(nModels), i -> this.tuple((int)i, powers[i], sizes[i], costs[i]));
        IVar.Var[] m = this.array("m", this.size(this.nRacks), this.dom(this.range(nModels)), "m[i] is the model used for the ith rack", new Types.TypeClass[0]);
        IVar.Var[][] nc = this.array("nc", this.size(this.nRacks, nTypes), (int i, int j) -> this.dom(this.range(Math.min(maxCapacity, this.cardTypes[j].demand) + 1)), "nc[i][j] is the number of cards of type j put in the ith rack", new Types.TypeClass[0]);
        IVar.Var[] p = this.array("p", this.size(this.nRacks), this.dom(powers), "p[i] is the power of the ith rack", new Types.TypeClass[0]);
        IVar.Var[] s = this.array("s", this.size(this.nRacks), this.dom(sizes), "s[i] is the size of the ith rack", new Types.TypeClass[0]);
        IVar[] c = this.array("c", this.size(this.nRacks), this.dom(costs), "c[i] is the cost of the ith rack", new Types.TypeClass[0]);
        this.forall(this.range(this.nRacks), arg_0 -> this.lambda$model$6(m, p, s, (IVar.Var[])c, table, arg_0)).note("linking model with power, size and cost of the ith rack");
        this.forall(this.range(this.nRacks), (int i) -> this.sum(nc[i], LE, s[i])).note("connector-capacity constraints");
        this.forall(this.range(this.nRacks), (int i) -> this.sum(nc[i], this.weightedBy(cardPowers), LE, p[i])).note("power-capacity constraints");
        this.forall(this.range(nTypes), (int i) -> this.sum(this.columnOf(nc, i), EQ, (long)this.cardTypes[i].demand)).note("demand constraints");
        this.block(() -> {
            this.decreasing(m);
            this.disjunction(this.ne(m[0], m[1]), this.ge(nc[0][0], nc[1][0]));
        }).tag(SYMMETRY_BREAKING);
        this.minimize(SUM, c).note("minimizing the total cost paid for all racks");
    }

    private /* synthetic */ void lambda$model$6(IVar.Var[] m, IVar.Var[] p, IVar.Var[] s, IVar.Var[] c, Table table, int i) {
        this.extension((IVar.Var[])this.vars(m[i], new IVar.Var[]{p[i], s[i], c[i]}), table);
    }

    class CardType {
        int power;
        int demand;

        CardType() {
        }
    }

    class RackModel {
        int power;
        int nConnectors;
        int price;

        RackModel() {
        }
    }
}

