/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.structures.Table;
import org.xcsp.modeler.api.ProblemAPI;

public class QuadraticAssignment
implements ProblemAPI {
    int[][] weights;
    int[][] distances;

    private Table channelingTable() {
        Table table = this.table();
        for (int i = 0; i < this.distances.length; ++i) {
            for (int j = 0; j < this.distances.length; ++j) {
                if (i == j) continue;
                table.add(i, j, this.distances[i][j]);
            }
        }
        return table;
    }

    @Override
    public void model() {
        int n = this.weights.length;
        IVar.Var[] x = this.array("x", this.size(n), this.dom(this.range(n)), "x[i] is the location assigned to the ith facility", new Types.TypeClass[0]);
        IVar[][] d = this.array("d", this.size(n, n), (int i, int j) -> this.dom(this.distances).when(i < j && this.weights[i][j] != 0), "d[i][j] is the distance between the locations assigned to the ith and jth facilities", new Types.TypeClass[0]);
        this.allDifferent(x).note("all locations must be different");
        Table table = this.channelingTable();
        this.forall(this.range(n).range(n), (arg_0, arg_1) -> this.lambda$model$1(x, (IVar.Var[][])d, table, arg_0, arg_1)).note("computing the distances");
        this.minimize(SUM, d, this.weightedBy(this.weights), (int i, int j) -> i < j && this.weights[i][j] != 0).note("minimizing summed up distances multiplied by flows");
    }

    private /* synthetic */ void lambda$model$1(IVar.Var[] x, IVar.Var[][] d, Table table, int i, int j) {
        if (i < j && this.weights[i][j] != 0) {
            this.extension((IVar.Var[])this.vars(x[i], new IVar.Var[]{x[j], d[i][j]}), table);
        }
    }
}

