/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.predicates.XNode;
import org.xcsp.modeler.api.ProblemAPI;

public class PizzaVoucher
implements ProblemAPI {
    int[] pizzaPrices;
    Voucher[] vouchers;

    @Override
    public void model() {
        int nPizzas = this.pizzaPrices.length;
        int nVouchers = this.vouchers.length;
        IVar[] v = this.array("v", this.size(nPizzas), this.dom(this.rangeClosed(-nVouchers, nVouchers)), "v[i] is the voucher used for the ith pizza. 0 means that no voucher is used. A negative (resp., positive) value i means that the ith pizza contributes to the the pay (resp., free) part of voucher |i|.", new Types.TypeClass[0]);
        IVar.Var[] p = this.array("p", this.size(nVouchers), (int i) -> this.dom(0, this.vouchers[i].payPart), "p[i] is the number of paid pizzas wrt the ith voucher", new Types.TypeClass[0]);
        IVar.Var[] f = this.array("f", this.size(nVouchers), (int i) -> this.dom(this.range(this.vouchers[i].freePart + 1)), "f[i] is the number of free pizzas wrt the ith voucher", new Types.TypeClass[0]);
        this.forall(this.range(nVouchers), arg_0 -> this.lambda$model$2((IVar.Var[])v, p, arg_0)).note("counting paid pizzas");
        this.forall(this.range(nVouchers), arg_0 -> this.lambda$model$3((IVar.Var[])v, f, arg_0)).note("counting free pizzas");
        this.forall(this.range(nVouchers), (int i) -> this.equivalence(this.eq(f[i], 0), this.ne(p[i], this.vouchers[i].payPart))).note("a voucher, if used, must contribute to have at least one free pizza.");
        this.forall(this.range(nPizzas).range(nPizzas), (arg_0, arg_1) -> this.lambda$model$5((IVar.Var[])v, arg_0, arg_1)).note("a free pizza obtained with a voucher must be cheaper than any pizza paid wrt this voucher");
        this.minimize(SUM, this.treesFrom(this.range(nPizzas), arg_0 -> this.lambda$model$6((IVar.Var[])v, arg_0)), this.pizzaPrices).note("minimizing summed up costs of pizzas");
        this.decisionVariables(v);
    }

    private /* synthetic */ XNode lambda$model$6(IVar.Var[] v, Integer i) {
        return this.le(v[i], 0);
    }

    private /* synthetic */ void lambda$model$5(IVar.Var[] v, int i, int j) {
        if (i != j && this.pizzaPrices[i] < this.pizzaPrices[j]) {
            this.disjunction(this.ge(v[i], v[j]), this.ne(v[i], this.neg(v[j])));
        }
    }

    private /* synthetic */ void lambda$model$3(IVar.Var[] v, IVar.Var[] f, int i) {
        this.count(v, this.takingValue(i + 1), EQ, f[i]);
    }

    private /* synthetic */ void lambda$model$2(IVar.Var[] v, IVar.Var[] p, int i) {
        this.count(v, this.takingValue(-i - 1), EQ, p[i]);
    }

    class Voucher {
        int payPart;
        int freePart;

        Voucher() {
        }
    }
}

