/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import org.xcsp.common.IVar;
import org.xcsp.common.Range;
import org.xcsp.common.Types;
import org.xcsp.common.structures.Automaton;
import org.xcsp.common.structures.Table;
import org.xcsp.common.structures.Transitions;
import org.xcsp.modeler.api.ProblemAPI;

public class NurseRostering
implements ProblemAPI {
    int nDays;
    Shift[] shifts;
    Staff[] staffs;
    Cover[][] covers;

    private Request onRequest(int person, int day) {
        return this.firstFrom(this.staffs[person].onRequests, (T request) -> request.day == day);
    }

    private Request offRequest(int person, int day) {
        return this.firstFrom(this.staffs[person].offRequests, (T request) -> request.day == day);
    }

    private int shiftPos(String s) {
        return this.firstFrom(this.range(this.shifts.length), (int i) -> this.shifts[i].id.equals(s));
    }

    private int[] costsFor(int day, int shift) {
        int[] t = new int[this.staffs.length + 1];
        if (shift != this.shifts.length - 1) {
            for (int i = 0; i < t.length; ++i) {
                t[i] = this.covers[day][shift].costFor(i);
            }
        }
        return t;
    }

    private Automaton automatonMinConsecutive(int nShifts, int k, boolean forShifts) {
        Range rangeOff = this.range(nShifts - 1, nShifts);
        Range rangeNotOff = this.range(nShifts - 1);
        Range r1 = forShifts ? rangeOff : rangeNotOff;
        Range r2 = forShifts ? rangeNotOff : rangeOff;
        Transitions transitions = this.transitions();
        transitions.add("q0", r1, "q1").add("q0", r2, "q" + (k + 1)).add("q1", r1, "q" + (k + 1));
        for (int i = 1; i <= k; ++i) {
            transitions.add("q" + i, r2, "q" + (i + 1));
        }
        transitions.add("q" + (k + 1), this.range(nShifts), "q" + (k + 1));
        return this.automaton("q0", transitions, this.finalState("q" + (k + 1)));
    }

    private Table rotation() {
        Table table = this.table(NEGATIVE);
        for (Shift s1 : this.shifts) {
            if (s1.forbiddenFollowingShifts == null) continue;
            for (String s2 : s1.forbiddenFollowingShifts) {
                table.add(this.shiftPos(s1.id), this.shiftPos(s2));
            }
        }
        return table;
    }

    private void buildDummyShift() {
        this.shifts = this.addObject(this.shifts, new Shift());
        for (Staff staff : this.staffs) {
            staff.maxShifts = this.addInt(staff.maxShifts, this.nDays);
        }
    }

    @Override
    public void model() {
        this.buildDummyShift();
        int nWeeks = this.nDays / 7;
        int nShifts = this.shifts.length;
        int nStaffs = this.staffs.length;
        int off = nShifts - 1;
        IVar.Var[][] x = this.array("x", this.size(this.nDays, nStaffs), this.dom(this.range(nShifts)), "x[d][p] is the shift at day d for person p (value " + off + " denotes off)", new Types.TypeClass[0]);
        IVar.Var[][] nd = this.array("nd", this.size(nStaffs, nShifts), (int p, int s) -> this.dom(this.range(this.staffs[p].maxShifts[s] + 1)), "nd[p][s] is the number of days such that person p works with shift s", new Types.TypeClass[0]);
        IVar.Var[][] np = this.array("np", this.size(this.nDays, nShifts), this.dom(this.range(nStaffs + 1)), "np[d][s] is the number of persons working on day d with shift s", new Types.TypeClass[0]);
        IVar.Var[][] wk = this.array("wk", this.size(nStaffs, nWeeks), this.dom(0, 1), "wk[p][w] is 1 iff the week-end w is worked by person p", new Types.TypeClass[0]);
        IVar.Var[][] cn = this.array("cn", this.size(nStaffs, this.nDays), (int p, int d) -> this.onRequest(p, d) != null ? this.dom(0, this.onRequest((int)p, (int)d).weight) : null, "cn[p][d] is the cost of not satisfying the on-request (if it exists) of person p on day d", new Types.TypeClass[0]);
        IVar.Var[][] cf = this.array("cf", this.size(nStaffs, this.nDays), (int p, int d) -> this.offRequest(p, d) != null ? this.dom(0, this.offRequest((int)p, (int)d).weight) : null, "cf[p][d] is the cost of not satisfying the off-request (if it exists) of person p on day d", new Types.TypeClass[0]);
        IVar.Var[][] cc = this.array("cc", this.size(this.nDays, nShifts), (int d, int s) -> this.dom(this.costsFor(d, s)), "cc[d][s] is the cost of not satisfying cover for shift s on day d", new Types.TypeClass[0]);
        this.instantiation(this.select(x, (int d, int p) -> this.contains(this.staffs[p].daysOff, d)), this.takingValue(off)).note("days off for staff");
        this.forall(this.range(nStaffs).range(nShifts), (int p, int s) -> this.exactly(this.columnOf(x, p), this.takingValue(s), nd[p][s])).note("computing number of days");
        this.forall(this.range(this.nDays).range(nShifts), (int d, int s) -> this.exactly(x[d], this.takingValue(s), np[d][s])).note("computing number of persons");
        this.forall(this.range(nStaffs).range(nWeeks), (int p, int w) -> {
            this.implication(this.ne(x[w * 7 + 5][p], off), wk[p][w]);
            this.implication(this.ne(x[w * 7 + 6][p], off), wk[p][w]);
        }).note("computing worked week-ends");
        Table table = this.rotation();
        if (table.size() > 0) {
            this.forall(this.range(nStaffs), (int p) -> this.slide(this.columnOf(x, p), this.range(this.nDays - 1), i -> this.extension((IVar.Var[])this.vars(x[i][p], x[i + 1][p]), table))).note("rotation shifts");
        }
        this.forall(this.range(nStaffs), (int p) -> this.sum(wk[p], LE, (long)this.staffs[p].maxWeekends)).note("maximum number of worked week-ends");
        int[] lengths = this.valuesFrom(this.shifts, (T sh) -> sh.length);
        this.forall(this.range(nStaffs), (int p) -> this.sum(nd[p], this.weightedBy(lengths), IN, this.rangeClosed(this.staffs[p].minTotalMinutes, this.staffs[p].maxTotalMinutes))).note("minimum and maximum number of total worked minutes");
        this.forall(this.range(nStaffs), (int p) -> {
            int k = this.staffs[p].maxConsecutiveShifts;
            this.forall(this.range(this.nDays - k), (int i) -> this.atLeast1(this.select(this.columnOf(x, p), this.range(i, i + k + 1)), this.takingValue(off)));
        }).note("maximum consecutive worked shifts");
        this.forall(this.range(nStaffs), (int p) -> {
            int k = this.staffs[p].minConsecutiveShifts;
            this.forall(this.range(this.nDays - k), (int i) -> this.regular(this.select(this.columnOf(x, p), this.range(i, i + k + 1)), this.automatonMinConsecutive(nShifts, k, true)));
        }).note("minimum consecutive worked shifts");
        this.forall(this.range(nStaffs), (int p) -> {
            int k = this.staffs[p].minConsecutiveShifts;
            if (k > 1) {
                this.forall(this.range(1, k), (int i) -> this.implication(this.ne(x[0][p], off), this.ne(x[i][p], off)));
                this.forall(this.range(1, k), (int i) -> this.implication(this.ne(x[this.nDays - 1][p], off), this.ne(x[this.nDays - 1 - i][p], off)));
            }
        }).note("managing off days on schedule ends");
        this.forall(this.range(nStaffs), (int p) -> {
            int k = this.staffs[p].minConsecutiveDaysOff;
            this.forall(this.range(this.nDays - k), (int i) -> this.regular(this.select(this.columnOf(x, p), this.range(i, i + k + 1)), this.automatonMinConsecutive(nShifts, k, false)));
        }).note("minimum consecutive days off");
        this.forall(this.range(nStaffs).range(this.nDays), (int p, int d) -> {
            if (this.onRequest(p, d) != null) {
                this.equivalence(this.eq(x[d][p], this.shiftPos(this.onRequest((int)p, (int)d).shift)), this.eq(cn[p][d], 0));
            }
        }).note("cost of not satisfying on requests");
        this.forall(this.range(nStaffs).range(this.nDays), (int p, int d) -> {
            if (this.offRequest(p, d) != null) {
                this.equivalence(this.eq(x[d][p], this.shiftPos(this.offRequest((int)p, (int)d).shift)), this.ne(cf[p][d], 0));
            }
        }).note("cost of not satisfying off requests");
        this.forall(this.range(this.nDays).range(nShifts), (int d, int s) -> this.extension((IVar.Var[])this.vars(np[d][s], cc[d][s]), this.indexing(this.costsFor(d, s)))).note("cost of under or over covering");
        IVar[] vars = (IVar.Var[])this.vars(cn, new Object[]{cf, cc});
        this.minimize(SUM, vars);
    }

    class Cover {
        int requirement;
        int weightIfUnder;
        int weightIfOver;

        Cover() {
        }

        int costFor(int i) {
            return i <= this.requirement ? (this.requirement - i) * this.weightIfUnder : (i - this.requirement) * this.weightIfOver;
        }
    }

    class Staff {
        String id;
        int[] maxShifts;
        int minTotalMinutes;
        int maxTotalMinutes;
        int minConsecutiveShifts;
        int maxConsecutiveShifts;
        int minConsecutiveDaysOff;
        int maxWeekends;
        int[] daysOff;
        Request[] onRequests;
        Request[] offRequests;

        Staff() {
        }
    }

    class Request {
        int day;
        String shift;
        int weight;

        Request() {
        }
    }

    class Shift {
        String id = "_off";
        int length;
        String[] forbiddenFollowingShifts;

        Shift() {
        }
    }
}

