/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.structures.Table;
import org.xcsp.modeler.api.ProblemAPI;

public class MisteryShopper
implements ProblemAPI {
    int[] visitorGroups;
    int[] visiteeGroups;

    private Table numberPeople(int[] t) {
        Table table = this.table();
        int cnt = 0;
        for (int i = 0; i < t.length; ++i) {
            for (int j = 0; j < t[i]; ++j) {
                table.add(new int[][]{this.tuple(i, cnt++)});
            }
        }
        return table;
    }

    @Override
    public void model() {
        int nVisitees;
        int nVisitors = this.sumOf(this.visitorGroups);
        Utilities.control(nVisitors >= (nVisitees = this.sumOf(this.visiteeGroups)), "The number of visitors must be greater than the number of visitees");
        int n = nVisitors;
        int nDummyVisitees = nVisitors - nVisitees;
        if (nDummyVisitees > 0) {
            this.visiteeGroups = this.addInt(this.visiteeGroups, nDummyVisitees);
        }
        int nWeeks = this.visitorGroups.length;
        int nVisitorGroups = this.visitorGroups.length;
        int nVisiteegroups = this.visiteeGroups.length;
        IVar.Var[][] vr = this.array("vr", this.size(n, nWeeks), this.dom(this.range(n)), "vr[i][w] is the visitor for the ith visitee at week w", new Types.TypeClass[0]);
        IVar.Var[][] ve = this.array("ve", this.size(n, nWeeks), this.dom(this.range(n)), "ve[i][w] is the visitee for the ith visitor at week w", new Types.TypeClass[0]);
        IVar.Var[][] gr = this.array("gr", this.size(n, nWeeks), this.dom(this.range(nVisitorGroups)), "gr[i][w] is the visitor group for the ith visitee at week w", new Types.TypeClass[0]);
        IVar.Var[][] ge = this.array("ge", this.size(n, nWeeks), this.dom(this.range(nVisiteegroups)), "ge[i][w] is the visitee group for the ith visitor at week w", new Types.TypeClass[0]);
        this.forall(this.range(nWeeks), (int w) -> this.allDifferent(this.columnOf(vr, w))).note("each week, all visitors must be different");
        this.forall(this.range(nWeeks), (int w) -> this.allDifferent(this.columnOf(ve, w))).note("each week, all visitees must be different");
        this.forall(this.range(n), (int i) -> this.allDifferent(gr[i])).note("the visitor groups must be different for each visitee");
        this.forall(this.range(n), (int i) -> this.allDifferent(ge[i])).note("the visitee groups must be different for each visitor");
        this.forall(this.range(nWeeks), (int w) -> this.channel(this.columnOf(vr, w), this.columnOf(ve, w))).note("channeling arrays vr and ve, each week");
        this.block(() -> {
            this.lexMatrix(vr, INCREASING);
            if (nDummyVisitees > 0) {
                this.forall(this.range(nWeeks), (int w) -> this.strictlyIncreasing(this.select(this.columnOf(vr, w), this.range(nVisitees, n))));
            }
        }).tag(SYMMETRY_BREAKING);
        Table tableForVisitors = this.numberPeople(this.visitorGroups);
        Table tableForVisitees = this.numberPeople(this.visiteeGroups);
        this.forall(this.range(n).range(nWeeks), (int i, int w) -> this.extension((IVar.Var[])this.vars(gr[i][w], vr[i][w]), tableForVisitors)).note("linking a visitor with its group");
        this.forall(this.range(n).range(nWeeks), (int i, int w) -> this.extension((IVar.Var[])this.vars(ge[i][w], ve[i][w]), tableForVisitees)).note("linking a visitee with its group");
    }
}

