/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.structures.Table;
import org.xcsp.modeler.api.ProblemAPI;

public class League
implements ProblemAPI {
    int leagueSize;
    Player[] players;

    @Override
    public void model() {
        int nPlayers = this.players.length;
        int nLeagues = nPlayers / this.leagueSize + (nPlayers % this.leagueSize != 0 ? 1 : 0);
        int nFullLeagues = nPlayers % this.leagueSize == 0 ? nLeagues : nLeagues - (this.leagueSize - nPlayers % this.leagueSize);
        int[] playerRankings = Stream.of(this.players).mapToInt(p -> p.ranking).toArray();
        int[] playerCountries = Stream.of(this.players).mapToInt(p -> p.country).toArray();
        int[] allRankings = this.singleValuesIn(new Object[]{playerRankings});
        int[] allCountries = this.singleValuesIn(new Object[]{playerCountries});
        IVar.Var[][] p2 = this.array("p", this.size(nLeagues, this.leagueSize), (int i, int j) -> i < nFullLeagues || j < this.leagueSize - 1 ? this.dom(this.range(nPlayers)) : null, "p[i][j] is the jth player of the ith league", new Types.TypeClass[0]);
        IVar.Var[][] r = this.array("r", this.size(nLeagues, this.leagueSize), (int i, int j) -> i < nFullLeagues || j < this.leagueSize - 1 ? this.dom(playerRankings) : null, "r[i][j] is the ranking of the jth player of the ith league", new Types.TypeClass[0]);
        IVar.Var[] l = this.array("l", this.size(nLeagues), (int i) -> this.dom(playerRankings), "l[i] is the lowest ranking of a player of the ith league", new Types.TypeClass[0]);
        IVar.Var[] h = this.array("h", this.size(nLeagues), (int i) -> this.dom(playerRankings), "h[i] is the highest ranking of a player of the ith league", new Types.TypeClass[0]);
        IVar.Var[] d = this.array("d", this.size(nLeagues), (int i) -> this.dom(0, allRankings), "d[i] is the difference between the highest and lowest rankings of players of the ith league", new Types.TypeClass[0]);
        IVar[] nc = this.array("nc", this.size(nLeagues), (int i) -> this.dom(this.range(1 + Math.min(allCountries.length, i < nFullLeagues ? this.leagueSize : this.leagueSize - 1))), "nc[i] is the number of countries for players of the ith league", new Types.TypeClass[0]);
        this.allDifferent(p2);
        this.forall(this.range(nLeagues), (int i) -> this.minimum(r[i], l[i]));
        this.forall(this.range(nLeagues), (int i) -> this.maximum(r[i], h[i]));
        this.forall(this.range(nLeagues), (int i) -> this.equal(d[i], this.sub(h[i], l[i])));
        if (this.modelVariant("")) {
            IVar.Var[][] c = this.array("c", this.size(nLeagues, this.leagueSize), (int i, int j) -> i < nFullLeagues || j < this.leagueSize - 1 ? this.dom(playerCountries) : null, "c[i][j] is the country of the jth player of the ith league", new Types.TypeClass[0]);
            Table table = this.table().addFrom(this.range(nPlayers), i -> this.tuple((int)i, playerRankings[i], playerCountries[i]));
            this.forall(this.range(nLeagues).range(this.leagueSize), (int i, int j) -> {
                if (i < nFullLeagues || j < this.leagueSize - 1) {
                    this.extension((IVar.Var[])this.vars(p2[i][j], new IVar.Var[]{r[i][j], c[i][j]}), table);
                }
            });
            this.forall(this.range(nLeagues), arg_0 -> this.lambda$model$14(c, (IVar.Var[])nc, arg_0));
        }
        this.minimize(SUM, this.vars(d, nc), this.vals(this.repeat(100, nLeagues), this.repeat(-1, nLeagues)));
    }

    private /* synthetic */ void lambda$model$14(IVar.Var[][] c, IVar.Var[] nc, int i) {
        this.nValues(c[i], EQ, nc[i]);
    }

    class Player {
        int ranking;
        int country;

        Player() {
        }
    }
}

