/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.IntStream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.modeler.api.ProblemAPI;
import org.xcsp.modeler.entities.CtrEntities;
import org.xcsp.modeler.implementation.NotData;

public class Fapp
implements ProblemAPI {
    int[][] domains;
    Route[] routes;
    HardCtr[] hards;
    SoftCtr[] softs;
    @NotData
    Map<String, int[][]> cacheForTables = new HashMap<String, int[][]>();

    private CtrEntities.CtrEntity imperativeConstraint(IVar.Var[] f, IVar.Var[] p, HardCtr c) {
        int i = c.route1;
        int j = c.route2;
        if (c.frequency) {
            if (c.gap == 0) {
                return c.equality ? this.equal(f[i], f[j]) : this.different(f[i], f[j]);
            }
            return c.equality ? this.equal(this.dist(f[i], f[j]), c.gap) : this.different(this.dist(f[i], f[j]), c.gap);
        }
        return c.equality ? this.equal(p[i], p[j]) : this.different(p[i], p[j]);
    }

    private int[][] tableForRelaxableRadioelectricCtr(SoftCtr c, boolean shortVersion) {
        int i = c.route1;
        int j = c.route2;
        String key = this.routes[i].domain + "*" + this.routes[j].domain + "*" + this.routes[i].polarization + "*" + this.routes[j].polarization + "*" + Utilities.join(c.eqRelaxations) + "*" + Utilities.join(c.neRelaxations);
        if (this.cacheForTables.containsKey(key)) {
            return this.cacheForTables.get(key);
        }
        HashSet<Integer> setForShortVersion = new HashSet<Integer>();
        TreeSet<int[]> table = new TreeSet<int[]>(Utilities.lexComparatorInt);
        for (int fi : this.domains[this.routes[i].domain]) {
            for (int fj : this.domains[this.routes[j].domain]) {
                int dist = Math.abs(fi - fj);
                if (shortVersion && setForShortVersion.contains(dist)) continue;
                for (int pol = 0; pol < 4; ++pol) {
                    int pj;
                    int pi = pol < 2 ? 0 : 1;
                    int n = pj = pol == 1 || pol == 3 ? 1 : 0;
                    if (this.routes[i].polarization == 1 && pi == 0 || this.routes[j].polarization == 1 && pj == 0 || this.routes[i].polarization == -1 && pi == true || this.routes[j].polarization == -1 && pj == 1) continue;
                    int[] t = pi == pj ? c.eqRelaxations : c.neRelaxations;
                    for (int k = 0; k <= 11; ++k) {
                        if (k != 11 && dist < t[k]) continue;
                        int sum = IntStream.range(0, k - 1).map(l -> dist >= t[l] ? 0 : 1).sum();
                        if (shortVersion) {
                            table.add(this.tuple(dist, pi, pj, k, k == 0 || dist >= t[k - 1] ? 0 : 1, k <= 1 ? 0 : sum));
                            continue;
                        }
                        table.add(this.tuple(fi, fj, pi, pj, k, k == 0 || dist >= t[k - 1] ? 0 : 1, k <= 1 ? 0 : sum));
                    }
                }
                setForShortVersion.add(dist);
            }
        }
        int[][] t = (int[][])table.toArray((T[])new int[0][]);
        this.cacheForTables.put(key, t);
        return t;
    }

    private int[] distances(int i, int j) {
        int[] dom1 = this.domains[this.routes[i].domain];
        int[] dom2 = this.domains[this.routes[j].domain];
        return IntStream.of(dom1).flatMap(f1 -> IntStream.of(dom2).map(f2 -> Math.abs(f1 - f2))).toArray();
    }

    private boolean[][] buildSoftLinks() {
        boolean[][] softLinks = new boolean[this.routes.length][this.routes.length];
        for (SoftCtr c : this.softs) {
            int i = c.route1;
            int j = c.route2;
            softLinks[i][j] = true;
            softLinks[j][i] = true;
        }
        return softLinks;
    }

    @Override
    public void model() {
        boolean[][] softLinks = this.buildSoftLinks();
        int n = this.routes.length;
        int nHards = this.hards == null ? 0 : this.hards.length;
        int nSofts = this.softs.length;
        IVar.Var[] f = this.array("f", this.size(n), (int i) -> this.dom(this.domains[this.routes[i].domain]), "f[i] is the frequency of the ith radio-link", new Types.TypeClass[0]);
        IVar.Var[] p = this.array("p", this.size(n), (int i) -> this.dom(this.routes[i].polarizationValues()), "p[i] is the polarization of the ith radio-link", new Types.TypeClass[0]);
        IVar.Var k = this.var("k", this.dom(this.range(12)), "k is the relaxation level to be optimized", new Types.TypeClass[0]);
        IVar.Var[] v1 = this.array("v1", this.size(nSofts), this.dom(0, 1), "v1[q] is 1 iff the qth pair of radio-electric compatibility constraints is violated when relaxing another level", new Types.TypeClass[0]);
        IVar.Var[] v2 = this.array("v2", this.size(nSofts), this.dom(this.range(11)), "v2[q] is the number of times the qth pair of radio-electric compatibility constraints is violated when relaxing more than one level", new Types.TypeClass[0]);
        this.forall(this.range(nHards), (int q) -> this.imperativeConstraint(f, p, this.hards[q])).note("imperative constraints");
        if (this.modelVariant("")) {
            this.forall(this.range(nSofts), (int q) -> {
                int i = this.softs[q].route1;
                int j = this.softs[q].route2;
                this.extension((IVar.Var[])this.vars(f[i], new IVar.Var[]{f[j], p[i], p[j], k, v1[q], v2[q]}), this.tableForRelaxableRadioelectricCtr(this.softs[q], false));
            }).note("soft radio-electric compatibility constraints");
        }
        if (this.modelVariant("short")) {
            IVar.Var[][] d = this.array("d", this.size(n, n), (int i, int j) -> this.dom(this.distances(i, j)).when(i < j && softLinks[i][j]), "d[i][j] is the distance between the ith and the jth frequencies (for i < j when a soft link exists)", new Types.TypeClass[0]);
            this.forall(this.range(n).range(n), (int i, int j) -> {
                if (i < j && softLinks[i][j]) {
                    this.intension(this.eq(d[i][j], this.dist(f[i], f[j])));
                }
            }).note("computing intermediary distances");
            this.forall(this.range(nSofts), (int q) -> {
                int i = this.softs[q].route1;
                int j = this.softs[q].route2;
                this.extension((IVar.Var[])this.vars(i < j ? d[i][j] : d[j][i], new IVar.Var[]{p[i], p[j], k, v1[q], v2[q]}), this.tableForRelaxableRadioelectricCtr(this.softs[q], true));
            }).note("soft radio-electric compatibility constraints");
        }
        if (this.modelVariant("ext")) {
            int[] t = IntStream.range(0, n).flatMap(i -> IntStream.range(0, n).filter(j -> i < j && softLinks[i][j]).map(j -> i * n + j)).toArray();
            IVar.Var[] d = this.array("d", this.size(t.length), (int ind) -> this.dom(this.distances(t[ind] / n, t[ind] % n)), "d[i] is the distance between the ith pair of linked frequencies", new Types.TypeClass[0]);
            this.forall(this.range(t.length), (int ind) -> this.extension(this.eq(d[ind], this.dist(f[t[ind] / n], f[t[ind] % n])))).note("computing intermediary distances");
            this.forall(this.range(nSofts), (int q) -> {
                int i = this.softs[q].route1;
                int j = this.softs[q].route2;
                int ij = i < j ? i * n + j : j * n + i;
                int pos = Utilities.indexOf(ij, t);
                this.extension((IVar.Var[])this.vars(d[pos], new IVar.Var[]{p[i], p[j], k, v1[q], v2[q]}), this.tableForRelaxableRadioelectricCtr(this.softs[q], true));
            }).note("soft radio-electric compatibility constraints");
        }
        IVar[] vars = (IVar.Var[])this.vars(k, new Object[]{v1, v2});
        this.minimize(SUM, vars, this.weightedBy(this.vals(10 * nSofts * nSofts, this.repeat(10 * nSofts, nSofts), this.repeat(1, nSofts))));
    }

    class SoftCtr {
        int route1;
        int route2;
        int[] eqRelaxations;
        int[] neRelaxations;

        SoftCtr() {
        }
    }

    class HardCtr {
        int route1;
        int route2;
        boolean frequency;
        boolean equality;
        int gap;

        HardCtr() {
        }
    }

    class Route {
        int domain;
        int polarization;

        Route() {
        }

        int[] polarizationValues() {
            return this.polarization == 0 ? Fapp.this.vals(0, 1) : (this.polarization == 1 ? Fapp.this.vals(1) : Fapp.this.vals(0));
        }
    }
}

