/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import constraints.hard.extension.CtrExtensionSegmented;
import constraints.hard.extension.structures.SegmentedTuple;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.enumerations.EnumerationCartesian;
import org.xcsp.modeler.api.ProblemAPI;
import org.xcsp.modeler.implementation.NotData;
import problem.Problem;
import utility.Kit;
import variables.Variable;

public class CrosswordDesignSeg2
implements ProblemAPI {
    private static final int N_LETTERS = 26;
    int n;
    int nMaxWords;
    int wordSizeLimit;
    String mainDict;
    String thematicDict;
    @NotData
    int[][][] mainWords;
    @NotData
    int[][][] thematicWords;

    private static Stream<String> oneLetterWords() {
        return IntStream.range(0, 26).mapToObj(i -> (char)(i + 97) + "");
    }

    private static Stream<String> twoLetterWords() {
        return IntStream.range(0, 26).mapToObj(i -> IntStream.range(0, 26).mapToObj(j -> (char)(i + 97) + "" + (char)(j + 97))).flatMap(s -> s);
    }

    private void loadWords() {
        String[] mw = (String[])Stream.concat(Stream.concat(CrosswordDesignSeg2.oneLetterWords(), CrosswordDesignSeg2.twoLetterWords()), this.readFileLines(this.mainDict)).filter(w -> w.length() <= (this.wordSizeLimit == -1 ? this.n : this.wordSizeLimit)).distinct().sorted().toArray(String[]::new);
        String[] tw = (String[])this.readFileLines(this.thematicDict).filter(w -> w.length() <= (this.wordSizeLimit == -1 ? this.n : this.wordSizeLimit)).distinct().sorted().toArray(String[]::new);
        this.mainWords = (int[][][])IntStream.range(0, this.n + 1).mapToObj(l -> (int[][])IntStream.range(0, mw.length).filter(i -> mw[i].length() == l).mapToObj(i -> IntStream.range(0, l).map(j -> mw[i].charAt(j) - 97).toArray()).toArray(x$0 -> new int[x$0][])).toArray(x$0 -> new int[x$0][][]);
        Kit.control(IntStream.range(1, this.n + 1).allMatch(l -> this.mainWords[l].length > 0));
        this.thematicWords = (int[][][])IntStream.range(0, this.n + 1).mapToObj(l -> (int[][])IntStream.range(0, tw.length).filter(i -> tw[i].length() == l).mapToObj(i -> IntStream.range(0, l).map(j -> tw[i].charAt(j) - 97).toArray()).toArray(x$0 -> new int[x$0][])).toArray(x$0 -> new int[x$0][][]);
    }

    private void buildSegmentDatas(Stack<WordPattern> stack, List<SegmentData> list) {
        block5: {
            int i;
            block6: {
                int[][] dictSelections;
                block4: {
                    if (stack.size() != 0) break block4;
                    for (int i2 = 0; i2 <= 1; ++i2) {
                        for (int l = 1; l <= this.n - i2; ++l) {
                            stack.push(new WordPattern(i2, l));
                            this.buildSegmentDatas(stack, list);
                            stack.pop();
                        }
                    }
                    break block5;
                }
                WordPattern last = stack.peek();
                i = last.nextStart();
                if (i != this.n && i != this.n + 1) break block6;
                if (stack.size() > this.nMaxWords) break block5;
                WordPattern[] t = stack.toArray(new WordPattern[0]);
                for (int[] dictSelection : dictSelections = new EnumerationCartesian(Stream.of(t).mapToInt(wp -> this.thematicWords[wp.length].length > 0 ? 2 : 1).toArray()).toArray()) {
                    int score = IntStream.range(0, dictSelection.length).map(j -> dictSelection[j] == 0 ? 0 : t[j].length).sum();
                    int[][][] subtables = (int[][][])IntStream.range(0, dictSelection.length).mapToObj(j -> dictSelection[j] == 0 ? this.mainWords[t[j].length] : this.thematicWords[t[j].length]).toArray(x$0 -> new int[x$0][][]);
                    list.add(new SegmentData(t, score, subtables));
                }
                break block5;
            }
            for (int l = 1; l <= this.n - i; ++l) {
                stack.push(new WordPattern(i, l));
                this.buildSegmentDatas(stack, list);
                stack.pop();
            }
        }
    }

    SegmentData[] buildSegmentDatas() {
        ArrayList<SegmentData> list = new ArrayList<SegmentData>();
        this.buildSegmentDatas(new Stack<WordPattern>(), list);
        return (SegmentData[])list.stream().toArray(SegmentData[]::new);
    }

    SegmentedTuple[] buildSegmentedTuples(SegmentData[] segmentDatas, IVar.Var[] vars) {
        SegmentedTuple[] m = new SegmentedTuple[segmentDatas.length];
        for (int j = 0; j < m.length; ++j) {
            WordPattern[] wordPatterns = segmentDatas[j].wps;
            SegmentedTuple.RestrictionTable[] restrictions = new SegmentedTuple.RestrictionTable[wordPatterns.length];
            for (int k = 0; k < restrictions.length; ++k) {
                WordPattern wp = wordPatterns[k];
                Variable[] subscp = (Variable[])IntStream.range(0, wp.length).mapToObj(i -> vars[wp.start + i]).toArray(Variable[]::new);
                restrictions[k] = new SegmentedTuple.RestrictionTable(subscp, segmentDatas[j].subtables[k]);
            }
            m[j] = new SegmentedTuple(segmentDatas[j].prefix, restrictions);
        }
        return m;
    }

    @Override
    public void model() {
        this.loadWords();
        this.nMaxWords = this.nMaxWords == -1 ? (this.n + 1) / 2 : this.nMaxWords;
        int[] allScores = this.vals(0, this.range(3, this.n + 1));
        IVar.Var[][] x = this.array("x", this.size(this.n, this.n), this.dom(this.range(27)), "x[i][j] is the (number of) letter at row i and col j; 26 stands for a black point", new Types.TypeClass[0]);
        IVar.Var[] br = this.array("br", this.size(this.n), this.dom(allScores), "br[i] is the benefit at row i; 0 means that all words are from the full dictionary", new Types.TypeClass[0]);
        IVar[] bc = this.array("bc", this.size(this.n), this.dom(allScores), "bc[j] is the benefit at col j; 0 means that all words are from the full dictionary", new Types.TypeClass[0]);
        SegmentData[] segmentDatas = this.buildSegmentDatas();
        this.forall(this.range(this.n), (int i) -> ((Problem)this.imp()).addCtr(new CtrExtensionSegmented((Problem)this.imp(), (Variable[])this.vars(x[i], br[i]), this.buildSegmentedTuples(segmentDatas, x[i])), new Types.TypeClass[0]));
        this.forall(this.range(this.n), arg_0 -> this.lambda$model$29(x, (IVar.Var[])bc, segmentDatas, arg_0));
        this.maximize(SUM, this.vars(br, bc));
    }

    @Override
    public void prettyDisplay(String[] values) {
        IntStream.range(0, this.n).forEach(i -> System.out.println(IntStream.range(0, this.n).mapToObj(j -> {
            int s = Integer.parseInt(values[i * this.n + j]);
            return s == 26 ? "*" : "" + (char)(97 + s);
        }).collect(Collectors.joining(""))));
    }

    private /* synthetic */ void lambda$model$29(IVar.Var[][] x, IVar.Var[] bc, SegmentData[] segmentDatas, int j) {
        ((Problem)this.imp()).addCtr(new CtrExtensionSegmented((Problem)this.imp(), (Variable[])this.vars(this.columnOf(x, j), bc[j]), this.buildSegmentedTuples(segmentDatas, this.columnOf(x, j))), new Types.TypeClass[0]);
    }

    class SegmentData {
        WordPattern[] wps;
        int[] prefix;
        int[][][] subtables;

        SegmentData(WordPattern[] wps, int score, int[][][] subtables) {
            this.wps = wps;
            this.prefix = IntStream.range(0, CrosswordDesignSeg2.this.n + 1).map(i -> i == CrosswordDesignSeg2.this.n ? score : 0x7FFFFFFE).toArray();
            for (WordPattern wp : wps) {
                int i2 = wp.start - 1;
                if (i2 >= 0) {
                    this.prefix[i2] = 26;
                }
                if ((i2 = wp.start + wp.length) >= CrosswordDesignSeg2.this.n) continue;
                this.prefix[i2] = 26;
            }
            this.subtables = subtables;
        }
    }

    public static class WordPattern {
        public int start;
        public int length;

        public WordPattern(int start, int length) {
            this.start = start;
            this.length = length;
        }

        public int nextStart() {
            return this.start + this.length + 1;
        }
    }
}

