/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import constraints.hard.extension.structures.MDDCD;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.enumerations.EnumerationCartesian;
import org.xcsp.common.structures.Transitions;
import org.xcsp.modeler.api.ProblemAPI;
import org.xcsp.modeler.implementation.NotData;
import problem.Problem;
import problems.g4_world.CrosswordDesignSeg2;
import utility.Kit;

public class CrosswordDesignMdd
implements ProblemAPI {
    private static final int BLACK_CELL = 0;
    private static final int N_LETTERS = 26;
    int n;
    int nMaxWords;
    int wordSizeLimit;
    String mainDict;
    String thematicDict;
    @NotData
    int[][][] mainWords;
    @NotData
    int[][][] thematicWords;
    @NotData
    int nMerges;
    @NotData
    boolean tetestOnlyOneMdd = true;

    private static Stream<String> oneLetterWords() {
        return IntStream.range(0, 26).mapToObj(i -> (char)(i + 97) + "");
    }

    private static Stream<String> twoLetterWords() {
        return IntStream.range(0, 26).mapToObj(i -> IntStream.range(0, 26).mapToObj(j -> (char)(i + 97) + "" + (char)(j + 97))).flatMap(s -> s);
    }

    private void loadWords() {
        String[] mw = (String[])Stream.concat(Stream.concat(CrosswordDesignMdd.oneLetterWords(), CrosswordDesignMdd.twoLetterWords()), this.readFileLines(this.mainDict)).filter(w -> w.length() <= (this.wordSizeLimit == -1 ? this.n : this.wordSizeLimit)).distinct().sorted().toArray(String[]::new);
        String[] tw = (String[])this.readFileLines(this.thematicDict).filter(w -> w.length() <= (this.wordSizeLimit == -1 ? this.n : this.wordSizeLimit)).distinct().sorted().toArray(String[]::new);
        this.mainWords = (int[][][])IntStream.range(0, this.n + 1).mapToObj(l -> (int[][])IntStream.range(0, mw.length).filter(i -> mw[i].length() == l).mapToObj(i -> IntStream.range(0, l).map(j -> mw[i].charAt(j) - 97).toArray()).toArray(x$0 -> new int[x$0][])).toArray(x$0 -> new int[x$0][][]);
        Kit.control(IntStream.range(1, this.n + 1).allMatch(l -> this.mainWords[l].length > 0));
        this.thematicWords = (int[][][])IntStream.range(0, this.n + 1).mapToObj(l -> (int[][])IntStream.range(0, tw.length).filter(i -> tw[i].length() == l).mapToObj(i -> IntStream.range(0, l).map(j -> tw[i].charAt(j) - 97).toArray()).toArray(x$0 -> new int[x$0][])).toArray(x$0 -> new int[x$0][][]);
    }

    int[] buildPattern(Stack<CrosswordDesignSeg2.WordPattern> wordPatterns) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (((CrosswordDesignSeg2.WordPattern)wordPatterns.get((int)0)).start > 0) {
            list.add(0);
        }
        for (int i2 = 0; i2 < wordPatterns.size(); ++i2) {
            list.add(((CrosswordDesignSeg2.WordPattern)wordPatterns.get((int)i2)).length);
            if (i2 >= wordPatterns.size() - 1) continue;
            list.add(0);
        }
        if (((CrosswordDesignSeg2.WordPattern)wordPatterns.get(wordPatterns.size() - 1)).nextStart() <= this.n) {
            list.add(0);
        }
        return list.stream().mapToInt(i -> i).toArray();
    }

    void buildPatterns(Stack<CrosswordDesignSeg2.WordPattern> stack, List<int[]> list) {
        block4: {
            int i;
            block5: {
                block3: {
                    if (stack.size() != 0) break block3;
                    for (int i2 = 0; i2 <= 1; ++i2) {
                        for (int l = 1; l <= this.n - i2; ++l) {
                            stack.push(new CrosswordDesignSeg2.WordPattern(i2, l));
                            this.buildPatterns(stack, list);
                            stack.pop();
                        }
                    }
                    break block4;
                }
                CrosswordDesignSeg2.WordPattern last = stack.peek();
                i = last.nextStart();
                if (i != this.n && i != this.n + 1) break block5;
                if (stack.size() > this.nMaxWords) break block4;
                list.add(this.buildPattern(stack));
                break block4;
            }
            for (int l = 1; l <= this.n - i; ++l) {
                stack.push(new CrosswordDesignSeg2.WordPattern(i, l));
                this.buildPatterns(stack, list);
                stack.pop();
            }
        }
    }

    List<int[]> buildPatterns() {
        ArrayList<int[]> list = new ArrayList<int[]>();
        this.buildPatterns(new Stack<CrosswordDesignSeg2.WordPattern>(), list);
        return list;
    }

    private MDDCD mddFrom(MDDCD mddBlackCell, MDDCD[] mddMainDicts, MDDCD[] mddThemDicts, int ... pattern) {
        int[][] dictSelections;
        MDDCD mdd = null;
        for (int[] dictSelection : dictSelections = new EnumerationCartesian(IntStream.of(pattern).map(v -> v == 0 ? 1 : (this.thematicWords[v].length > 0 ? 2 : 1)).toArray()).toArray()) {
            int score = IntStream.range(0, pattern.length).map(i -> dictSelection[i] == 0 ? 0 : pattern[i]).sum();
            MDDCD[] mddSequence = new MDDCD[pattern.length + 1];
            for (int i2 = 0; i2 < pattern.length; ++i2) {
                mddSequence[i2] = new MDDCD(pattern[i2] == 0 ? mddBlackCell : (dictSelection[i2] == 0 ? mddMainDicts[pattern[i2]] : mddThemDicts[pattern[i2]]));
            }
            mddSequence[pattern.length] = new MDDCD(score);
            MDDCD g = MDDCD.concat(mddSequence);
            ++this.nMerges;
            mdd = mdd == null ? g : new MDDCD(mdd, g);
        }
        return mdd;
    }

    private List<MDDCD> buildMDD() {
        MDDCD[] mddMainDicts;
        MDDCD mddBlackCell = new MDDCD(26);
        for (MDDCD m : mddMainDicts = (MDDCD[])IntStream.range(0, this.n + 1).mapToObj(i -> new MDDCD(this.mainWords[i])).toArray(MDDCD[]::new)) {
            System.out.println("NNodes = " + m.nNodes());
        }
        MDDCD[] mddThemDicts = (MDDCD[])IntStream.range(0, this.n + 1).mapToObj(i -> new MDDCD(this.thematicWords[i])).toArray(MDDCD[]::new);
        List<int[]> patterns = this.buildPatterns();
        ArrayList<MDDCD> gs = new ArrayList<MDDCD>();
        int cnt = 0;
        if (this.modelVariant("or")) {
            for (int i2 = patterns.size() - 1; i2 >= 0; --i2) {
                int[][] dictSelections;
                System.out.println("passage " + i2 + " " + Kit.getFormattedUsedMemorySize() + " for pattern " + Kit.join((Object)patterns.get(i2), new String[0]));
                int[] pattern = patterns.get(i2);
                for (int[] dictSelection : dictSelections = new EnumerationCartesian(IntStream.of(pattern).map(v -> v == 0 ? 1 : (this.thematicWords[v].length > 0 ? 2 : 1)).toArray()).toArray()) {
                    int score = IntStream.range(0, pattern.length).map(j -> dictSelection[j] == 0 ? 0 : pattern[j]).sum();
                    MDDCD[] mddSequence = new MDDCD[pattern.length + 1];
                    for (int j2 = 0; j2 < pattern.length; ++j2) {
                        mddSequence[j2] = MDDCD.copy(pattern[j2] == 0 ? mddBlackCell : (dictSelection[j2] == 0 ? mddMainDicts[pattern[j2]] : mddThemDicts[pattern[j2]]));
                        System.out.println("nNodes " + mddSequence[j2].nNodes());
                    }
                    mddSequence[pattern.length] = new MDDCD(score);
                    MDDCD g = MDDCD.concat(mddSequence);
                    g.recursiveRenaming();
                    gs.add(g);
                    cnt += g.nNodes().intValue();
                }
            }
        } else {
            MDDCD mdd = null;
            for (int i3 = patterns.size() - 1; i3 >= 0; --i3) {
                MDDCD g = this.mddFrom(mddBlackCell, mddMainDicts, mddThemDicts, patterns.get(i3));
                mdd = mdd == null ? g : new MDDCD(mdd, g);
            }
            gs.add(mdd);
        }
        return gs;
    }

    @Override
    public void model() {
        this.loadWords();
        this.nMaxWords = this.nMaxWords == -1 ? (this.n + 1) / 2 : this.nMaxWords;
        int[] allScores = this.vals(0, this.range(3, this.n + 1));
        IVar.Var[][] x = this.array("x", this.size(this.n, this.n), this.dom(this.range(27)), "x[i][j] is the (number of) letter at row i and col j; 26 stands for a black point", new Types.TypeClass[0]);
        IVar.Var[] br = this.array("br", this.size(this.n), this.dom(this.range(this.n + 1)), "br[i] is the benefit at row i; 0 means that all words are from the full dictionary", new Types.TypeClass[0]);
        IVar[] bc = this.array("bc", this.size(this.n), this.dom(this.range(this.n + 1)), "bc[j] is the benefit at col j; 0 means that all words are from the full dictionary", new Types.TypeClass[0]);
        List<MDDCD> mdds = this.buildMDD();
        if (this.modelVariant("")) {
            Transitions transitions = mdds.get(0).transitions();
            this.forall(this.range(this.n), (int i) -> this.mdd((IVar.Var[])this.vars(x[i], br[i]), transitions));
            this.forall(this.range(this.n), arg_0 -> this.lambda$model$31(x, (IVar.Var[])bc, transitions, arg_0));
        }
        if (this.modelVariant("or")) {
            MDDCD[] t = (MDDCD[])mdds.stream().toArray(MDDCD[]::new);
            this.forall(this.range(this.n), (int i) -> ((Problem)this.imp()).mddOr((IVar.Var[])this.vars(x[i], br[i]), t));
            this.forall(this.range(this.n), arg_0 -> this.lambda$model$34(x, (IVar.Var[])bc, t, arg_0));
        }
        this.maximize(SUM, this.vars(br, bc));
    }

    @Override
    public void prettyDisplay(String[] values) {
        IntStream.range(0, this.n).forEach(i -> System.out.println(IntStream.range(0, this.n).mapToObj(j -> {
            int s = Integer.parseInt(values[i * this.n + j]);
            return s == 26 ? "*" : "" + (char)(97 + s);
        }).collect(Collectors.joining(""))));
    }

    private /* synthetic */ void lambda$model$34(IVar.Var[][] x, IVar.Var[] bc, MDDCD[] t, int j) {
        ((Problem)this.imp()).mddOr((IVar.Var[])this.vars(this.columnOf(x, j), bc[j]), t);
    }

    private /* synthetic */ void lambda$model$31(IVar.Var[][] x, IVar.Var[] bc, Transitions transitions, int j) {
        this.mdd((IVar.Var[])this.vars(this.columnOf(x, j), bc[j]), transitions);
    }
}

