/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import constraints.hard.extension.structures.MDDCDbef;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.enumerations.EnumerationCartesian;
import org.xcsp.common.structures.Transitions;
import org.xcsp.modeler.api.ProblemAPI;
import org.xcsp.modeler.implementation.NotData;
import problems.g4_world.CrosswordDesignSeg2;
import utility.Kit;

public class CrosswordDesignMDDbef
implements ProblemAPI {
    private static final int BLACK_CELL = 0;
    private static final int MAIN_DICTIONARY = 0;
    private static final int N_LETTERS = 26;
    int n;
    int nMaxWords;
    int wordSizeLimit;
    String mainDict;
    String thematicDict;
    @NotData
    int[][][] mainWords;
    @NotData
    int[][][] thematicWords;
    @NotData
    MDDCDbef mddStar;
    @NotData
    MDDCDbef[] mddMainDicts;
    @NotData
    MDDCDbef[] mddThemDicts;
    @NotData
    Set<Integer> scores = new HashSet<Integer>();
    @NotData
    int nMerges;

    private static Stream<String> oneLetterWords() {
        return IntStream.range(0, 26).mapToObj(i -> (char)(i + 97) + "");
    }

    private static Stream<String> twoLetterWords() {
        return IntStream.range(0, 26).mapToObj(i -> IntStream.range(0, 26).mapToObj(j -> (char)(i + 97) + "" + (char)(j + 97))).flatMap(s -> s);
    }

    private void loadWords() {
        String[] mw = (String[])Stream.concat(Stream.concat(CrosswordDesignMDDbef.oneLetterWords(), CrosswordDesignMDDbef.twoLetterWords()), this.readFileLines(this.mainDict)).filter(w -> w.length() <= (this.wordSizeLimit == -1 ? this.n : this.wordSizeLimit)).distinct().sorted().toArray(String[]::new);
        String[] tw = (String[])this.readFileLines(this.thematicDict).filter(w -> w.length() <= (this.wordSizeLimit == -1 ? this.n : this.wordSizeLimit)).distinct().sorted().toArray(String[]::new);
        this.mainWords = (int[][][])IntStream.range(0, this.n + 1).mapToObj(l -> (int[][])IntStream.range(0, mw.length).filter(i -> mw[i].length() == l).mapToObj(i -> IntStream.range(0, l).map(j -> mw[i].charAt(j) - 97).toArray()).toArray(x$0 -> new int[x$0][])).toArray(x$0 -> new int[x$0][][]);
        Kit.control(IntStream.range(1, this.n + 1).allMatch(l -> this.mainWords[l].length > 0));
        this.thematicWords = (int[][][])IntStream.range(0, this.n + 1).mapToObj(l -> (int[][])IntStream.range(0, tw.length).filter(i -> tw[i].length() == l).mapToObj(i -> IntStream.range(0, l).map(j -> tw[i].charAt(j) - 97).toArray()).toArray(x$0 -> new int[x$0][])).toArray(x$0 -> new int[x$0][][]);
    }

    int[] buildPatternTuple(List<CrosswordDesignSeg2.WordPattern> wordPatterns) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (wordPatterns.get((int)0).start > 0) {
            list.add(0);
        }
        for (int i2 = 0; i2 < wordPatterns.size(); ++i2) {
            list.add(wordPatterns.get((int)i2).length);
            if (i2 >= wordPatterns.size() - 1) continue;
            list.add(0);
        }
        if (wordPatterns.get(wordPatterns.size() - 1).nextStart() <= this.n) {
            list.add(0);
        }
        return list.stream().mapToInt(i -> i).toArray();
    }

    List<int[]> buildPatternTuples(List<CrosswordDesignSeg2.WordPattern> wordPatterns, List<int[]> tuples) {
        block4: {
            int i;
            block5: {
                block3: {
                    if (wordPatterns.size() != 0) break block3;
                    for (int i2 = 0; i2 <= 1; ++i2) {
                        for (int l = 1; l <= this.n - i2; ++l) {
                            List<CrosswordDesignSeg2.WordPattern> wordPatternsCloned = wordPatterns.stream().collect(Collectors.toList());
                            wordPatternsCloned.add(new CrosswordDesignSeg2.WordPattern(i2, l));
                            this.buildPatternTuples(wordPatternsCloned, tuples);
                        }
                    }
                    break block4;
                }
                CrosswordDesignSeg2.WordPattern last = wordPatterns.get(wordPatterns.size() - 1);
                i = last.nextStart();
                if (i != this.n && i != this.n + 1) break block5;
                if (wordPatterns.size() > this.nMaxWords) break block4;
                tuples.add(this.buildPatternTuple(wordPatterns));
                break block4;
            }
            for (int l = 1; l <= this.n - i; ++l) {
                List<CrosswordDesignSeg2.WordPattern> wordPatternsCloned = wordPatterns.stream().collect(Collectors.toList());
                wordPatternsCloned.add(new CrosswordDesignSeg2.WordPattern(i, l));
                this.buildPatternTuples(wordPatternsCloned, tuples);
            }
        }
        return tuples;
    }

    private MDDCDbef mddFrom(int ... pattern) {
        int[][] dictSelections;
        MDDCDbef mdd = null;
        for (int[] dictSelection : dictSelections = new EnumerationCartesian(IntStream.of(pattern).map(v -> v == 0 ? 1 : (this.thematicWords[v].length > 0 ? 2 : 1)).toArray()).toArray()) {
            System.out.println("t=" + Kit.join((Object)dictSelection, new String[0]) + " p=" + Kit.join((Object)pattern, new String[0]));
            int score = IntStream.range(0, pattern.length).map(i -> dictSelection[i] == 0 ? 0 : pattern[i]).sum();
            System.out.println("score" + score);
            this.scores.add(score);
            MDDCDbef[] mddSequence = (MDDCDbef[])IntStream.range(0, pattern.length + 1).mapToObj(i -> i == pattern.length ? new MDDCDbef(score) : new MDDCDbef(pattern[i] == 0 ? this.mddStar : (dictSelection[i] == 0 ? this.mddMainDicts[pattern[i]] : this.mddThemDicts[pattern[i]]))).toArray(MDDCDbef[]::new);
            MDDCDbef g = MDDCDbef.concat(mddSequence);
            ++this.nMerges;
            mdd = mdd == null ? g : new MDDCDbef(mdd, g);
        }
        return mdd;
    }

    private MDDCDbef buildMDD() {
        List<int[]> patterns = this.buildPatternTuples(new ArrayList<CrosswordDesignSeg2.WordPattern>(), new ArrayList<int[]>());
        patterns.stream().forEach(s -> System.out.println(Kit.join(s, new String[0])));
        this.mddStar = new MDDCDbef(26);
        this.mddMainDicts = (MDDCDbef[])IntStream.range(0, this.n + 1).mapToObj(i -> new MDDCDbef(this.mainWords[i])).toArray(MDDCDbef[]::new);
        this.mddThemDicts = (MDDCDbef[])IntStream.range(0, this.n + 1).mapToObj(i -> new MDDCDbef(this.thematicWords[i])).toArray(MDDCDbef[]::new);
        MDDCDbef f = this.mddFrom(patterns.get(patterns.size() - 1));
        for (int i2 = patterns.size() - 2; i2 >= 0; --i2) {
            MDDCDbef g = this.mddFrom(patterns.get(i2));
            f = new MDDCDbef(f, g);
            System.out.println("nNodes=" + f.nNodes());
            System.out.println(" i = " + i2 + "/" + patterns.size());
        }
        System.out.println("nMerges:" + this.nMerges);
        return f;
    }

    @Override
    public void model() {
        this.loadWords();
        Transitions trs = this.buildMDD().transitions();
        System.out.println(trs);
        this.nMaxWords = this.nMaxWords == -1 ? (this.n + 1) / 2 : this.nMaxWords;
        int[] scs = this.scores.stream().mapToInt(i -> i).sorted().toArray();
        IVar.Var[][] x = this.array("x", this.size(this.n, this.n), this.dom(this.range(27)), "x[i][j] is the (number of) letter at row i and col j; 26 stands for a black point", new Types.TypeClass[0]);
        IVar.Var[] br = this.array("br", this.size(this.n), this.dom(scs), "br[i] is the benefit at row i; 0 means that all words are from the full dictionary", new Types.TypeClass[0]);
        IVar[] bc = this.array("bc", this.size(this.n), this.dom(scs), "bc[j] is the benefit at col j; 0 means that all words are from the full dictionary", new Types.TypeClass[0]);
        this.forall(this.range(this.n), (int i) -> this.mdd((IVar.Var[])this.vars(x[i], br[i]), trs));
        this.forall(this.range(this.n), arg_0 -> this.lambda$model$33(x, (IVar.Var[])bc, trs, arg_0));
        this.maximize(SUM, this.vars(br, bc));
    }

    @Override
    public void prettyDisplay(String[] values) {
        IntStream.range(0, this.n).forEach(i -> System.out.println(IntStream.range(0, this.n).mapToObj(j -> {
            int s = Integer.parseInt(values[i * this.n + j]);
            return s == -1 ? "*" : "" + (char)(97 + s);
        }).collect(Collectors.joining(""))));
    }

    private /* synthetic */ void lambda$model$33(IVar.Var[][] x, IVar.Var[] bc, Transitions trs, int j) {
        this.mdd((IVar.Var[])this.vars(this.columnOf(x, j), bc[j]), trs);
    }
}

