/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;
import org.xcsp.modeler.implementation.NotData;

public class CrosswordDesignFirstUnfinished
implements ProblemAPI {
    private static final String[] letters = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
    int nRows;
    int nCols;
    int nMaxRowWords;
    int nMaxColWords;
    String[] basicWords;
    String[] themeWords;
    @NotData
    String[] allWords;
    @NotData
    boolean[] fromThemeWords;
    @NotData
    int[] oneLetterPositions;

    private void buildUniqueDictionary() {
        this.allWords = (String[])Stream.concat(Stream.of(letters), Stream.concat(Stream.of(this.basicWords), Stream.of(this.themeWords))).filter(w -> w.length() <= this.nRows).distinct().sorted().toArray(String[]::new);
        this.fromThemeWords = new boolean[this.allWords.length];
        List<String> list = Arrays.asList(this.allWords);
        Stream.of(this.themeWords).forEach(w -> {
            this.fromThemeWords[list.indexOf((Object)w)] = true;
        });
        this.oneLetterPositions = Stream.of(letters).mapToInt(l -> list.indexOf(l)).toArray();
    }

    private int[][] buildTableForTwoSuccessiveWords() {
        ArrayList<int[]> list = new ArrayList<int[]>();
        list.add(this.tuple(-1, 0, -1));
        for (int p = 0; p < this.nRows; ++p) {
            for (int s = 1; s <= this.nRows; ++s) {
                if (p + s > this.nRows) continue;
                list.add(p + s <= 11 ? this.tuple(p, s, p + s + 1) : this.tuple(p, s, -1));
            }
        }
        return (int[][])list.stream().toArray(x$0 -> new int[x$0][]);
    }

    @Override
    public void model() {
        assert (this.nRows == this.nCols);
        this.buildUniqueDictionary();
        IVar.Var[][] r = this.array("r", this.size(this.nRows, this.nMaxRowWords), this.dom(this.range(-1, this.allWords.length)), "r[i][k] is the (index of) kth word at row i; -1 means 'no word'", new Types.TypeClass[0]);
        IVar[][] c = this.array("c", this.size(this.nCols, this.nMaxColWords), this.dom(this.range(-1, this.allWords.length)), "c[j][k] is the (index of) kth word at col j; -1 means 'no word'", new Types.TypeClass[0]);
        IVar.Var[][] pr = this.array("pr", this.size(this.nRows, this.nMaxRowWords), this.dom(this.range(-1, this.nCols)), "pr[i][k] is the position (index of column) of the kth word at row i; -1 means 'no position' because 'no word'", new Types.TypeClass[0]);
        IVar.Var[][] pc = this.array("pc", this.size(this.nCols, this.nMaxColWords), this.dom(this.range(-1, this.nRows)), "pc[j][k] is the position (index of row) of the kth word at col j; -1 means 'no position' because 'no word'", new Types.TypeClass[0]);
        IVar.Var[][] sr = this.array("sr", this.size(this.nRows, this.nMaxRowWords), this.dom(this.range(this.nCols + 1)), "sr[i][k] is the size of the kth word at row i; 0 means 'no size' because 'no word'", new Types.TypeClass[0]);
        IVar.Var[][] sc = this.array("sc", this.size(this.nCols, this.nMaxColWords), this.dom(this.range(this.nRows + 1)), "sc[j][k] is the size of the kth word at col j; 0 means 'no size' because 'no word'", new Types.TypeClass[0]);
        IVar.Var[] jr = this.array("jr", this.size(this.nRows), this.dom(this.range((this.nRows + 1) / 2)), "jr[i] is the number of black cells (jokers) at row i", new Types.TypeClass[0]);
        IVar.Var[] jc = this.array("jc", this.size(this.nCols), this.dom(this.range((this.nCols + 1) / 2)), "jc[j] is the number of black cells (jokers) at col j", new Types.TypeClass[0]);
        IVar[][] x = this.array("x", this.size(this.nRows, this.nCols), this.dom(this.range(letters.length + 1)), "x[i][j] is the (number of) letter at row i and col j; 26 stands for a black point", new Types.TypeClass[0]);
        IVar.Var[][] jx = this.array("jx", this.size(this.nRows, this.nCols), this.dom(0, 1), "jx[i][j] is true iff the letter at row i and col j is a black cell (joker)", new Types.TypeClass[0]);
        int[][] sizesTable = (int[][])IntStream.range(-1, this.allWords.length).mapToObj(i -> this.tuple(i, i == -1 ? 0 : this.allWords[i].length())).toArray(x$0 -> new int[x$0][]);
        this.forall(this.range(this.nRows).range(this.nMaxRowWords), (int i, int k) -> this.extension((IVar.Var[])this.vars(r[i][k], sr[i][k]), sizesTable)).note("linking row words with their sizes");
        this.forall(this.range(this.nCols).range(this.nMaxColWords), (arg_0, arg_1) -> this.lambda$model$8((IVar.Var[][])c, sc, sizesTable, arg_0, arg_1)).note("linking col words with their sizes");
        int[][] succsTable = this.buildTableForTwoSuccessiveWords();
        this.forall(this.range(this.nRows).range(this.nMaxRowWords - 1), (int i, int k) -> this.extension((IVar.Var[])this.vars(pr[i][k], new IVar.Var[]{sr[i][k], pr[i][k + 1]}), succsTable)).note("linking row words and positions (according to their sizes)");
        this.forall(this.range(this.nCols).range(this.nMaxColWords - 1), (int j, int k) -> this.extension((IVar.Var[])this.vars(pc[j][k], new IVar.Var[]{sc[j][k], pc[j][k + 1]}), succsTable)).note("linking col words and positions (according to their sizes)");
        this.allDifferent((IVar.Var[])this.vars(r, c), this.exceptValues(IntStream.range(-1, this.oneLetterPositions.length).map(i -> i == -1 ? -1 : this.oneLetterPositions[i]).toArray()));
        this.forall(this.range(this.nRows).range(this.nCols), (arg_0, arg_1) -> this.lambda$model$12((IVar.Var[][])x, jx, arg_0, arg_1));
        this.forall(this.range(this.nRows), (int i) -> this.sum(jx[i], EQ, jr[i]));
        this.forall(this.range(this.nRows), (int j) -> this.sum(this.columnOf(jx, j), EQ, jc[j]));
        this.forall(this.range(this.nRows), (int i) -> this.sum((IVar.Var[])this.vars(sr[i], jr[i]), EQ, (long)this.nCols));
        this.forall(this.range(this.nCols), (int j) -> this.sum((IVar.Var[])this.vars(sc[j], jc[j]), EQ, (long)this.nRows));
        this.exactly((IVar.Var[])this.vars(x), 26, 26);
        this.forall(this.range(this.nRows), (int i) -> this.implication(this.eq(r[i][this.nMaxRowWords - 2], -1), this.eq(r[i][this.nMaxRowWords - 1], -1)));
        this.forall(this.range(this.nCols), arg_0 -> this.lambda$model$18((IVar.Var[][])c, arg_0));
    }

    public static void main(String[] args) {
        try (Scanner scanner = new Scanner(new File(args[0]));
             PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(args[0] + ".fmt")));){
            while (scanner.hasNextLine()) {
                out.println("\"" + scanner.nextLine() + "\", ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private /* synthetic */ void lambda$model$18(IVar.Var[][] c, int j) {
        this.implication(this.eq(c[j][this.nMaxColWords - 2], -1), this.eq(c[j][this.nMaxColWords - 1], -1));
    }

    private /* synthetic */ void lambda$model$12(IVar.Var[][] x, IVar.Var[][] jx, int i, int j) {
        this.equivalence(this.eq(x[i][j], 26), this.eq(jx[i][j], 1));
    }

    private /* synthetic */ void lambda$model$8(IVar.Var[][] c, IVar.Var[][] sc, int[][] sizesTable, int j, int k) {
        this.extension((IVar.Var[])this.vars(c[j][k], sc[j][k]), sizesTable);
    }
}

