/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.structures.Table;
import org.xcsp.modeler.api.ProblemAPI;
import org.xcsp.modeler.implementation.NotData;

public class CrosswordDesign1
implements ProblemAPI {
    private static final int N_LETTERS = 26;
    int n;
    int nMaxWords;
    int wordSizeLimit;
    String mainDict;
    String thematicDict;
    @NotData
    Map<Integer, List<int[]>> wordsPerLength;
    @NotData
    Map<Integer, int[]> wordsPointsPerLength;

    private static Stream<String> oneLetterWords() {
        return IntStream.range(0, 26).mapToObj(i -> (char)(i + 97) + "");
    }

    private static Stream<String> twoLetterWords() {
        return IntStream.range(0, 26).mapToObj(i -> IntStream.range(0, 26).mapToObj(j -> (char)(i + 97) + "" + (char)(j + 97))).flatMap(s -> s);
    }

    private int[] transform(String w) {
        return IntStream.range(0, w.length()).map(j -> w.charAt(j) - (Character.isUpperCase(w.charAt(j)) ? 65 : 97)).toArray();
    }

    private void loadWords() {
        String[] words = (String[])Stream.concat(Stream.concat(CrosswordDesign1.oneLetterWords(), CrosswordDesign1.twoLetterWords()), Stream.concat(this.readFileLines(this.mainDict), this.readFileLines(this.thematicDict))).filter(w -> w.length() <= (this.wordSizeLimit == -1 ? this.n : this.wordSizeLimit)).distinct().sorted().toArray(String[]::new);
        Map<Integer, List<String>> wordsPerLengthII = Stream.of(words).collect(Collectors.groupingBy(s -> s.length()));
        this.wordsPerLength = new HashMap<Integer, List<int[]>>();
        wordsPerLengthII.entrySet().stream().forEach(e -> this.wordsPerLength.put((Integer)e.getKey(), ((List)e.getValue()).stream().map(s -> this.transform((String)s)).collect(Collectors.toList())));
        this.wordsPointsPerLength = new HashMap<Integer, int[]>();
        this.wordsPerLength.entrySet().stream().forEach(entry -> this.wordsPointsPerLength.put((Integer)entry.getKey(), new int[((List)entry.getValue()).size()]));
        this.readFileLines(this.thematicDict).forEach(w -> {
            List l = (List)wordsPerLengthII.get(w.length());
            if (l != null) {
                int pos = l.indexOf(w);
                Utilities.control(pos >= 0, "pb");
                this.wordsPointsPerLength.get((Object)Integer.valueOf((int)w.length()))[pos] = w.length();
            }
        });
    }

    private int nMaxWordsOfLength(int l) {
        int nWordsPerLine = (this.n + 1) / (l + 1);
        return 2 * this.n * nWordsPerLine;
    }

    private int[] validCellsForStartingWordOfSize(int l, boolean horizontal) {
        return this.valuesFrom(this.range(this.n).range(this.n - l + 1), (Integer i, Integer j) -> horizontal ? i * this.n + j : j * this.n + i);
    }

    private Table tableFor(int l, int k, boolean horizontal) {
        Table table = this.table();
        table.add(new int[][]{this.range(this.n * this.n + 4).map(j -> j < 2 ? -1 : (j == 2 || j == 3 ? 0 : 0x7FFFFFFE))});
        List<int[]> words = this.wordsPerLength.get(l);
        for (int p = 0; p < words.size(); ++p) {
            for (int q : this.validCellsForStartingWordOfSize(l, horizontal)) {
                int r;
                int[] t = IntStream.generate(() -> 0x7FFFFFFE).limit(this.n * this.n + 4).toArray();
                t[0] = p;
                t[1] = q;
                t[2] = this.wordsPointsPerLength.get(l)[p];
                t[3] = l;
                int i = q / this.n;
                int j2 = q % this.n;
                int[] word = words.get(p);
                if (horizontal) {
                    if (j2 > 0) {
                        t[4 + i * this.n + j2 - 1] = 26;
                    }
                    for (r = 0; r < word.length; ++r) {
                        t[4 + i * this.n + j2 + r] = word[r];
                    }
                    if (j2 + word.length < this.n) {
                        t[4 + i * this.n + j2 + word.length] = 26;
                    }
                } else {
                    if (i > 0) {
                        t[4 + (i - 1) * this.n + j2] = 26;
                    }
                    for (r = 0; r < word.length; ++r) {
                        t[4 + (i + r) * this.n + j2] = word[r];
                    }
                    if (i + word.length < this.n) {
                        t[4 + (i + word.length) * this.n + j2] = 26;
                    }
                }
                table.add(new int[][]{t});
            }
        }
        return table;
    }

    @Override
    public void model() {
        this.loadWords();
        this.nMaxWords = this.nMaxWords == -1 ? (this.n + 1) / 2 : this.nMaxWords;
        IVar[][] x = this.array("x", this.size(this.n, this.n), this.dom(this.range(27)), "x[i][j] is the (number of) letter at row i and col j; 26 stands for a black point", new Types.TypeClass[0]);
        IVar.Var[][] wh = this.array("wh", this.size(this.n + 1, this.nMaxWordsOfLength(1)), (int l, int k) -> l > 0 && k < this.nMaxWordsOfLength(l) ? this.dom(this.range(-1, this.wordsPerLength.get(l).size())) : null, "wh[l][k] is the (index of the) kth horizontal word of length l in the grid; -1 means 'no word'", new Types.TypeClass[0]);
        IVar.Var[][] wv = this.array("wv", this.size(this.n + 1, this.nMaxWordsOfLength(1)), (int l, int k) -> l > 0 && k < this.nMaxWordsOfLength(l) ? this.dom(this.range(-1, this.wordsPerLength.get(l).size())) : null, "wv[l][k] is the (index of the) kth vertical word of length l in the grid; -1 means 'no word'", new Types.TypeClass[0]);
        IVar[][] ph = this.array("ph", this.size(this.n + 1, this.nMaxWordsOfLength(1)), (int l, int k) -> l > 0 && k < this.nMaxWordsOfLength(l) ? this.dom(-1, this.validCellsForStartingWordOfSize(l, true)) : null, "ph[l][k] is the position of the (cell index of the) kth horizontal word of length l in the grid; -1 means 'no word'", new Types.TypeClass[0]);
        IVar[][] pv = this.array("pv", this.size(this.n + 1, this.nMaxWordsOfLength(1)), (int l, int k) -> l > 0 && k < this.nMaxWordsOfLength(l) ? this.dom(-1, this.validCellsForStartingWordOfSize(l, false)) : null, "pv[l][k] is the position of the (cell index of the) kth vertical word of length l in the grid; -1 means 'no word'", new Types.TypeClass[0]);
        IVar.Var[][] bh = this.array("bh", this.size(this.n + 1, this.nMaxWordsOfLength(1)), (int i, int k) -> i > 0 && k < this.nMaxWordsOfLength(i) ? this.dom(0, i) : null, "bh[l][k] is the benefit of the kth horizontal word of length l in the grid; 0 when 'no word'", new Types.TypeClass[0]);
        IVar[][] bv = this.array("bv", this.size(this.n + 1, this.nMaxWordsOfLength(1)), (int i, int k) -> i > 0 && k < this.nMaxWordsOfLength(i) ? this.dom(0, i) : null, "bv[l][k] is the benefit of the kth vertical word of length l in the grid; 0 when 'no word'", new Types.TypeClass[0]);
        IVar[][] lh = this.array("lh", this.size(this.n + 1, this.nMaxWordsOfLength(1)), (int i, int k) -> i > 0 && k < this.nMaxWordsOfLength(i) ? this.dom(0, i) : null, "lh[l][k] is the length of the kth horizontal word of length l in the grid; 0 when 'no word'", new Types.TypeClass[0]);
        IVar[][] lv = this.array("lv", this.size(this.n + 1, this.nMaxWordsOfLength(1)), (int i, int k) -> i > 0 && k < this.nMaxWordsOfLength(i) ? this.dom(0, i) : null, "lv[l][k] is the length of the kth vertical word of length l in the grid; 0 when 'no word'", new Types.TypeClass[0]);
        IVar.Var bp = this.var("bp", this.dom(this.range(this.n * 2 + 1)), "bp is the number of black points in the grid", new Types.TypeClass[0]);
        this.forall(this.range(this.n + 1).range(this.nMaxWordsOfLength(1)), (int l, int k) -> {
            if (l > 0 && k < this.nMaxWordsOfLength(l) - 1) {
                this.implication(this.eq(wh[l][k], -1), this.eq(wh[l][k + 1], -1));
                this.implication(this.eq(wv[l][k], -1), this.eq(wv[l][k + 1], -1));
            }
        });
        this.forall(this.range(this.n + 1).range(this.nMaxWordsOfLength(1)), (arg_0, arg_1) -> this.lambda$model$24(wh, (IVar.Var[][])ph, bh, (IVar.Var[][])lh, (IVar.Var[][])x, arg_0, arg_1));
        this.forall(this.range(this.n + 1).range(this.nMaxWordsOfLength(1)), (arg_0, arg_1) -> this.lambda$model$25(wv, (IVar.Var[][])pv, (IVar.Var[][])bv, (IVar.Var[][])lv, (IVar.Var[][])x, arg_0, arg_1));
        this.allDifferent((IVar.Var[])this.vars(ph), this.exceptValue(-1));
        this.allDifferent((IVar.Var[])this.vars(pv), this.exceptValue(-1));
        this.exactly((IVar.Var[])this.vars(x), 26, bp);
        this.sum((IVar.Var[])this.vars(bp, lh), EQ, (long)(this.n * this.n));
        this.sum((IVar.Var[])this.vars(bp, lv), EQ, (long)(this.n * this.n));
        this.forall(this.range(this.n + 1), (int l) -> {
            if (l > 0) {
                this.decreasing((IVar.Var[])this.clean(wh[l]));
                this.decreasing((IVar.Var[])this.clean(wv[l]));
            }
        });
        this.forall(this.range(this.n).range(this.n), (arg_0, arg_1) -> this.lambda$model$27((IVar.Var[][])x, arg_0, arg_1));
        this.maximize(SUM, this.vars(bh, bv));
    }

    private /* synthetic */ void lambda$model$27(IVar.Var[][] x, int i, int j) {
        if (j < this.n - 1) {
            this.implication(this.eq(x[i][j], 26), this.ne(x[i][j + 1], 26));
        }
        if (i < this.n - 1) {
            this.implication(this.eq(x[i][j], 26), this.ne(x[i + 1][j], 26));
        }
    }

    private /* synthetic */ void lambda$model$25(IVar.Var[][] wv, IVar.Var[][] pv, IVar.Var[][] bv, IVar.Var[][] lv, IVar.Var[][] x, int l, int k) {
        if (l > 0 && k < this.nMaxWordsOfLength(l)) {
            this.extension((IVar.Var[])this.vars(wv[l][k], new Object[]{pv[l][k], bv[l][k], lv[l][k], x}), this.tableFor(l, k, false));
        }
    }

    private /* synthetic */ void lambda$model$24(IVar.Var[][] wh, IVar.Var[][] ph, IVar.Var[][] bh, IVar.Var[][] lh, IVar.Var[][] x, int l, int k) {
        if (l > 0 && k < this.nMaxWordsOfLength(l)) {
            this.extension((IVar.Var[])this.vars(wh[l][k], new Object[]{ph[l][k], bh[l][k], lh[l][k], x}), this.tableFor(l, k, true));
        }
    }
}

