/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import org.xcsp.common.IVar;
import org.xcsp.common.Range;
import org.xcsp.common.Types;
import org.xcsp.common.structures.Table;
import org.xcsp.modeler.api.ProblemAPI;

public class CarSequencing
implements ProblemAPI {
    CarClass[] classes;
    OptionLimit[] limits;

    private Table channelingTable() {
        Table table = this.table();
        for (int i = 0; i < this.classes.length; ++i) {
            table.add(i, this.classes[i].options);
        }
        return table;
    }

    @Override
    public void model() {
        int[] demands = this.valuesFrom(this.classes, (T c) -> c.demand);
        int nCars = this.sumOf(demands);
        int nOptions = this.limits.length;
        int nClasses = this.classes.length;
        Range allClasses = this.range(nClasses);
        IVar.Var[] c2 = this.array("c", this.size(nCars), this.dom(allClasses), "c[i] is the class of the ith assembled car", new Types.TypeClass[0]);
        IVar.Var[][] o = this.array("o", this.size(nCars, nOptions), this.dom(0, 1), "o[i][k] is 1 if the ith assembled car has option k", new Types.TypeClass[0]);
        this.cardinality(c2, allClasses, this.occurExactly(demands)).note("building the right numbers of cars per class");
        if (this.modelVariant("")) {
            this.forall(this.range(nCars).range(nClasses).range(nOptions), (int i, int j, int k) -> this.implication(this.eq(c2[i], j), this.eq(o[i][k], this.classes[j].options[k]))).note("constraints about options");
        } else if (this.modelVariant("table")) {
            Table table = this.channelingTable();
            this.forall(this.range(nCars), (int i) -> this.extension((IVar.Var[])this.vars(c2[i], o[i]), table)).note("constraints about options");
        }
        this.forall(this.range(nOptions).range(nCars), (int k, int i) -> {
            if (i <= nCars - this.limits[k].den) {
                this.sum(this.select(this.columnOf(o, k), this.range(i, i + this.limits[k].den)), LE, (long)this.limits[k].num);
            }
        }).note("constraints about option frequencies");
        this.forall(this.range(nOptions).range(nCars), (int k, int i) -> {
            int nOptionOccurrences = this.sumOf(this.valuesFrom(this.classes, (T cl) -> cl.options[k] * cl.demand));
            int nOptionsRemainingToSet = nOptionOccurrences - i * this.limits[k].num;
            int nOptionsPossibleToSet = nCars - i * this.limits[k].den;
            if (nOptionsRemainingToSet > 0 && nOptionsPossibleToSet > 0) {
                this.sum(this.select(this.columnOf(o, k), this.range(nOptionsPossibleToSet)), GE, (long)nOptionsRemainingToSet);
            }
        }).tag(REDUNDANT_CONSTRAINTS);
    }

    class OptionLimit {
        int num;
        int den;

        OptionLimit() {
        }
    }

    class CarClass {
        int demand;
        int[] options;

        CarClass() {
        }
    }
}

