/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.structures.Table;
import org.xcsp.modeler.api.ProblemAPI;

public class TravelingSalesman
implements ProblemAPI {
    int[][] distances;

    @Override
    public void model() {
        int nCities = this.distances.length;
        IVar.Var[] c = this.array("c", this.size(nCities), this.dom(this.range(nCities)), "c[i] is the ith city of the tour", new Types.TypeClass[0]);
        IVar[] d = this.array("d", this.size(nCities), this.dom(this.distances), "d[i] is the distance between the cities i and i+1", new Types.TypeClass[0]);
        this.allDifferent(c).note("Visiting each city only once");
        if (this.modelVariant("")) {
            this.forall(this.range(nCities), arg_0 -> this.lambda$model$0(c, nCities, (IVar.Var[])d, arg_0)).note("computing the distance between any two successive cities in the tour");
        } else if (this.modelVariant("table")) {
            Table table = this.table().addFrom(this.range(nCities).range(nCities), (i, j) -> i == j ? null : this.tuple((int)i, (int)j, this.distances[i][j]));
            this.forall(this.range(nCities), arg_0 -> this.lambda$model$2(c, nCities, (IVar.Var[])d, table, arg_0)).note("computing the distance between any two successive cities in the tour");
        }
        this.minimize(SUM, d);
    }

    private /* synthetic */ void lambda$model$2(IVar.Var[] c, int nCities, IVar.Var[] d, Table table, int i) {
        this.extension((IVar.Var[])this.vars(c[i], new IVar.Var[]{c[(i + 1) % nCities], d[i]}), table);
    }

    private /* synthetic */ void lambda$model$0(IVar.Var[] c, int nCities, IVar.Var[] d, int i) {
        this.element(this.distances, 0, c[i], 0, c[(i + 1) % nCities], d[i]);
    }
}

