/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;

public class ProgressiveParty
implements ProblemAPI {
    int nPeriods;
    Boat[] boats;

    @Override
    public void model() {
        int nBoats = this.boats.length;
        int[] crewSizes = Stream.of(this.boats).mapToInt(b -> b.crewSize).toArray();
        IVar[] h = this.array("h", this.size(nBoats), this.dom(0, 1), "h[b] indicates if the boat b is a host boat", new Types.TypeClass[0]);
        IVar.Var[][] s = this.array("s", this.size(nBoats, this.nPeriods), this.dom(this.range(nBoats)), "s[b][p] is the scheduled (visited) boat by the crew of boat b at period p", new Types.TypeClass[0]);
        IVar.Var[][][] g = this.array("g", this.size(nBoats, this.nPeriods, nBoats), this.dom(0, 1), "g[b1][p][b2] is 1 if s[b1][p] = b2", new Types.TypeClass[0]);
        this.forall(this.range(nBoats).range(this.nPeriods), (arg_0, arg_1) -> this.lambda$model$1(s, (IVar.Var[])h, arg_0, arg_1)).note("identifying host boats (when receiving)");
        this.forall(this.range(nBoats).range(nBoats).range(this.nPeriods), (arg_0, arg_1, arg_2) -> this.lambda$model$2(s, (IVar.Var[])h, arg_0, arg_1, arg_2)).note("identifying host boats (when visiting)");
        this.forall(this.range(nBoats).range(this.nPeriods), (int b, int p) -> this.channel(g[b][p], s[b][p])).note("channeling variables from arrays s and g");
        this.forall(this.range(nBoats).range(this.nPeriods), (int b, int p) -> this.sum(this.select(g, (int i, int j, int k) -> j == p && k == b), crewSizes, LE, (long)this.boats[b].capacity)).note("boat capacities must be respected");
        this.forall(this.range(nBoats), (int b) -> this.allDifferent(s[b], this.exceptValue(b))).note("a guest boat cannot revisit a host");
        this.forall(this.range(nBoats).range(nBoats), (int b1, int b2) -> {
            if (b1 < b2) {
                this.sum(this.treesFrom(this.range(this.nPeriods), (Integer p) -> this.eq(s[b1][p], s[b2][p])), LE, 2L);
            }
        }).note("guest crews cannot meet more than once");
        this.minimize(SUM, h).note("minimizing the number of host boats");
    }

    private /* synthetic */ void lambda$model$2(IVar.Var[][] s, IVar.Var[] h, int b1, int b2, int p) {
        if (b1 != b2) {
            this.implication(this.eq(s[b1][p], b2), h[b2]);
        }
    }

    private /* synthetic */ void lambda$model$1(IVar.Var[][] s, IVar.Var[] h, int b, int p) {
        this.equivalence(this.eq(s[b][p], b), h[b]);
    }

    class Boat {
        int capacity;
        int crewSize;

        Boat() {
        }
    }
}

