/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import java.util.stream.IntStream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.structures.Table;
import org.xcsp.modeler.api.ProblemAPI;

public class OpenStacks
implements ProblemAPI {
    int[][] orders;

    private Table shortTableFor(int max) {
        return this.table(0, 0, 0).add(IntStream.range(1, max).mapToObj(i -> this.tuple(i, 0x7FFFFFFE, 1))).add(max, 0, 0).add(max, 1, 1);
    }

    private Table shortTable2For(int t) {
        Table table = this.table().add(IntStream.range(0, t).mapToObj(i -> this.tuple(0x7FFFFFFE, i, 0))).add(IntStream.range(t + 1, this.orders[0].length).mapToObj(i -> this.tuple(i, 0x7FFFFFFE, 0)));
        for (int i2 = 0; i2 <= t; ++i2) {
            int j = t;
            while (j < this.orders[0].length) {
                table.add(i2, j++, 1);
            }
        }
        return table;
    }

    @Override
    public void model() {
        int n = this.orders.length;
        int m = this.orders[0].length;
        if (this.modelVariant().startsWith("m1")) {
            int[] nProducts = IntStream.range(0, n).map(i -> IntStream.of(this.orders[i]).sum()).toArray();
            IVar.Var[] p = this.array("p", this.size(m), this.dom(this.range(m)), "p[j] is the period (time) of the jth product", new Types.TypeClass[0]);
            IVar.Var[][] np = this.array("np", this.size(n, m), (int i, int j) -> this.dom(this.range(nProducts[i] + 1)), "np[i][j] is the number of products made at time j and required by customer i", new Types.TypeClass[0]);
            IVar.Var[][] r = this.array("r", this.size(n, m), this.dom(0, 1), "r[i][t] is 1 iff the product made at time t concerns customer i", new Types.TypeClass[0]);
            IVar.Var[][] o = this.array("o", this.size(n, m), this.dom(0, 1), "o[i][t] is 1 iff the stack is open for customer i at time t", new Types.TypeClass[0]);
            IVar[] ns = this.array("ns", this.size(m), this.dom(this.range(m + 1)), "ns[t] is the number of open stacks at time t", new Types.TypeClass[0]);
            this.allDifferent(p);
            this.forall(this.range(n).range(m), (int i, int j) -> this.element(this.orders[i], p[j], r[i][j]));
            this.forall(this.range(n).range(m), (int i, int j) -> this.equal(np[i][j], j == 0 ? r[i][j] : this.add(np[i][j - 1], r[i][j])));
            this.forall(this.range(n).range(m), (int i, int j) -> {
                Table shortTable = this.shortTableFor(nProducts[i]);
                int[][] tuples = this.modelVariant("m1") ? shortTable.toArray() : shortTable.toOrdinaryTableArray(nProducts[i] + 1, 2, 2);
                this.extension((IVar.Var[])this.vars(np[i][j], new IVar.Var[]{r[i][j], o[i][j]}), tuples);
            });
            this.forall(this.range(m), arg_0 -> this.lambda$model$8(o, (IVar.Var[])ns, arg_0));
            this.minimize(MAXIMUM, ns);
        }
        if (this.modelVariant().startsWith("m2")) {
            IVar.Var[] p = this.array("p", this.size(m), this.dom(this.range(m)), "p[j] is the period (time) of the jth product", new Types.TypeClass[0]);
            IVar.Var[] s = this.array("s", this.size(n), this.dom(this.range(m)), "s[i] is the starting time of the ith stack", new Types.TypeClass[0]);
            IVar.Var[] e = this.array("e", this.size(n), this.dom(this.range(m)), "e[i] is the ending time of the ith stack", new Types.TypeClass[0]);
            IVar.Var[][] o = this.array("o", this.size(n, m), this.dom(0, 1), "o[i][t] is 1 iff the ith stack is open at time t", new Types.TypeClass[0]);
            IVar[] ns = this.array("ns", this.size(m), this.dom(this.range(m + 1)), "ns[t] is the number of open stacks at time t", new Types.TypeClass[0]);
            this.allDifferent(p).note("all products are scheduled at different times");
            this.forall(this.range(n), (int i) -> this.minimum(this.select(p, (int j) -> this.orders[i][j] == 1), s[i])).note("computing starting times of stacks");
            this.forall(this.range(n), (int i) -> this.maximum(this.select(p, (int j) -> this.orders[i][j] == 1), e[i])).note("computing ending times of stacks");
            this.forall(this.range(n).range(m), (int i, int t) -> {
                Table table = this.shortTable2For(t);
                this.extension((IVar.Var[])this.vars(s[i], new IVar.Var[]{e[i], o[i][t]}), this.modelVariant("m2") ? table.toArray() : table.toOrdinaryTableArray(m, m, 2));
            }).note("inferring when stacks are open");
            this.forall(this.range(m), arg_0 -> this.lambda$model$14(o, (IVar.Var[])ns, arg_0)).note("computing the number of open stacks at any time");
            this.minimize(MAXIMUM, ns).note("minimizing the number of stacks that are simultaneously open");
        }
    }

    private /* synthetic */ void lambda$model$14(IVar.Var[][] o, IVar.Var[] ns, int t) {
        this.sum(this.columnOf(o, t), EQ, ns[t]);
    }

    private /* synthetic */ void lambda$model$8(IVar.Var[][] o, IVar.Var[] ns, int j) {
        this.sum(this.columnOf(o, j), EQ, ns[j]);
    }
}

