/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.enumerations.EnumerationCartesian;
import org.xcsp.modeler.api.ProblemAPI;

public class MagicSquare
implements ProblemAPI {
    int n;
    int[][] clues;

    @Override
    public void model() {
        int magic = this.n * (this.n * this.n + 1) / 2;
        IVar.Var[][] x = this.array("x", this.size(this.n, this.n), this.dom(this.rangeClosed(1, this.n * this.n)), "x[i][j] is the value at row i and column j of the magic square", new Types.TypeClass[0]);
        this.allDifferent(x);
        if (this.modelVariant("")) {
            this.forall(this.range(this.n), (int i) -> this.sum(x[i], EQ, (long)magic));
            this.forall(this.range(this.n), (int j) -> this.sum(this.columnOf(x, j), EQ, (long)magic));
            this.block(() -> {
                this.sum(this.diagonalDown(x), EQ, (long)magic);
                this.sum(this.diagonalUp(x), EQ, (long)magic);
            }).tag(DIAGONALS);
        }
        if (this.modelVariant("ext")) {
            int[][] tuples = EnumerationCartesian.tuplesWithDiffValuesSummingTo(magic, this.n * this.n, this.n, 1);
            this.forall(this.range(this.n), (int i) -> this.extension(x[i], tuples));
            this.forall(this.range(this.n), (int j) -> this.extension(this.columnOf(x, j), tuples));
            this.block(() -> {
                this.extension(this.diagonalDown(x), tuples);
                this.extension(this.diagonalUp(x), tuples);
            }).tag(DIAGONALS);
        }
        if (this.modelVariant("mdd")) {
            this.forall(this.range(this.n), (int i) -> this.sum(x[i], IN, this.rangeClosed(magic, magic)));
            this.forall(this.range(this.n), (int j) -> this.sum(this.columnOf(x, j), IN, this.rangeClosed(magic, magic)));
            this.block(() -> {
                this.sum(this.diagonalDown(x), IN, this.rangeClosed(magic, magic));
                this.sum(this.diagonalUp(x), IN, this.rangeClosed(magic, magic));
            }).tag(DIAGONALS);
        }
        this.instantiation(x, this.takingValues(this.clues), this.onlyOn((i, j) -> this.clues[i][j] != 0)).tag(CLUES).note("respecting specified clues (if any)");
    }
}

