/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.modeler.api.ProblemAPI;
import org.xcsp.modeler.implementation.NotData;

public class HCPizza
implements ProblemAPI {
    int minIngredients;
    int maxSize;
    int[][] pizza;
    @NotData
    int nRows;
    @NotData
    int nCols;
    @NotData
    int nPatterns;
    @NotData
    int[][] patterns;
    @NotData
    boolean[][][] possibleSlices;
    @NotData
    List<int[]>[][] overlaps;

    private void buildPatterns() {
        this.nRows = this.pizza.length;
        this.nCols = this.pizza[0].length;
        this.patterns = (int[][])IntStream.range(1, Math.min(this.maxSize, this.nRows) + 1).mapToObj(i -> IntStream.range(1, Math.min(this.maxSize, this.nCols) + 1).filter(j -> 2 * this.minIngredients <= i * j && i * j <= this.maxSize).mapToObj(j -> new int[]{i, j})).flatMap(t -> t).toArray(x$0 -> new int[x$0][]);
        System.out.println("patterns: " + Utilities.join(this.patterns));
        this.nPatterns = this.patterns.length;
    }

    private boolean possibleSlice(int i, int j, int height, int width) {
        int nMushrooms = 0;
        int nTomatoes = 0;
        for (int ib = i; ib < Math.min(i + height, this.nRows); ++ib) {
            for (int jb = j; jb < Math.min(j + width, this.nCols); ++jb) {
                if (this.pizza[ib][jb] == 0) {
                    ++nMushrooms;
                    continue;
                }
                ++nTomatoes;
            }
        }
        return nMushrooms >= this.minIngredients && nTomatoes >= this.minIngredients;
    }

    private void buildPossibleSlices() {
        this.overlaps = new List[this.nRows][this.nCols];
        this.possibleSlices = new boolean[this.nRows][this.nCols][this.nPatterns];
        for (int i = 0; i < this.nRows; ++i) {
            for (int j = 0; j < this.nCols; ++j) {
                for (int k = 0; k < this.nPatterns; ++k) {
                    int height = this.patterns[k][0];
                    int width = this.patterns[k][1];
                    this.possibleSlices[i][j][k] = this.possibleSlice(i, j, height, width);
                    if (!this.possibleSlices[i][j][k]) continue;
                    for (int ib = i; ib < Math.min(i + height, this.nRows); ++ib) {
                        for (int jb = j; jb < Math.min(j + width, this.nCols); ++jb) {
                            if (this.overlaps[ib][jb] == null) {
                                this.overlaps[ib][jb] = new ArrayList<int[]>();
                            }
                            this.overlaps[ib][jb].add(new int[]{i, j, k});
                        }
                    }
                }
            }
        }
    }

    private int realPatternSize(int i, int j, int k) {
        return (Math.min(i + this.patterns[k][0], this.nRows) - i) * (Math.min(j + this.patterns[k][1], this.nCols) - j);
    }

    @Override
    public void model() {
        this.buildPatterns();
        this.buildPossibleSlices();
        IVar.Var[][][] x = this.array("x", this.size(this.nRows, this.nCols, this.nPatterns), (int i, int j, int k) -> this.dom(0, 1).when(this.possibleSlices[i][j][k]), "x[i][j][k] is 1 iff the slice with left top cell at (i,j) and pattern k is selected", new Types.TypeClass[0]);
        IVar[][][] s = this.array("s", this.size(this.nRows, this.nCols, this.nPatterns), (int i, int j, int k) -> this.dom(0, this.realPatternSize(i, j, k)).when(this.possibleSlices[i][j][k]), "s[i][j][k] is the size of the slice with left top cell at (i,j) and pattern k (0 if the slice is not selected)", new Types.TypeClass[0]);
        this.forall(this.range(this.nRows).range(this.nCols).range(this.nPatterns), (arg_0, arg_1, arg_2) -> this.lambda$model$7(x, (IVar.Var[][][])s, arg_0, arg_1, arg_2));
        System.out.println("pizza1");
        this.forall(this.range(this.nRows).range(this.nCols), (int i, int j) -> {
            System.out.println(i + " " + j);
            if (this.overlaps[i][j] != null && this.overlaps[i][j].size() > 1) {
                IVar.Var[] scope = (IVar.Var[])this.variablesFrom(this.overlaps[i][j], t -> x[t[0]][t[1]][t[2]]);
                this.sum(scope, LE, 1L);
            }
        });
        System.out.println("pizza2");
        this.maximize(SUM, s);
    }

    private /* synthetic */ void lambda$model$7(IVar.Var[][][] x, IVar.Var[][][] s, int i, int j, int k) {
        if (this.possibleSlices[i][j][k]) {
            this.extension((IVar.Var[])this.vars(x[i][j][k], s[i][j][k]), this.table().add(0, 0).add(1, this.realPatternSize(i, j, k)));
        }
    }
}

