/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import constraints.hard.extension.structures.SmartTuple;
import heuristics.variables.HeuristicVariablesDynamic;
import java.util.stream.IntStream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;
import problem.Problem;
import search.backtrack.SolverBacktrack;
import variables.Variable;

public class GraphMaxAcyclic
implements ProblemAPI {
    int nNodes;
    public int[][] arcs;

    @Override
    public void model() {
        IVar.Var[] x = this.array("x", this.size(this.nNodes), this.dom(this.range(this.nNodes)), "x[i] is the number associated with the ith node", new Types.TypeClass[0]);
        this.allDifferent(x);
        if (this.modelVariant("") || this.modelVariant("cnt")) {
            IVar[][] a = this.array("a", this.size(this.nNodes, this.nNodes), (int i, int j) -> i != j && this.arcs[i][j] != 0 ? this.dom(0, 1) : null, "a[i][j] is 1 iff the arc from i to j is selected", new Types.TypeClass[0]);
            if (this.modelVariant("")) {
                this.forall(this.range(this.nNodes).range(this.nNodes), (arg_0, arg_1) -> this.lambda$model$1((IVar.Var[][])a, x, arg_0, arg_1));
            } else {
                this.forall(this.range(this.nNodes).range(this.nNodes), (arg_0, arg_1) -> this.lambda$model$2((IVar.Var[][])a, x, arg_0, arg_1));
                this.forall(this.range(this.nNodes), arg_0 -> this.lambda$model$4((IVar.Var[][])a, arg_0));
            }
            this.maximize(SUM, a, this.weightedBy(this.arcs), this.onlyOn((arg_0, arg_1) -> GraphMaxAcyclic.lambda$model$5((IVar.Var[][])a, arg_0, arg_1)));
        }
        if (this.modelVariant("smt")) {
            IVar.Var[][] c = this.array("c", this.size(this.nNodes, this.nNodes), (int i, int j) -> i < j && (this.arcs[i][j] != 0 || this.arcs[j][i] != 0) ? this.dom(this.arcs[i][j], this.arcs[j][i]) : null, "c[i][j] is the cost of the link between i and j (whatever the direction)", new Types.TypeClass[0]);
            this.forall(this.range(this.nNodes).range(this.nNodes), (int i, int j) -> {
                if (i < j && c[i][j] != null) {
                    SmartTuple st1 = new SmartTuple(this.tuple(0x7FFFFFFE, 0x7FFFFFFE, this.arcs[i][j]), this.gt(x[i], x[j]));
                    SmartTuple st2 = new SmartTuple(this.tuple(0x7FFFFFFE, 0x7FFFFFFE, this.arcs[j][i]), this.lt(x[i], x[j]));
                    ((Problem)this.imp()).smart(this.vars(x[i], new IVar.Var[]{x[j], c[i][j]}), st1, st2);
                }
            });
            this.maximize(SUM, (IVar[])this.select(c, (int i, int j) -> i < j && c[i][j] != null));
        }
    }

    private static /* synthetic */ boolean lambda$model$5(IVar.Var[][] a, int i, int j) {
        return a[i][j] != null;
    }

    private /* synthetic */ void lambda$model$4(IVar.Var[][] a, int j) {
        IVar.Var[] t = this.select(a, (int i, int k) -> k == j && a[i][j] != null);
        if (t != null && t.length > 3) {
            this.atMost(t, 1, 3);
        }
    }

    private /* synthetic */ void lambda$model$2(IVar.Var[][] a, IVar.Var[] x, int i, int j) {
        if (a[i][j] != null) {
            this.implication(this.le(x[i], x[j]), this.eq(a[i][j], 0));
        }
    }

    private /* synthetic */ void lambda$model$1(IVar.Var[][] a, IVar.Var[] x, int i, int j) {
        if (a[i][j] != null) {
            this.equivalence(this.gt(x[i], x[j]), this.eq(a[i][j], 1));
        }
    }

    public static class Flow
    extends HeuristicVariablesDynamic {
        private int[] maxInFlows;

        private int maxInFlowOf(int[][] arcs, int j) {
            int max = Integer.MIN_VALUE;
            for (int i1 = 0; i1 < arcs.length; ++i1) {
                for (int i2 = i1 + 1; i2 < arcs.length; ++i2) {
                    for (int i3 = i2 + 1; i3 < arcs.length; ++i3) {
                        if (i1 == j || i2 == j || i3 == j || arcs[i1][j] + arcs[i2][j] + arcs[i3][j] <= max) continue;
                        max = arcs[i1][j] + arcs[i2][j] + arcs[i3][j];
                    }
                }
            }
            return max;
        }

        public Flow(SolverBacktrack solver, boolean antiHeuristic) {
            super(solver, antiHeuristic);
            int[][] arcs = ((GraphMaxAcyclic)solver.pb.api).arcs;
            this.maxInFlows = IntStream.range(0, arcs.length).map(i -> this.maxInFlowOf(arcs, i)).toArray();
        }

        @Override
        public double scoreOf(Variable x) {
            return x.num < this.maxInFlows.length ? (double)this.maxInFlows[x.num] : -100000.0;
        }
    }
}

