/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;

public class GraphColoring
implements ProblemAPI {
    int nNodes;
    int[][] edges;
    Coloring[] colorings;
    Multicoloring[] multicolorings;

    @Override
    public void model() {
        int nEdges = this.edges.length;
        IVar[] c = this.array("c", this.size(this.nNodes), this.dom(this.range(this.nNodes)), "c[i] is the color assigned to the ith node", new Types.TypeClass[0]);
        this.forall(this.range(nEdges), arg_0 -> this.lambda$model$0((IVar.Var[])c, arg_0));
        if (this.colorings != null && this.colorings.length > 0) {
            Coloring[] gt1 = (Coloring[])Stream.of(this.colorings).filter(cl -> cl.colors.length > 1).toArray(Coloring[]::new);
            Coloring[] eq1 = (Coloring[])Stream.of(this.colorings).filter(cl -> cl.colors.length == 1).toArray(Coloring[]::new);
            this.forall(this.range(gt1.length), arg_0 -> this.lambda$model$5((IVar.Var[])c, gt1, arg_0)).note("nodes with subsets of prefixed colors");
            this.instantiation(Stream.of(eq1).map(arg_0 -> GraphColoring.lambda$model$6((IVar.Var[])c, arg_0)), Stream.of(eq1).mapToInt(cl -> cl.colors[0])).note("nodes with preassigned colors");
        }
        if (this.modelVariant("sum")) {
            this.minimize(SUM, c).note("minimizing the sum of colors assigned to nodes");
        } else {
            this.minimize(MAXIMUM, c);
        }
    }

    private static /* synthetic */ IVar.Var lambda$model$6(IVar.Var[] c, Coloring cl) {
        return c[cl.node];
    }

    private /* synthetic */ void lambda$model$5(IVar.Var[] c, Coloring[] gt1, int i) {
        this.extension(c[gt1[i].node], gt1[i].colors);
    }

    private /* synthetic */ void lambda$model$0(IVar.Var[] c, int i) {
        IVar.Var x = c[this.edges[i][0]];
        IVar.Var y = c[this.edges[i][1]];
        this.intension(this.edges[i][2] == 1 ? this.ne(x, y) : this.ge(this.dist(x, y), this.edges[i][2]));
    }

    class Multicoloring {
        int node;
        int nColors;
        int distance;

        Multicoloring() {
        }
    }

    class Coloring {
        int node;
        int[] colors;

        Coloring() {
        }
    }
}

