/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.structures.Table;
import org.xcsp.modeler.api.ProblemAPI;

public class Fastfood
implements ProblemAPI {
    int nDepots;
    Restaurant[] restaurants;

    @Override
    public void model() {
        int nRestaurants = this.restaurants.length;
        int[] positions = Stream.of(this.restaurants).mapToInt(r -> r.position).toArray();
        int[] allPositions = this.singleValuesIn(new Object[]{positions});
        int[][] distances = this.range(nRestaurants).range(nRestaurants).map((i, j) -> Math.abs(positions[j] - positions[i]));
        IVar.Var[][] d = this.array("d", this.size(nRestaurants, this.nDepots), (int i, int j) -> this.dom(distances[i]), "d[i][j] is the distance between the ith restaurant and the jth depot", new Types.TypeClass[0]);
        IVar[] md = this.array("md", this.size(nRestaurants), (int i) -> this.dom(distances[i]), "md[i] is the minimum distance between the ith restaurant and any depot", new Types.TypeClass[0]);
        if (this.modelVariant("")) {
            IVar.Var[] x = this.array("x", this.size(this.nDepots), this.dom(this.range(nRestaurants)), "x[j] is the index of the restaurant used as the jth depot", new Types.TypeClass[0]);
            this.forall(this.range(nRestaurants).range(this.nDepots), (int i, int j) -> this.element(distances[i], x[j], d[i][j])).note("linking positions of depots with their distances to the restaurants");
            this.forall(this.range(nRestaurants), arg_0 -> this.lambda$model$5(d, (IVar.Var[])md, arg_0)).note("computing minimum distances");
            this.strictlyIncreasing(x).tag(SYMMETRY_BREAKING);
        } else if (this.modelVariant("table")) {
            IVar.Var[] x = this.array("x", this.size(this.nDepots), this.dom(positions), "x[i] is the position of the ith depot", new Types.TypeClass[0]);
            this.forall(this.range(nRestaurants).range(this.nDepots), (int i, int j) -> {
                Table table = this.table().add(IntStream.of(allPositions).mapToObj(p -> this.tuple(p, Math.abs(p - positions[i]))));
                this.extension((IVar.Var[])this.vars(x[j], d[i][j]), table);
            }).note("linking positions of depots with their distances to the restaurants");
            this.forall(this.range(nRestaurants), arg_0 -> this.lambda$model$8(d, (IVar.Var[])md, arg_0)).note("computing minimum distances");
            this.strictlyIncreasing(x).tag(SYMMETRY_BREAKING);
        }
        this.minimize(SUM, md);
    }

    private /* synthetic */ void lambda$model$8(IVar.Var[][] d, IVar.Var[] md, int i) {
        this.minimum(d[i], md[i]);
    }

    private /* synthetic */ void lambda$model$5(IVar.Var[][] d, IVar.Var[] md, int i) {
        this.minimum(d[i], md[i]);
    }

    class Restaurant {
        String name;
        int position;

        Restaurant() {
        }
    }
}

