/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.structures.Table;
import org.xcsp.modeler.api.ProblemAPI;

public class Eternity
implements ProblemAPI {
    int n;
    int m;
    int[][] pieces;

    private Table piecesTable() {
        Table table = this.table();
        this.forall(this.range(this.n * this.m).range(4), (int i, int r) -> table.add(i, this.pieces[i][r % 4], this.pieces[i][(r + 1) % 4], this.pieces[i][(r + 2) % 4], this.pieces[i][(r + 3) % 4]));
        return table;
    }

    @Override
    public void model() {
        Utilities.control(this.n * this.m == this.pieces.length, "badly formed data");
        int maxValue = this.maxOf(this.valuesIn(this.pieces, new Object[0]));
        IVar.Var[][] id = this.array("id", this.size(this.n, this.m), this.dom(this.range(this.n * this.m)), "id[i][j] is the id of the piece at row i and column j", new Types.TypeClass[0]);
        IVar.Var[][] top = this.array("top", this.size(this.n, this.m), this.dom(this.range(maxValue + 1)), "top[i][j] is the value at the top of the piece put at row i and column j", new Types.TypeClass[0]);
        IVar.Var[][] left = this.array("left", this.size(this.n, this.m), this.dom(this.range(maxValue + 1)), "left[i][j] is the value at the left of the piece put at row i and column j", new Types.TypeClass[0]);
        IVar.Var[] bot = this.array("bot", this.size(this.m), this.dom(this.range(maxValue + 1)), "bot[j] is the value at the bottom of the piece put at the bottommost row and column j", new Types.TypeClass[0]);
        IVar.Var[] right = this.array("right", this.size(this.n), this.dom(this.range(maxValue + 1)), "right[i] is the value at the right of the piece put at the row i and the rightmost column", new Types.TypeClass[0]);
        this.allDifferent(id).note("all pieces must be placed (only once)");
        Table table = this.piecesTable();
        this.forall(this.range(this.n).range(this.m), (int i, int j) -> this.extension((IVar.Var[])this.vars(id[i][j], new IVar.Var[]{top[i][j], j < this.m - 1 ? left[i][j + 1] : right[j], i < this.n - 1 ? top[i + 1][j] : bot[j], left[i][j]}), table)).note("all pieces must be valid (i.e., must correspond to those given initially, possibly after considering some rotation)");
        this.instantiation((IVar.Var[])this.vars(this.columnOf(left, 0), new Object[]{right, top[0], bot}), 0).note("put special value 0 on borders");
    }
}

