/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;

public class Cutstock
implements ProblemAPI {
    int nPieces;
    int pieceLength;
    Item[] items;

    @Override
    public void model() {
        int nItems = this.items.length;
        int[] itemLengths = this.valuesFrom(this.items, (T item) -> item.length);
        IVar[] p = this.array("p", this.size(this.nPieces), this.dom(0, 1), "p[i] is 1 iff the ith piece of the stock is used", new Types.TypeClass[0]);
        IVar.Var[][] r = this.array("r", this.size(this.nPieces, nItems), (int i, int j) -> this.dom(this.range(this.items[j].demand + 1)), "r[i][j] is the number of items of type j built using stock piece i", new Types.TypeClass[0]);
        this.forall(this.range(nItems), (int i) -> this.sum(this.columnOf(r, i), EQ, (long)this.items[i].demand)).note("each item demand must be exactly satisfied");
        this.forall(this.range(this.nPieces), arg_0 -> this.lambda$model$3(r, (IVar.Var[])p, itemLengths, arg_0)).note("each piece of the stock cannot provide more than its length");
        this.block(() -> this.lambda$model$4((IVar.Var[])p, r)).tag(SYMMETRY_BREAKING);
        this.minimize(SUM, p).note("minimizing the number of used pieces");
    }

    private /* synthetic */ void lambda$model$4(IVar.Var[] p, IVar.Var[][] r) {
        this.decreasing(p);
        this.decreasing(r);
    }

    private /* synthetic */ void lambda$model$3(IVar.Var[][] r, IVar.Var[] p, int[] itemLengths, int i) {
        this.sum((IVar.Var[])this.vars(r[i], p[i]), this.weightedBy(this.vals(itemLengths, -this.pieceLength)), LE, 0L);
    }

    class Item {
        int length;
        int demand;

        Item() {
        }
    }
}

