/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import constraints.hard.extension.structures.SmartTuple;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;
import problem.Problem;

public class BusScheduling
implements ProblemAPI {
    int nTasks;
    int[][] shifts;

    @Override
    public void model() {
        IVar[] x;
        int nShifts = this.shifts.length;
        if (this.modelVariant("")) {
            x = this.array("x", this.size(nShifts), this.dom(0, 1), "x[i] is 1 iff the ith shift is selected", new Types.TypeClass[0]);
            this.forall(this.range(this.nTasks), arg_0 -> this.lambda$model$1((IVar.Var[])x, arg_0)).note("Each task is covered by exactly one shift");
            this.minimize(SUM, x);
        }
        if (this.modelVariant("smt")) {
            x = this.array("x", this.size(this.nTasks), (int t) -> this.dom(this.range(nShifts).select(i -> this.contains(this.shifts[i], t))), "x[t] is the shift selected to perform task t", new Types.TypeClass[0]);
            this.forall(this.range(nShifts), arg_0 -> this.lambda$model$5((IVar.Var[])x, arg_0)).note("a shift is selected for a task iff it is slected for each task it covers");
            this.minimize(NVALUES, x);
        }
    }

    private /* synthetic */ void lambda$model$5(IVar.Var[] x, int i) {
        IVar[] scp = this.select(x, this.shifts[i]);
        SmartTuple st1 = new SmartTuple(this.repeat(i, this.shifts[i].length));
        SmartTuple st2 = new SmartTuple(Stream.of(scp).map(y -> this.ne(y, i)));
        ((Problem)this.imp()).smart(scp, st1, st2);
    }

    private /* synthetic */ void lambda$model$1(IVar.Var[] x, int t) {
        this.exactly(this.select(x, (int i) -> this.contains(this.shifts[i], t)), this.takingValue(1), 1);
    }
}

