/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import java.math.BigDecimal;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;

public class Auction
implements ProblemAPI {
    Bid[] bids;

    private int[] bidValues() {
        BigDecimal[] t = (BigDecimal[])Stream.of(this.bids).map(b -> new BigDecimal(b.value).stripTrailingZeros()).toArray(BigDecimal[]::new);
        int maxScale = Stream.of(t).filter(s -> s.scale() > 0).mapToInt(s -> s.scale()).max().orElse(0);
        return this.valuesFrom(t, (T b) -> b.movePointRight(maxScale).intValueExact());
    }

    @Override
    public void model() {
        int[] allItems = this.singleValuesFrom(this.bids, (T bid) -> bid.items);
        int nBids = this.bids.length;
        int nItems = allItems.length;
        IVar[] b = this.array("b", this.size(nBids), this.dom(0, 1), "b[i] is 1 iff the ith bid is selected", new Types.TypeClass[0]);
        this.forall(this.range(nItems), arg_0 -> this.lambda$model$7(nBids, allItems, (IVar.Var[])b, arg_0)).note("avoiding intersection of bids");
        this.maximize(SUM, b, this.weightedBy(this.bidValues())).note("maximizing summed value of selected bids");
    }

    private /* synthetic */ void lambda$model$7(int nBids, int[] allItems, IVar.Var[] b, int i) {
        int[] itemBids = this.select(this.range(nBids), (int j) -> this.contains(this.bids[j].items, allItems[i]));
        if (itemBids.length > 1) {
            this.atMost1(this.select(b, itemBids), this.takingValue(1));
        }
    }

    class Bid {
        String value;
        int[] items;

        Bid() {
        }
    }
}

