/*
 * Decompiled with CFR 0.152.
 */
package problems.g2_academic;

import java.util.stream.IntStream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.structures.Table;
import org.xcsp.modeler.api.ProblemAPI;

public class WaterBucket
implements ProblemAPI {
    int c1;
    int c2;
    int c3;
    int t1;
    int t2;
    int t3;
    int h;

    private Table tableOfCapacities() {
        Table table = this.table();
        table.add(0, 0, 0);
        for (int i = 0; i <= this.c1; ++i) {
            for (int j = 0; j <= this.c2; ++j) {
                for (int k = 0; k <= this.c3; ++k) {
                    if (i + j + k != this.c1) continue;
                    table.add(i, j, k);
                }
            }
        }
        return table;
    }

    private boolean connex(int[] tuple1, int[] tuple2) {
        int a1 = tuple1[0];
        int a2 = tuple1[1];
        int a3 = tuple1[2];
        int b1 = tuple2[0];
        int b2 = tuple2[1];
        int b3 = tuple2[2];
        if (a1 == this.t1 && a2 == this.t2 && a3 == this.t3) {
            return b1 == 0 && b2 == 0 && b3 == 0;
        }
        if (a1 == 0 && a2 == 0 && a3 == 0) {
            return b1 == 0 && b2 == 0 && b3 == 0;
        }
        if (b1 == 0 && b2 == 0 && b3 == 0) {
            return false;
        }
        if (IntStream.range(0, 3).allMatch(i -> tuple1[i] != tuple2[i])) {
            return false;
        }
        if (a1 != b1 && a2 != b2) {
            return b1 == 0 || b2 == this.c2 || b2 == 0 || b1 == this.c1;
        }
        if (a1 != b1 && a3 != b3) {
            return b1 == 0 || b3 == this.c3 || b3 == 0 || b1 == this.c1;
        }
        if (a2 != b2 && a3 != b3) {
            return b2 == 0 || b3 == this.c3 || b3 == 0 || b2 == this.c2;
        }
        return false;
    }

    private Table dualTable() {
        Table table = this.table();
        int[][] tuples = this.tableOfCapacities().toArray();
        for (int i = 0; i < tuples.length; ++i) {
            for (int j = 0; j < tuples.length; ++j) {
                if (!this.connex(tuples[i], tuples[j])) continue;
                table.add(tuples[i][0], tuples[i][1], tuples[i][2], tuples[j][0], tuples[j][1], tuples[j][2]);
            }
        }
        return table;
    }

    private Table goalTable() {
        Table table = this.table();
        for (int i = 0; i < this.h; ++i) {
            int[] t = new int[this.h * 3 + 1];
            t[0] = i;
            for (int j = 1; j <= i * 3; ++j) {
                t[j] = 0x7FFFFFFE;
            }
            t[i * 3 + 1] = this.t1;
            t[i * 3 + 2] = this.t2;
            t[i * 3 + 3] = this.t3;
            table.add(new int[][]{t});
        }
        return table;
    }

    @Override
    public void model() {
        this.control(this.c1 >= this.c2 && this.c2 >= this.c3 && this.c3 > 0, "Bucket capacities must be in decreasing order");
        IVar[][] x = this.array("x", this.size(this.h, 3), (int i, int j) -> this.dom(this.rangeClosed(0, j == 0 ? this.c1 : (j == 1 ? this.c2 : this.c3))), "x[i][j] is the volume of water in bucket j at time (round) i", new Types.TypeClass[0]);
        IVar.Var k = this.var("k", this.dom(this.range(this.h)), "k is the number of transfers of water in order to reach the goal", new Types.TypeClass[0]);
        this.instantiation(x[0], this.c1, 0, 0).note("Initially, only water in bucket 1");
        Table table = this.tableOfCapacities();
        this.forall(this.range(this.h), arg_0 -> this.lambda$model$2((IVar.Var[][])x, table, arg_0));
        Table dualTable = this.dualTable();
        this.forall(this.range(this.h - 1), arg_0 -> this.lambda$model$3((IVar.Var[][])x, dualTable, arg_0));
        this.extension((IVar.Var[])this.vars(k, x), this.goalTable());
        this.minimize(k);
    }

    private /* synthetic */ void lambda$model$3(IVar.Var[][] x, Table dualTable, int i) {
        this.extension((IVar.Var[])this.vars(x[i], x[i + 1]), dualTable);
    }

    private /* synthetic */ void lambda$model$2(IVar.Var[][] x, Table table, int i) {
        this.extension(x[i], table);
    }
}

