/*
 * Decompiled with CFR 0.152.
 */
package problems.g2_academic;

import java.util.function.Predicate;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.structures.Table;
import org.xcsp.modeler.api.ProblemAPI;
import org.xcsp.modeler.implementation.NotData;

public class StillLife
implements ProblemAPI {
    int n;
    int m;
    @NotData
    Predicate<int[]> p = x -> {
        int s1 = x[0] + x[1] + x[2] + x[3] + x[5] + x[6] + x[7] + x[8];
        int s2 = x[0] * x[2] + x[2] * x[8] + x[8] * x[6] + x[6] * x[0] + x[1] + x[3] + x[5] + x[7];
        int s3 = x[1] + x[3] + x[5] + x[7];
        return !(x[4] == 1 && s1 < 2 || x[4] == 1 && s1 > 3 || x[4] == 0 && s1 == 3 || x[4] == 1 && s2 <= 1 && x[9] < 1 || x[4] == 1 && s2 <= 0 && x[9] < 2 || x[4] == 0 && s3 >= 4 && x[9] < 2 || x[4] == 0 && s3 <= 1 && x[9] < 1 || x[4] == 0 && s3 <= 0 && x[9] < 2);
    };

    @Override
    public void model() {
        Table conflicts = this.table(NEGATIVE).add(1, 1, 1);
        if (!this.modelVariant("wastage")) {
            IVar[][] x = this.array("x", this.size(this.n, this.m), this.dom(0, 1), "x[i][j] is 1 iff the cell at row i and col j is alive", new Types.TypeClass[0]);
            IVar.Var[][] a = this.array("a", this.size(this.n, this.m), this.dom(this.range(9)), "a[i][j] is the number of alive neighbours", new Types.TypeClass[0]);
            this.forall(this.range(this.n).range(this.m), (arg_0, arg_1) -> this.lambda$model$2((IVar.Var[][])x, a, arg_0, arg_1)).note("computing the numbers of alive neighbours");
            Table table = this.table("(0,0)(1, 0)(2,0)(2,1)(3,1)(4,0)(5,0)(6,0)(7,0)(8,0)");
            this.forall(this.range(this.n).range(this.m), (arg_0, arg_1) -> this.lambda$model$3(a, (IVar.Var[][])x, table, arg_0, arg_1)).note("imposing rules of the game");
            this.block(() -> this.lambda$model$8((IVar.Var[][])x, conflicts)).note("imposing rules for ensuring valid dead cells around the board");
            if (this.n == this.m) {
                this.block(() -> this.lambda$model$9((IVar.Var[][])x)).tag(SYMMETRY_BREAKING);
            }
            this.maximize(SUM, this.vars(x));
        } else {
            this.control(this.n == this.m, new Object[0]);
            IVar.Var[][] x = this.array("x", this.size(this.n + 2, this.n + 2), this.dom(0, 1), "x[i][j] is 1 iff the cell at row i and col j is alive (note that there is a border)", new Types.TypeClass[0]);
            IVar.Var[][] w = this.array("w", this.size(this.n + 2, this.n + 2), this.dom(0, 1, 2), "w[i][j] is the wastage for the cell at row i and col j", new Types.TypeClass[0]);
            IVar.Var[] ws = this.array("ws", this.size(this.n + 2), this.dom(this.range(2 * (this.n + 2) * (this.n + 2) + 1)), "ws[i] is the wastage sum for cells at row i", new Types.TypeClass[0]);
            IVar.Var z = this.var("z", this.dom(this.range(this.n * this.n + 1)), "z is the number of alive cells", new Types.TypeClass[0]);
            this.instantiation((IVar.Var[])this.vars(x[0], new Object[]{x[this.n + 1], this.columnOf(x, 0), this.columnOf(x, this.n + 1)}), this.takingValue(0)).note("cells at the border are assumed to be dead");
            this.block(() -> {
                this.slide(x[1], this.range(this.n), j -> this.extension((IVar.Var[])this.vars(x[1][j], new IVar.Var[]{x[1][j + 1], x[1][j + 2]}), conflicts));
                this.slide(x[this.n], this.range(this.n), j -> this.extension((IVar.Var[])this.vars(x[this.n][j], new IVar.Var[]{x[this.n][j + 1], x[this.n][j + 2]}), conflicts));
                this.slide(this.columnOf(x, 1), this.range(this.n), i -> this.extension((IVar.Var[])this.vars(x[i][1], new IVar.Var[]{x[i + 1][1], x[i + 2][1]}), conflicts));
                this.slide(this.columnOf(x, this.n), this.range(this.n), i -> this.extension((IVar.Var[])this.vars(x[i][this.n], new IVar.Var[]{x[i + 1][this.n], x[i + 2][this.n]}), conflicts));
            }).note("ensuring that cells at the border remain dead");
            int[][] tuples = this.allCartesian(this.vals(2, 2, 2, 2, 2, 2, 2, 2, 2, 3), this.p);
            this.forall(this.range(1, this.n + 1).range(1, this.n + 1), (int i, int j) -> {
                IVar.Var[] neighbors = this.select(x, this.range(i - 1, i + 2).range(j - 1, j + 2));
                this.extension((IVar.Var[])this.vars(neighbors, w[i][j]), tuples);
            }).note("still life + wastage constraints");
            this.block(() -> {
                this.forall(this.range(1, this.n + 1), (int j) -> this.equal(this.add(w[0][j], x[1][j]), 1));
                this.forall(this.range(1, this.n + 1), (int j) -> this.equal(this.add(w[this.n + 1][j], x[this.n][j]), 1));
                this.forall(this.range(1, this.n + 1), (int i) -> this.equal(this.add(w[i][0], x[i][1]), 1));
                this.forall(this.range(1, this.n + 1), (int i) -> this.equal(this.add(w[i][this.n + 1], x[i][this.n]), 1));
            }).note("managing wastage on the border");
            this.forall(this.range(this.n + 2), (int i) -> this.sum(i == 0 ? w[0] : (IVar.Var[])this.vars(ws[i - 1], w[i]), EQ, ws[i])).note("summing wastage");
            this.sum((IVar.Var[])this.vars(z, ws[this.n + 1]), this.vals(4, 1), EQ, (long)(2 * this.n * this.n + 4 * this.n)).note("setting the value of the objective");
            this.forall(this.range(this.n + 1), (int i) -> this.greaterEqual(this.sub(ws[this.n + 1], ws[i]), 2 * ((this.n - i) / 3) + this.n / 3)).tag(REDUNDANT_CONSTRAINTS);
            this.maximize(z).note("maximizing the number of alive cells");
        }
    }

    private /* synthetic */ void lambda$model$9(IVar.Var[][] x) {
        this.greaterEqual(x[0][0], x[this.n - 1][this.n - 1]);
        this.greaterEqual(x[0][this.n - 1], x[this.n - 1][0]);
    }

    private /* synthetic */ void lambda$model$8(IVar.Var[][] x, Table conflicts) {
        this.slide(x[0], this.range(this.m - 2), i -> this.extension((IVar.Var[])this.vars(x[0][i], new IVar.Var[]{x[0][i + 1], x[0][i + 2]}), conflicts));
        this.slide(x[this.n - 1], this.range(this.m - 2), i -> this.extension((IVar.Var[])this.vars(x[this.n - 1][i], new IVar.Var[]{x[this.n - 1][i + 1], x[this.n - 1][i + 2]}), conflicts));
        this.slide(this.columnOf(x, 0), this.range(this.n - 2), i -> this.extension((IVar.Var[])this.vars(x[i][0], new IVar.Var[]{x[i + 1][0], x[i + 2][0]}), conflicts));
        this.slide(this.columnOf(x, this.m - 1), this.range(this.n - 2), i -> this.extension((IVar.Var[])this.vars(x[i][this.m - 1], new IVar.Var[]{x[i + 1][this.m - 1], x[i + 2][this.m - 1]}), conflicts));
    }

    private /* synthetic */ void lambda$model$3(IVar.Var[][] a, IVar.Var[][] x, Table table, int i, int j) {
        this.extension((IVar.Var[])this.vars(a[i][j], x[i][j]), table);
    }

    private /* synthetic */ void lambda$model$2(IVar.Var[][] x, IVar.Var[][] a, int i, int j) {
        this.sum(this.select(x, (int k, int l) -> i - 1 <= k && k <= i + 1 && j - 1 <= l && l <= j + 1 && (k != i || l != j)), EQ, a[i][j]);
    }
}

