/*
 * Decompiled with CFR 0.152.
 */
package problems.g2_academic;

import java.util.stream.IntStream;
import org.xcsp.common.IVar;
import org.xcsp.common.Range;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;

public class SocialGolfers
implements ProblemAPI {
    int nGroups;
    int groupSize;
    int nWeeks;

    private IVar.Var[][] project3(IVar.Var[][][] m) {
        return (IVar.Var[][])IntStream.range(0, m[0][0].length).mapToObj(i -> this.select(m, (int w, int g, int p) -> p == i)).toArray(x$0 -> new IVar.Var[x$0][]);
    }

    @Override
    public void model() {
        Range allGroups = this.range(this.nGroups);
        int nPlayers = this.nGroups * this.groupSize;
        if (this.modelVariant("")) {
            IVar.Var[][] g2 = this.array("g", this.size(this.nWeeks, nPlayers), this.dom(allGroups), "g[w][p] is the group admitting on week w the player p", new Types.TypeClass[0]);
            this.forall(this.range(this.nWeeks).range(this.nWeeks).range(nPlayers).range(nPlayers), (int w1, int w2, int p1, int p2) -> {
                if (w1 < w2 && p1 < p2) {
                    this.disjunction(this.ne(g2[w1][p1], g2[w1][p2]), this.ne(g2[w2][p1], g2[w2][p2]));
                }
            }).note("ensuring that two players don't meet more than one time");
            this.forall(this.range(this.nWeeks), (int w) -> this.cardinality(g2[w], allGroups, this.occursEachExactly(this.groupSize))).note("respecting the size of the groups");
            this.block(() -> {
                this.lexMatrix(g2, INCREASING);
                this.instantiation(g2[0], this.takingValues(this.range(nPlayers).map(p -> p / this.groupSize)));
                this.forall(this.range(this.groupSize), (int k) -> this.instantiation(this.select(this.columnOf(g2, k), (int w) -> w > 0), this.takingValue(k)));
            }).tag(SYMMETRY_BREAKING);
        }
        if (this.modelVariant("01")) {
            IVar.Var[][][] x = this.array("x", this.size(this.nWeeks, this.nGroups, nPlayers), this.dom(0, 1), "x[w][g][p] is 1 iff on week w the group g admits the player p", new Types.TypeClass[0]);
            IVar.Var[][][] tw = this.array("tw", this.size(nPlayers, nPlayers, this.nWeeks), (int p1, int p2, int w) -> p1 < p2 ? this.dom(0, 1) : null, "tw[p1][p2][w] is 1 iff players p1 and p2 play together on week w", new Types.TypeClass[0]);
            IVar.Var[][][][] twg = this.array("twg", this.size(nPlayers, nPlayers, this.nWeeks, this.nGroups), (int p1, int p2, int w, int g) -> p1 < p2 ? this.dom(0, 1) : null, "twg[p1][p2][w][g] is 1 iff players p1 and p2 play together on week w in group g", new Types.TypeClass[0]);
            this.forall(this.range(this.nWeeks).range(nPlayers), (int w, int p) -> this.sum(this.select(x, (int i, int j, int k) -> i == w && k == p), EQ, 1L)).note("each week, each player plays exactly once");
            this.forall(this.range(this.nWeeks).range(this.nGroups), (int w, int g) -> this.sum(x[w][g], EQ, (long)this.groupSize)).note("each week, each group contains exactly the right number of players");
            this.forall(this.range(nPlayers), (int p1) -> this.forall(this.range(p1 + 1, nPlayers), (int p2) -> this.sum(tw[p1][p2], LE, 1L))).note("two players cannot meet twice");
            this.forall(this.range(nPlayers), (int p1) -> this.forall(this.range(p1 + 1, nPlayers).range(this.nWeeks), (int p2, int w) -> this.sum(twg[p1][p2][w], EQ, tw[p1][p2][w]))).note("deciding when two players play together");
            this.forall(this.range(this.nWeeks).range(this.nGroups).range(nPlayers).range(nPlayers), (int w, int g, int p1, int p2) -> {
                if (p1 < p2) {
                    this.equal(this.mul(x[w][g][p1], x[w][g][p2]), twg[p1][p2][w][g]);
                }
            }).note("deciding when two players play in the same group");
            this.block(() -> {
                this.forall(this.range(this.nWeeks), (int w) -> this.strictlyDecreasing(x[w])).note("each week, groups are strictly ordered");
                this.strictlyDecreasing(this.eliminateDim2(x, 0)).note("weeks are strictly ordered (it suffices to consider the first group)");
                this.strictlyDecreasing(this.project3(x)).note("golfers are strictly ordered");
            }).tag(SYMMETRY_BREAKING);
        }
    }
}

