/*
 * Decompiled with CFR 0.152.
 */
package problems.g2_academic;

import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.modeler.api.ProblemAPI;

public class DeBruijnSequence
implements ProblemAPI {
    int base;
    int n;

    @Override
    public void model() {
        int m = Utilities.power(this.base, this.n);
        int[] coeffs = this.valuesFrom(this.range(this.n), (Integer j) -> Utilities.power(this.base, this.n - j - 1));
        IVar.Var[] x = this.array("x", this.size(m), this.dom(this.range(m)), "x[i] is the ith number (in base 10) of the sequence", new Types.TypeClass[0]);
        IVar.Var[][] d = this.array("d", this.size(m, this.n), this.dom(this.range(this.base)), "d[i][j] is the jth digit in the base for the ith number of the sequence; d[i] is then the representation in the base of the ith number", new Types.TypeClass[0]);
        IVar.Var[] g = this.array("g", this.size(this.base), this.dom(this.range(m + 1)), "g[i] is the number of occurrences of digit i in the first column of array d", new Types.TypeClass[0]);
        this.allDifferent(x);
        this.forall(this.range(m), (int i) -> this.sum(d[i], this.weightedBy(coeffs), EQ, x[i])).note("linking x and d: d[i] is the representation of x[i] in base " + this.base);
        this.forall(this.range(1, m + 1).range(1, this.n), (int i, int j) -> this.equal(d[i - 1][j], d[i % m][j - 1])).note("de Bruijn condition");
        this.cardinality(this.columnOf(d, 0), this.range(this.base), this.occurExactly(g));
        this.minimum(x, this.takingValue(x[0])).tag(SYMMETRY_BREAKING);
    }
}

