/*
 * Decompiled with CFR 0.152.
 */
package problem.cliques;

import java.util.Arrays;
import search.backtrack.SolverBacktrack;
import variables.Variable;

public class GraphManager {
    private SolverBacktrack solver;
    private int[] componentNumber;
    private Variable[] bestComponent;
    private int bestComponentSize;
    private int bestComponentNumber;
    private int nComponents;
    private int[] nodeOrdering;
    private boolean[] articulations;
    private int currentOrdering;
    private int nbCycles;
    private Variable articulationPoint;

    public GraphManager(SolverBacktrack solver) {
        this.solver = solver;
        int nVariables = solver.pb.variables.length;
        this.componentNumber = new int[nVariables];
        this.nodeOrdering = new int[nVariables];
        this.articulations = new boolean[nVariables];
        this.bestComponent = new Variable[nVariables];
    }

    private int determineConnexComponentOf(Variable x, int currentComponentNumber) {
        int cnt = 1;
        boolean tree = true;
        this.componentNumber[x.num] = currentComponentNumber;
        Variable[] neighbours = x.nghs;
        if (neighbours != null && neighbours.length <= this.solver.futVars.size()) {
            for (Variable neighbour : neighbours) {
                if (!neighbour.isFuture()) continue;
                if (this.componentNumber[neighbour.num] == -1) {
                    int result = this.determineConnexComponentOf(neighbour, currentComponentNumber);
                    if (result > 0) {
                        tree = false;
                    }
                    cnt += Math.abs(result);
                    continue;
                }
                tree = false;
            }
        } else {
            for (Variable y : this.solver.futVars) {
                if (x == y || !x.isNeighbourOf(y)) continue;
                if (this.componentNumber[y.num] == -1) {
                    int result = this.determineConnexComponentOf(y, currentComponentNumber);
                    if (result > 0) {
                        tree = false;
                    }
                    cnt += Math.abs(result);
                    continue;
                }
                tree = false;
            }
        }
        return tree ? -cnt : cnt;
    }

    private boolean controlConnexComponents(Variable[] variables, int leftFrontier, int rightFrontier) {
        for (int i = 0; i < this.componentNumber.length; ++i) {
            if (this.componentNumber[i] == -1) continue;
            boolean found = false;
            for (int j = leftFrontier; !found && j <= rightFrontier; ++j) {
                if (variables[j].num != i) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public void determineConnexComponentsIn(Variable[] variables, int leftFrontier, int rightFrontier) {
        this.nComponents = 0;
        if (rightFrontier < leftFrontier) {
            return;
        }
        this.bestComponentNumber = -1;
        this.bestComponentSize = this.solver.pb.variables.length + 1;
        int bestTreeNumber = -1;
        int bestTreeSize = this.solver.pb.variables.length + 1;
        Arrays.fill(this.componentNumber, -1);
        for (int i = leftFrontier; i <= rightFrontier; ++i) {
            if (!variables[i].isFuture() || this.componentNumber[variables[i].num] != -1) continue;
            int componentSize = this.determineConnexComponentOf(variables[i], this.nComponents);
            assert (componentSize != 0);
            if (componentSize < 0 && Math.abs(componentSize) < bestTreeSize) {
                bestTreeSize = Math.abs(componentSize);
                bestTreeNumber = this.nComponents;
            }
            if (componentSize > 0 && componentSize < this.bestComponentSize) {
                this.bestComponentSize = componentSize;
                this.bestComponentNumber = this.nComponents;
            }
            ++this.nComponents;
        }
        if (this.bestComponentNumber == -1) {
            this.bestComponentSize = bestTreeSize;
            this.bestComponentNumber = bestTreeNumber;
        }
        assert (this.controlConnexComponents(variables, leftFrontier, rightFrontier));
        int cpt = 0;
        for (int i = leftFrontier; i <= rightFrontier; ++i) {
            if (this.componentNumber[variables[i].num] != this.bestComponentNumber) continue;
            this.bestComponent[cpt++] = variables[i];
        }
        assert (this.nComponents == 0 || cpt == this.bestComponentSize) : "cpt =" + cpt + " best = " + this.bestComponentSize + "nbC = " + this.nComponents;
        this.displayConnexComponents(variables, leftFrontier, rightFrontier);
    }

    public void determineConnexComponents() {
        Variable[] variables = this.solver.futVars.toArray();
        this.determineConnexComponentsIn(variables, 0, variables.length - 1);
    }

    private void displayConnexComponents(Variable[] variables, int leftFrontier, int rightFrontier) {
        for (int i = 0; i < this.nComponents; ++i) {
            int cpt = 0;
            System.out.print("Component " + i + " = { ");
            Variable var = null;
            for (int j = leftFrontier; j <= rightFrontier; ++j) {
                if (this.componentNumber[variables[j].num] != i) continue;
                var = variables[j];
                if (++cpt >= 10) continue;
                System.out.print(variables[j] + " ");
            }
            System.out.println((cpt >= 10 ? "..." : "") + "} with " + cpt + " elements" + (cpt == 1 ? " ddegrre = " + var.ddeg() : ""));
        }
    }

    private int searchAttachment(Variable varParent, Variable var, Variable varForbidden) {
        this.nodeOrdering[var.num] = ++this.currentOrdering;
        int min = this.currentOrdering;
        Variable[] neighbours = var.nghs;
        if (neighbours != null && neighbours.length <= this.solver.futVars.size()) {
            for (Variable neighbour : neighbours) {
                if (!neighbour.isFuture() || neighbour == varForbidden) continue;
                if (this.nodeOrdering[neighbour.num] == -1) {
                    int attachment = this.searchAttachment(var, neighbour, varForbidden);
                    min = Math.min(min, attachment);
                    if (attachment < this.nodeOrdering[var.num]) continue;
                    this.articulations[var.num] = true;
                    this.articulationPoint = var;
                    continue;
                }
                if (this.nodeOrdering[neighbour.num] >= this.nodeOrdering[var.num] || neighbour == varParent) continue;
                min = Math.min(min, this.nodeOrdering[neighbour.num]);
                ++this.nbCycles;
            }
        } else {
            for (Variable y : this.solver.futVars) {
                if (var == y || !var.isNeighbourOf(y) || y == varForbidden) continue;
                if (this.nodeOrdering[y.num] == -1) {
                    int attachment = this.searchAttachment(var, y, varForbidden);
                    min = Math.min(min, attachment);
                    if (attachment < this.nodeOrdering[var.num]) continue;
                    this.articulations[var.num] = true;
                    this.articulationPoint = var;
                    continue;
                }
                if (this.nodeOrdering[y.num] >= this.nodeOrdering[var.num] || y == varParent) continue;
                min = Math.min(min, this.nodeOrdering[y.num]);
                ++this.nbCycles;
            }
        }
        return min;
    }

    private Variable searchArticulationsFrom(Variable x, Variable varForbidden, boolean allowedTreeArticulation) {
        assert (x != varForbidden);
        this.nodeOrdering[x.num] = ++this.currentOrdering;
        this.nbCycles = 0;
        this.articulationPoint = null;
        int nbConnexComponentsIfAssigned = 0;
        Variable[] neighbours = x.nghs;
        if (neighbours != null && neighbours.length <= this.solver.futVars.size()) {
            for (Variable neighbour : neighbours) {
                if (!neighbour.isFuture() || neighbour == varForbidden || this.nodeOrdering[neighbour.num] != -1) continue;
                this.searchAttachment(x, neighbour, varForbidden);
                ++nbConnexComponentsIfAssigned;
            }
        } else {
            Variable y = this.solver.futVars.first();
            while (y != null) {
                if (x != y && x.isNeighbourOf(y) && y != varForbidden && this.nodeOrdering[y.num] == -1) {
                    this.searchAttachment(x, y, varForbidden);
                    ++nbConnexComponentsIfAssigned;
                }
                y = this.solver.futVars.next(x);
            }
        }
        if (nbConnexComponentsIfAssigned > 1) {
            this.articulations[x.num] = true;
            this.articulationPoint = x;
        }
        return !allowedTreeArticulation && this.nbCycles == 0 ? null : this.articulationPoint;
    }

    public void displayArticulations() {
        boolean found = false;
        for (int i = 0; i < this.articulations.length; ++i) {
            if (!this.articulations[i]) continue;
            System.out.print((!found ? "Articulation " : "") + i + " ");
            found = true;
        }
        if (found) {
            System.out.println();
        }
    }

    public Variable findFirstArticulation(Variable varForbidden, boolean allowedTreeArticulation) {
        this.currentOrdering = -1;
        Arrays.fill(this.nodeOrdering, -1);
        Arrays.fill(this.articulations, false);
        Variable x = this.solver.futVars.first();
        while (x != null) {
            Variable articulation;
            if (x != varForbidden && this.nodeOrdering[x.num] == -1 && (articulation = this.searchArticulationsFrom(x, varForbidden, allowedTreeArticulation)) != null) {
                System.out.println("Articulation " + articulation + " allowed = " + allowedTreeArticulation);
                return articulation;
            }
            x = this.solver.futVars.next(x);
        }
        return null;
    }

    public Variable findFirstArticulation(boolean allowedTreeArticulation) {
        return this.findFirstArticulation(null, allowedTreeArticulation);
    }

    public Variable findFirstVariableInArticulationPair() {
        Variable x = this.solver.futVars.first();
        while (x != null) {
            Variable varArticulation = this.findFirstArticulation(x, true);
            if (varArticulation != null) {
                return varArticulation;
            }
            x = this.solver.futVars.next(x);
        }
        return null;
    }
}

