/*
 * Decompiled with CFR 0.152.
 */
package problem;

import constraints.Constraint;
import constraints.hard.CtrExtension;
import constraints.hard.CtrIntension;
import constraints.hard.extension.CtrExtensionSmart;
import constraints.hard.extension.structures.Bits;
import constraints.hard.extension.structures.Table;
import constraints.hard.extension.structures.TableSmart;
import dashboard.Arguments;
import dashboard.ControlPanel;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import objectives.OptimizationPilot;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.predicates.TreeEvaluator;
import problem.IdentificationAllDifferent;
import problem.IdentificationAutomorphism;
import problem.Problem;
import search.local.functionalPropagators.FunctionalPropagator;
import utility.Kit;
import utility.sets.SetDense;
import variables.Variable;
import variables.domains.Domain;

public final class ProblemStuff {
    private final Problem pb;
    public final List<Variable> collectedVarsAtInit = new ArrayList<Variable>();
    public final List<Constraint> collectedCtrsAtInit = new ArrayList<Constraint>();
    public final Map<String, String> collectedTuples = new HashMap<String, String>();
    protected final Repartitioner<Integer> varDegrees;
    protected final Repartitioner<Integer> domSizes;
    protected final Repartitioner<Integer> ctrArities;
    protected final Repartitioner<Integer> tableSizes;
    protected final Repartitioner<Long> defaultCosts;
    protected final Repartitioner<String> ctrTypes;
    public int nIsolatedVars;
    public int nFixedVars;
    public int nRemovedUnaryCtrs;
    public int nSpecificCtrs;
    public int nGlobalCtrs;
    public int nMergedCtrs;
    public int nDiscardedCtrs;
    public int nAddedCtrs;
    public int nUniversalCtrs;
    public long nCcks;
    public long nEffectiveFilterings;
    public int nSharedBinaryRepresentations;
    public int nFilterCallsSTR;
    public double sumTableProportionsSTR;
    public double sumTableSizesSTR;
    private Map<String, String> mapForAutomorphismIdentification = new LinkedHashMap<String, String>();
    private Map<String, String> mapForAllDifferentIdentification = new LinkedHashMap<String, String>();
    public TreeEvaluator.ExternFunctionArity1 externFunctionArity1;
    public TreeEvaluator.ExternFunctionArity2 externFunctionArity2;
    public int nValuesRemovedAtConstructionTime;
    private Set<String> discardedVars = new HashSet<String>();
    Set<String> discardedScps = new HashSet<String>();
    public StuffOptimization stuffOptimization = new StuffOptimization();

    public final boolean mustDiscard(IVar x) {
        boolean mustDiscard;
        Object[] selectedVars = this.pb.rs.cp.settingVars.selectedVars;
        if (selectedVars.length == 0) {
            return false;
        }
        int num = this.collectedVarsAtInit.size() + this.discardedVars.size();
        boolean bl = mustDiscard = Arrays.binarySearch(selectedVars, selectedVars[0] instanceof Integer ? Integer.valueOf(num) : x.id()) < 0;
        if (mustDiscard) {
            this.discardedVars.add(x.id());
        }
        return mustDiscard;
    }

    public final boolean mustDiscard(IVar[] scp) {
        if (this.pb.rs.cp.settingVars.selectedVars.length == 0) {
            return false;
        }
        boolean mustDiscard = Stream.of(scp).map(x -> x.id()).anyMatch(id -> this.discardedVars.contains(id));
        if (mustDiscard) {
            ++this.nDiscardedCtrs;
        }
        return mustDiscard;
    }

    private boolean controlConstraintsOfConflictStructures() {
        Stream.of(this.pb.constraints).forEach(c -> Kit.control(c.conflictsStructure() == null || c.conflictsStructure().registeredCtrs().contains(c), () -> "pb cloneConstraitnStructure " + c + " " + c.conflictsStructure().firstRegisteredCtr()));
        return true;
    }

    private boolean controlUnitListsOfConflictStructures() {
        Stream.of(this.pb.constraints).filter(c -> c.conflictsStructure() != null).forEach(c -> Kit.control(c.conflictsStructure().registeredCtrs().contains(c) && c.conflictsStructure().registeredCtrs().size() == 1, () -> "pb cloneConstraitnStructure " + c + " " + c.conflictsStructure().firstRegisteredCtr()));
        return true;
    }

    public void cloneStructuresOfConstraintsWithArity(int arity, boolean onlyConflictsStructure) {
        assert (this.controlConstraintsOfConflictStructures());
        Kit.log.info("   Before cloning, mem=" + Kit.getFormattedUsedMemorySize());
        Stream.of(this.pb.constraints).filter(c -> arity == -1 || c.scp.length == arity).forEach(c -> c.cloneStructures(onlyConflictsStructure));
        Kit.log.info("   After cloning, mem=" + Kit.getFormattedUsedMemorySize());
        assert (this.controlUnitListsOfConflictStructures());
    }

    public void cloneStructuresOfConstraints(boolean onlyConflictsStructure) {
        this.cloneStructuresOfConstraintsWithArity(-1, onlyConflictsStructure);
    }

    public int nDomTypes() {
        return (int)Stream.of(this.pb.variables).mapToInt(x -> x.dom.typeIdentifier()).distinct().count();
    }

    public final int addCollectedVariable(Variable x) {
        int num = this.collectedVarsAtInit.size();
        this.collectedVarsAtInit.add(x);
        this.domSizes.add(x.dom.initSize());
        return num;
    }

    public final int addCollectedConstraint(Constraint c) {
        int num = this.collectedCtrsAtInit.size();
        this.collectedCtrsAtInit.add(c);
        this.ctrArities.add(c.scp.length);
        this.ctrTypes.add(c.getClass().getSimpleName() + (c instanceof CtrExtension ? "-" + ((CtrExtension)c).extStructure().getClass().getSimpleName() : ""));
        if (c instanceof CtrExtensionSmart) {
            this.tableSizes.add(((TableSmart)((CtrExtensionSmart)c).extStructure()).smartTuples.length);
        }
        if (c instanceof CtrExtension && ((CtrExtension)c).extStructure() instanceof Table) {
            this.tableSizes.add(((Table)((CtrExtension)c).extStructure()).tuples.length);
        }
        return num;
    }

    public int maxDomSize() {
        return this.domSizes.last();
    }

    public int maxVarDegree() {
        return this.varDegrees.last();
    }

    public int minCtrArity() {
        return this.ctrArities.first();
    }

    public int maxCtrArity() {
        return this.ctrArities.last();
    }

    protected ProblemStuff(Problem problem) {
        this.pb = problem;
        boolean verbose = problem.rs.cp.verbose > 1;
        this.varDegrees = new Repartitioner(verbose);
        this.domSizes = new Repartitioner(verbose);
        this.ctrArities = new Repartitioner(verbose);
        this.ctrTypes = new Repartitioner(verbose);
        this.tableSizes = new Repartitioner(verbose);
        this.defaultCosts = new Repartitioner(verbose);
    }

    public void updateStatsForSTR(SetDense set) {
        ++this.nFilterCallsSTR;
        if (set != null) {
            this.sumTableProportionsSTR += (double)set.limit / (double)set.capacity();
            this.sumTableSizesSTR += (double)set.limit;
        }
    }

    public boolean hasSharedExtensionStructures() {
        return Stream.of(this.pb.constraints).anyMatch(c -> c.extStructure() != null && c.extStructure().firstRegisteredCtr() != c);
    }

    public boolean hasSharedConflictsStructures() {
        return Stream.of(this.pb.constraints).anyMatch(c -> c.conflictsStructure() != null && c.conflictsStructure().firstRegisteredCtr() != c);
    }

    protected void addToMapForAutomorphismIdentification(IdentificationAutomorphism automorphismIdentification) {
        automorphismIdentification.putInMap(this.mapForAutomorphismIdentification);
    }

    protected void addToMapForAllDifferentIdentification(IdentificationAllDifferent allDifferentIdentification) {
        this.mapForAllDifferentIdentification.put("nCliques", allDifferentIdentification.nBuiltCliques + "");
    }

    public MapAtt instanceAttributes(int instanceNumber) {
        MapAtt m = new MapAtt("Instance");
        m.put("name", this.pb.name());
        m.put("framework", (Object)this.pb.framework);
        ControlPanel.Optimizing opt = this.pb.rs.cp.optimizing;
        m.put("bounds", (opt.lowerBound == Long.MIN_VALUE ? "-infty" : Long.valueOf(opt.lowerBound)) + ".." + (opt.upperBound == Long.MAX_VALUE ? "+infty" : Long.valueOf(opt.upperBound)), this.pb.framework == Types.TypeFramework.COP);
        m.put("number", instanceNumber, Arguments.nInstancesToSolve > 1);
        ControlPanel.SettingVars settings = this.pb.rs.cp.settingVars;
        if (settings.selectedVars.length > 0 || settings.instantiatedVars.length > 0 || settings.priorityVars.length > 0) {
            m.separator();
            m.put("selection", Stream.of(settings.selectedVars).map(o -> o.toString()).collect(Collectors.joining(",")), settings.selectedVars.length > 0);
            m.put("instantiation", IntStream.range(0, settings.instantiatedVars.length).mapToObj(i -> settings.instantiatedVars[i] + "=" + settings.instantiatedVals[i]).collect(Collectors.joining(",")), settings.instantiatedVars.length > 0);
            m.put("priority", Stream.of(settings.priorityVars).map(o -> o.toString()).collect(Collectors.joining(",")), settings.priorityVars.length > 0);
            m.putPositive("nStrictPriorityVars", settings.nStrictPriorityVars);
        }
        return m;
    }

    public MapAtt domainsAttributes() {
        MapAtt m = new MapAtt("Domains");
        m.put("nTypes", this.nDomTypes());
        m.put("nValues", Variable.nValidValuesFor(this.pb.variables));
        m.putPositive("nRemovedValuesAtConstruction", this.nValuesRemovedAtConstructionTime);
        m.putPositive("nPurged", this.pb.nValuesRemoved);
        m.put("sizes", this.domSizes);
        return m;
    }

    public MapAtt variablesAttributes() {
        MapAtt m = new MapAtt("Variables");
        m.put("count", this.pb.variables.length);
        m.putPositive("nDiscarded", this.discardedVars.size());
        m.putPositive("nIsolated", this.nIsolatedVars);
        m.putPositive("nFixed", this.nFixedVars);
        m.put("degrees", this.varDegrees);
        return m;
    }

    public MapAtt ctrsAttributes() {
        MapAtt m = new MapAtt("Constraints");
        m.put("count", this.pb.constraints.length);
        m.putPositive("nRemovedUnary", this.nRemovedUnaryCtrs);
        m.putPositive("nSpecific", this.nSpecificCtrs);
        m.putPositive("nMerged", this.nMergedCtrs);
        m.putPositive("nDiscarded", this.nDiscardedCtrs);
        m.putPositive("nAdded", this.nAddedCtrs);
        m.putPositive("nUniversal", this.nUniversalCtrs);
        m.put("arities", this.ctrArities);
        m.put("distribution", this.ctrTypes, true, true);
        if (((Repartitioner)this.tableSizes).repartition.size() > 0) {
            m.separator();
            m.put("tables", this.tableSizes);
            m.put("defaultCosts", this.defaultCosts.toString(), ((Repartitioner)this.defaultCosts).repartition.size() > 0);
            m.put("nTotalTuples", this.tableSizes.cumulatedSum());
        }
        m.put("automorphism", this.mapForAutomorphismIdentification.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining(" ")), this.mapForAutomorphismIdentification.size() > 0, true);
        m.put("alldiffIdent", this.mapForAllDifferentIdentification.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining(" ")), this.mapForAllDifferentIdentification.size() > 0, true);
        int nConflictsStructures = 0;
        int nSharedConflictsStructures = 0;
        int nUnbuiltConflictsStructures = 0;
        int nExtensionStructures = 0;
        int nSharedExtensionStructures = 0;
        int nEvaluationManagers = 0;
        int nSharedEvaluationManagers = 0;
        for (Constraint c : this.pb.constraints) {
            if (c instanceof CtrExtension) {
                if (c.extStructure().firstRegisteredCtr() == c) {
                    ++nExtensionStructures;
                } else {
                    ++nSharedExtensionStructures;
                }
            }
            if (c instanceof CtrIntension) {
                if (((CtrIntension)c).evaluationManager.firstRegisteredCtr() == c) {
                    ++nEvaluationManagers;
                } else {
                    ++nSharedEvaluationManagers;
                }
            }
            if (c.conflictsStructure() == null) {
                ++nUnbuiltConflictsStructures;
                continue;
            }
            if (c.conflictsStructure().firstRegisteredCtr() == c) {
                ++nConflictsStructures;
                continue;
            }
            ++nSharedConflictsStructures;
        }
        if (nExtensionStructures > 0 || nEvaluationManagers > 0 || nConflictsStructures > 0 || this.nSharedBinaryRepresentations > 0) {
            m.separator();
            m.put("nExtStructures", "(" + nExtensionStructures + ",shared:" + nSharedExtensionStructures + ")", nExtensionStructures > 0);
            m.put("nIntStructures", "(" + nEvaluationManagers + ",shared:" + nSharedEvaluationManagers + ")", nEvaluationManagers > 0);
            m.put("nCftStructures", "(" + nConflictsStructures + ",shared:" + nSharedConflictsStructures + (nUnbuiltConflictsStructures > 0 ? ",unbuilt:" + nUnbuiltConflictsStructures : "") + ")", nConflictsStructures > 0);
            m.putPositive("nSharedBinaryRepresentations", this.nSharedBinaryRepresentations);
        }
        m.separator();
        m.put("wck", (double)this.pb.rs.instanceStopwatch.getWckTime() / 1000.0);
        m.put("cpu", this.pb.rs.stopwatch.getCpuTimeInSeconds());
        m.put("mem", Kit.getFormattedUsedMemorySize());
        return m;
    }

    public MapAtt objsAttributes() {
        MapAtt m = new MapAtt("Objectives");
        m.put("way", (this.pb.optimizationPilot.minimization ? Types.TypeOptimization.MINIMIZE : Types.TypeOptimization.MAXIMIZE).shortName());
        if (this.pb.optimizationPilot.ctr != null) {
            m.put("type", this.pb.optimizationPilot.ctr.getClass().getSimpleName());
        } else {
            m.put(" exp=", ((OptimizationPilot.OptimizationPilotBasic)this.pb.optimizationPilot).optimizationExpression);
        }
        return m;
    }

    public int countUniversalConstraints() {
        int cnt = 0;
        for (Constraint c : this.pb.constraints) {
            if (!(c.extStructure() instanceof Bits)) continue;
            Variable x = c.scp[0].dom.size() < c.scp[1].dom.size() ? c.scp[0] : c.scp[1];
            long[] t2 = Variable.firstDifferentVariableIn((Variable[])c.scp, (Variable)x).dom.binaryRepresentation();
            long[][] t1s = ((Bits)c.extStructure()).bitSupsFor(c.positionOf(x));
            Domain dom = x.dom;
            boolean universal = true;
            int a = dom.first();
            while (universal && a != -1) {
                long[] t1 = t1s[a];
                for (int i = 0; universal && i < t1.length; ++i) {
                    if ((t1[i] & t2[i]) == t2[i]) continue;
                    universal = false;
                }
                a = dom.next(a);
            }
            if (!universal) continue;
            ++cnt;
        }
        return cnt;
    }

    public void computeCharacteristicPathLength() {
        Variable[] variables = this.pb.variables;
        int n = variables.length;
        double sum = 0.0;
        double[] clusteringCoefficients = new double[n];
        for (int i = 0; i < clusteringCoefficients.length; ++i) {
            int cnt = 0;
            Variable[] neighbours = variables[i].nghs;
            for (int j = 0; j < neighbours.length - 1; ++j) {
                for (int k = j + 1; k < neighbours.length; ++k) {
                    if (!neighbours[j].isNeighbourOf(neighbours[k])) continue;
                    ++cnt;
                }
            }
            clusteringCoefficients[i] = neighbours.length == 0 ? 0.0 : (neighbours.length == 1 ? 1.0 : (double)cnt * 2.0 / (double)(neighbours.length * (neighbours.length - 1)));
            sum += clusteringCoefficients[i];
        }
        Kit.log.info("\nclustering coefficient (global) " + sum / (double)this.pb.variables.length);
        double[] q4 = Kit.computeQuantileOf(clusteringCoefficients, 4, true);
        Kit.log.info("4-quantiles of local clustering coeffcients : " + Kit.join((Object)q4, new String[0]));
        double[] q10 = Kit.computeQuantileOf(clusteringCoefficients, 10, true);
        Kit.log.info("10-quantiles of local clustering coeffcients : " + Kit.join((Object)q10, new String[0]));
        int[][] matrix = new int[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                matrix[i][j] = i == j ? 0 : (variables[i].isNeighbourOf(variables[j]) ? 1 : Integer.MAX_VALUE);
            }
        }
        for (int k = 0; k < n; ++k) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    if (matrix[i][k] == Integer.MAX_VALUE || matrix[k][j] == Integer.MAX_VALUE || matrix[i][k] + matrix[k][j] >= matrix[i][j]) continue;
                    matrix[i][j] = matrix[i][k] + matrix[k][j];
                }
            }
        }
        if (Kit.isPresent(Integer.MAX_VALUE, matrix)) {
            Kit.log.warning("Pb : graph not connex");
        }
        long l = Kit.sum(matrix);
        Kit.log.info("characteristic path length : " + (double)l * 2.0 / (double)(n * (n - 1)));
        Kit.log.info("diameter : " + Kit.computeMaxOf(matrix));
    }

    public static class MapAtt {
        public static final String SEPARATOR = "separator";
        String name;
        private List<Map.Entry<String, Object>> entries = new ArrayList<Map.Entry<String, Object>>();

        public MapAtt(String name) {
            this.name = name;
        }

        public MapAtt put(String key, Object value, boolean condition, boolean separation) {
            if (condition) {
                if (separation) {
                    this.separator();
                }
                this.entries.add(new AbstractMap.SimpleEntry<String, Object>(key, value));
            }
            return this;
        }

        public MapAtt put(String key, Object value, boolean condition) {
            return this.put(key, value, condition, false);
        }

        public MapAtt putPositive(String key, Number value) {
            return this.put(key, value, value.doubleValue() > 0.0);
        }

        public MapAtt put(String key, Object value) {
            return this.put(key, value, true);
        }

        public MapAtt separator() {
            return this.put(SEPARATOR, null, true);
        }

        public List<Map.Entry<String, Object>> entries() {
            return this.entries.stream().filter(e -> e.getKey() != SEPARATOR).collect(Collectors.toCollection(ArrayList::new));
        }

        public String toString() {
            String s = (this.name.equals("Run") ? "" : "  " + this.name + "\n") + "  " + "  ";
            boolean sep = true;
            for (int i = 0; i < this.entries.size(); ++i) {
                Map.Entry<String, Object> e = this.entries.get(i);
                if (e.getKey() == SEPARATOR) {
                    s = s + "\n    ";
                    sep = true;
                    continue;
                }
                if (!sep) {
                    s = s + ", ";
                }
                s = s + e.getKey() + "=" + e.getValue();
                sep = false;
            }
            return s;
        }
    }

    public static class StuffOptimization {
        public List<FunctionalPropagator> collectedCostVarsFunctionalPropagatorsAtInit = new ArrayList<FunctionalPropagator>();
        public Collection<Variable[][]> collectedSatPreservingPermutationsAtInit = new ArrayList<Variable[][]>();
        public boolean areIndependantPermutationSets;
    }

    public static class Repartitioner<T extends Comparable<? super T>> {
        private static final int DEFAULT_MAX_VALUE = 8;
        private final int maxElementsToDisplay;
        private final Map<T, Integer> repartition = new HashMap<T, Integer>();
        private List<T> sortedKeys;

        public void add(T value) {
            Integer nb;
            if (this.sortedKeys != null) {
                this.sortedKeys = null;
            }
            this.repartition.put(value, (nb = this.repartition.get(value)) == null ? 1 : nb + 1);
        }

        private void freeze() {
            Kit.control(this.sortedKeys == null);
            this.sortedKeys = new ArrayList<T>(this.repartition.keySet());
            Collections.sort(this.sortedKeys);
        }

        public T first() {
            if (this.sortedKeys == null) {
                this.freeze();
            }
            return (T)(this.sortedKeys.size() == 0 ? null : (Comparable)this.sortedKeys.get(0));
        }

        public T last() {
            if (this.sortedKeys == null) {
                this.freeze();
            }
            return (T)(this.sortedKeys.size() == 0 ? null : (Comparable)this.sortedKeys.get(this.sortedKeys.size() - 1));
        }

        public int size() {
            return this.repartition.size();
        }

        private Repartitioner(int maxElementsToDisplay) {
            this.maxElementsToDisplay = maxElementsToDisplay;
        }

        public Repartitioner(boolean verbose) {
            this(verbose ? Integer.MAX_VALUE : 8);
        }

        public Repartitioner() {
            this(8);
        }

        public long cumulatedSum() {
            return this.repartition.entrySet().stream().mapToLong(e -> (Integer)e.getValue() * (Integer)e.getKey()).sum();
        }

        public String toString() {
            if (this.sortedKeys == null) {
                this.freeze();
            }
            String SEP = "#";
            String JOIN = ",";
            if (this.sortedKeys.size() <= this.maxElementsToDisplay) {
                return "[" + this.sortedKeys.stream().map(k -> k + SEP + this.repartition.get(k)).collect(Collectors.joining(JOIN)) + "]";
            }
            String s1 = IntStream.range(0, 4).mapToObj(i -> this.sortedKeys.get(i) + SEP + this.repartition.get(this.sortedKeys.get(i))).collect(Collectors.joining(JOIN));
            String s2 = IntStream.range(this.sortedKeys.size() - 4, this.sortedKeys.size()).mapToObj(i -> this.sortedKeys.get(i) + SEP + this.repartition.get(this.sortedKeys.get(i))).collect(Collectors.joining(JOIN));
            return "[" + s1 + "..." + s2 + "]";
        }
    }
}

